/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingWindowIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCachedWindowStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingWindowIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWindowStoreIteratorTest {
    @Test
    public void shouldIterateOverValueFromBothIterators() throws Exception {
        ArrayList<KeyValue> storeValues = new ArrayList<KeyValue>();
        ThreadCache cache = new ThreadCache(1000000L);
        String namespace = "one";
        StateSerdes stateSerdes = new StateSerdes("foo", Serdes.String(), Serdes.String());
        ArrayList<KeyValue> expectedKvPairs = new ArrayList<KeyValue>();
        for (long t = 0L; t < 100L; t += 20L) {
            KeyValue v1 = KeyValue.pair((Object)t, (Object)String.valueOf(t).getBytes());
            storeValues.add(v1);
            expectedKvPairs.add(v1);
            byte[] keyBytes = WindowStoreUtils.toBinaryKey((Object)"a", (long)(t + 10L), (int)0, (StateSerdes)stateSerdes);
            byte[] valBytes = String.valueOf(t + 10L).getBytes();
            expectedKvPairs.add(KeyValue.pair((Object)(t + 10L), (Object)valBytes));
            cache.put("one", keyBytes, new LRUCacheEntry(valBytes));
        }
        byte[] binaryFrom = WindowStoreUtils.toBinaryKey((Object)"a", (long)0L, (int)0, (StateSerdes)stateSerdes);
        byte[] binaryTo = WindowStoreUtils.toBinaryKey((Object)"a", (long)100L, (int)0, (StateSerdes)stateSerdes);
        DelegatingPeekingWindowIterator storeIterator = new DelegatingPeekingWindowIterator((WindowStoreIterator)new WindowStoreIteratorStub(storeValues.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = cache.range("one", binaryFrom, binaryTo);
        MergedSortedCachedWindowStoreIterator iterator = new MergedSortedCachedWindowStoreIterator(cacheIterator, (PeekingWindowIterator)storeIterator, new StateSerdes("name", Serdes.ByteArray(), Serdes.ByteArray()));
        int index = 0;
        while (iterator.hasNext()) {
            KeyValue next = iterator.next();
            KeyValue expected = (KeyValue)expectedKvPairs.get(index++);
            Assert.assertArrayEquals((byte[])((byte[])expected.value), (byte[])((byte[])next.value));
            Assert.assertEquals((Object)expected.key, (Object)next.key);
        }
    }

    private static class WindowStoreIteratorStub
    implements WindowStoreIterator<byte[]> {
        private final Iterator<KeyValue<Long, byte[]>> iterator;

        public WindowStoreIteratorStub(Iterator<KeyValue<Long, byte[]>> iterator) {
            this.iterator = iterator;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public KeyValue<Long, byte[]> next() {
            return this.iterator.next();
        }

        public void remove() {
        }
    }
}

