/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheKeyValueStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergedSortedCacheKeyValueStoreIteratorTest {
    private final String namespace = "one";
    private final StateSerdes<byte[], byte[]> serdes = new StateSerdes("one", Serdes.ByteArray(), Serdes.ByteArray());
    private KeyValueStore<Bytes, byte[]> store;
    private ThreadCache cache;

    @Before
    public void setUp() throws Exception {
        this.store = new InMemoryKeyValueStore<Bytes, byte[]>("one");
        this.cache = new ThreadCache(10000L);
    }

    @Test
    public void shouldIterateOverRange() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}};
        for (int i = 0; i < bytes.length; i += 2) {
            this.store.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            this.cache.put("one", bytes[i + 1], new LRUCacheEntry(bytes[i + 1]));
        }
        Bytes from = Bytes.wrap((byte[])new byte[]{2});
        Bytes to = Bytes.wrap((byte[])new byte[]{9});
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator(this.store.range((Object)from, (Object)to));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("one", from.get(), to.get());
        MergedSortedCacheKeyValueStoreIterator iterator = new MergedSortedCacheKeyValueStoreIterator(cacheIterator, (PeekingKeyValueIterator)storeIterator, this.serdes);
        byte[][] values = new byte[8][];
        int index = 0;
        int bytesIndex = 2;
        while (iterator.hasNext()) {
            byte[] value = (byte[])iterator.next().value;
            values[index++] = value;
            Assert.assertArrayEquals((byte[])bytes[bytesIndex++], (byte[])value);
        }
    }

    @Test
    public void shouldSkipLargerDeletedCacheValue() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}};
        this.store.put((Object)Bytes.wrap((byte[])bytes[0]), (Object)bytes[0]);
        this.cache.put("one", bytes[1], new LRUCacheEntry(null));
        MergedSortedCacheKeyValueStoreIterator<byte[], byte[]> iterator = this.createIterator();
        Assert.assertArrayEquals((byte[])bytes[0], (byte[])((byte[])iterator.next().key));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldSkipSmallerDeletedCachedValue() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}};
        this.cache.put("one", bytes[0], new LRUCacheEntry(null));
        this.store.put((Object)Bytes.wrap((byte[])bytes[1]), (Object)bytes[1]);
        MergedSortedCacheKeyValueStoreIterator<byte[], byte[]> iterator = this.createIterator();
        Assert.assertArrayEquals((byte[])bytes[1], (byte[])((byte[])iterator.next().key));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldIgnoreIfDeletedInCacheButExistsInStore() throws Exception {
        byte[][] bytes = new byte[][]{{0}};
        this.cache.put("one", bytes[0], new LRUCacheEntry(null));
        this.store.put((Object)Bytes.wrap((byte[])bytes[0]), (Object)bytes[0]);
        MergedSortedCacheKeyValueStoreIterator<byte[], byte[]> iterator = this.createIterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotHaveNextIfAllCachedItemsDeleted() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}};
        for (int i = 0; i < bytes.length; ++i) {
            this.store.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            this.cache.put("one", bytes[i], new LRUCacheEntry(null));
        }
        Assert.assertFalse((boolean)this.createIterator().hasNext());
    }

    @Test
    public void shouldNotHaveNextIfOnlyCacheItemsAndAllDeleted() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}};
        for (int i = 0; i < bytes.length; ++i) {
            this.cache.put("one", bytes[i], new LRUCacheEntry(null));
        }
        Assert.assertFalse((boolean)this.createIterator().hasNext());
    }

    @Test
    public void shouldSkipAllDeletedFromCache() throws Exception {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}};
        for (int i = 0; i < bytes.length; ++i) {
            this.store.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            this.cache.put("one", bytes[i], new LRUCacheEntry(bytes[i]));
        }
        this.cache.put("one", bytes[1], new LRUCacheEntry(null));
        this.cache.put("one", bytes[2], new LRUCacheEntry(null));
        this.cache.put("one", bytes[3], new LRUCacheEntry(null));
        this.cache.put("one", bytes[8], new LRUCacheEntry(null));
        this.cache.put("one", bytes[11], new LRUCacheEntry(null));
        MergedSortedCacheKeyValueStoreIterator<byte[], byte[]> iterator = this.createIterator();
        Assert.assertArrayEquals((byte[])bytes[0], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[4], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[5], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[6], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[7], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[9], (byte[])((byte[])iterator.next().key));
        Assert.assertArrayEquals((byte[])bytes[10], (byte[])((byte[])iterator.next().key));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private MergedSortedCacheKeyValueStoreIterator<byte[], byte[]> createIterator() {
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.all("one");
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator(this.store.all());
        return new MergedSortedCacheKeyValueStoreIterator(cacheIterator, (PeekingKeyValueIterator)storeIterator, this.serdes);
    }
}

