/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;

class InMemoryKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    private final TreeMap<K, V> map = new TreeMap();
    private final String name;
    private boolean open = true;

    InMemoryKeyValueStore(String name) {
        this.name = name;
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V putIfAbsent(K key, V value) {
        V orig = this.map.get(key);
        if (orig == null) {
            this.map.put(key, value);
        }
        return orig;
    }

    public void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.map.put(entry.key, entry.value);
        }
    }

    public V delete(K key) {
        return this.map.remove(key);
    }

    public long approximateNumEntries() {
        return this.map.size();
    }

    public String name() {
        return this.name;
    }

    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
        this.open = false;
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public KeyValueIterator<K, V> range(K from, K to) {
        return new TheIterator(this.map.subMap(from, true, to, false).entrySet().iterator());
    }

    public KeyValueIterator<K, V> all() {
        return new TheIterator(this.map.entrySet().iterator());
    }

    private class TheIterator
    implements KeyValueIterator<K, V> {
        private final Iterator<Map.Entry<K, V>> underlying;

        public TheIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.underlying = iterator;
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        public KeyValue<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry next = this.underlying.next();
            return new KeyValue(next.getKey(), next.getValue());
        }

        public void remove() {
        }
    }
}

