/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingWindowIterator;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingPeekingWindowIteratorTest {
    private static final long DEFAULT_TIMESTAMP = 0L;
    private WindowStore<String, String> store;

    @Before
    public void setUp() throws Exception {
        this.store = new RocksDBWindowStore("test", 30000L, 3, false, Serdes.String(), Serdes.String());
        MockProcessorContext context = new MockProcessorContext(null, TestUtils.tempDirectory(), null, null, (RecordCollector)null, null);
        context.setRecordContext((RecordContext)new ProcessorRecordContext(0L, 0L, 0, "topic"));
        this.store.init((ProcessorContext)context, this.store);
    }

    @Test
    public void shouldPeekNext() throws Exception {
        KeyValue expected = KeyValue.pair((Object)0L, (Object)"A");
        this.store.put((Object)"A", (Object)"A");
        DelegatingPeekingWindowIterator peekingIterator = new DelegatingPeekingWindowIterator(this.store.fetch((Object)"A", 0L, 0L));
        Assert.assertEquals((Object)expected, (Object)peekingIterator.peekNext());
        Assert.assertEquals((Object)expected, (Object)peekingIterator.peekNext());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
    }

    @Test
    public void shouldPeekAndIterate() throws Exception {
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        for (long t = 0L; t < 50L; t += 10L) {
            this.store.put((Object)"a", (Object)String.valueOf(t), t);
            expected.add(KeyValue.pair((Object)t, (Object)String.valueOf(t)));
        }
        DelegatingPeekingWindowIterator peekingIterator = new DelegatingPeekingWindowIterator(this.store.fetch((Object)"a", 0L, 50L));
        int index = 0;
        while (peekingIterator.hasNext()) {
            KeyValue peekNext = peekingIterator.peekNext();
            KeyValue key = peekingIterator.next();
            Assert.assertEquals(expected.get(index), (Object)peekNext);
            Assert.assertEquals(expected.get(index), (Object)key);
            ++index;
        }
        Assert.assertEquals((long)expected.size(), (long)index);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndNextCalled() throws Exception {
        DelegatingPeekingWindowIterator peekingIterator = new DelegatingPeekingWindowIterator(this.store.fetch((Object)"b", 10L, 10L));
        peekingIterator.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndPeekNextCalled() throws Exception {
        DelegatingPeekingWindowIterator peekingIterator = new DelegatingPeekingWindowIterator(this.store.fetch((Object)"b", 10L, 10L));
        peekingIterator.peekNext();
    }
}

