/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreStub;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlyWindowStoreTest {
    private final String storeName = "window-store";
    private StateStoreProviderStub stubProviderOne;
    private StateStoreProviderStub stubProviderTwo;
    private CompositeReadOnlyWindowStore<String, String> windowStore;
    private ReadOnlyWindowStoreStub<String, String> underlyingWindowStore;
    private ReadOnlyWindowStoreStub<String, String> otherUnderlyingStore;

    @Before
    public void before() {
        this.stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.underlyingWindowStore = new ReadOnlyWindowStoreStub();
        this.stubProviderOne.addStore("window-store", this.underlyingWindowStore);
        this.otherUnderlyingStore = new ReadOnlyWindowStoreStub();
        this.stubProviderOne.addStore("other-window-store", this.otherUnderlyingStore);
        this.windowStore = new CompositeReadOnlyWindowStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(this.stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.windowStore(), "window-store");
    }

    @Test
    public void shouldFetchValuesFromWindowStore() throws Exception {
        this.underlyingWindowStore.put("my-key", "my-value", 0L);
        this.underlyingWindowStore.put("my-key", "my-later-value", 10L);
        WindowStoreIterator iterator = this.windowStore.fetch((Object)"my-key", 0L, 25L);
        List results = CompositeReadOnlyWindowStoreTest.toList(iterator);
        Assert.assertEquals(Arrays.asList(new KeyValue((Object)0L, (Object)"my-value"), new KeyValue((Object)10L, (Object)"my-later-value")), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() throws Exception {
        WindowStoreIterator iterator = this.windowStore.fetch((Object)"my-key", 0L, 25L);
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() throws Exception {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>();
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("key-one", "value-one", 0L);
        secondUnderlying.put("key-two", "value-two", 10L);
        List keyOneResults = CompositeReadOnlyWindowStoreTest.toList(this.windowStore.fetch((Object)"key-one", 0L, 1L));
        List keyTwoResults = CompositeReadOnlyWindowStoreTest.toList(this.windowStore.fetch((Object)"key-two", 10L, 11L));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)0L, (Object)"value-one")), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair((Object)10L, (Object)"value-two")), keyTwoResults);
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() throws Exception {
        this.otherUnderlyingStore.put("some-key", "some-value", 0L);
        this.underlyingWindowStore.put("some-key", "my-value", 1L);
        List results = CompositeReadOnlyWindowStoreTest.toList(this.windowStore.fetch((Object)"some-key", 0L, 2L));
        Assert.assertEquals(Collections.singletonList(new KeyValue((Object)1L, (Object)"my-value")), results);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() throws Exception {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore((StateStoreProvider)new StateStoreProviderStub(true), QueryableStoreTypes.windowStore(), "foo");
        store.fetch((Object)"key", 1L, 10L);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStateStoreExceptionIfFetchThrows() throws Exception {
        this.underlyingWindowStore.setOpen(false);
        this.underlyingWindowStore.fetch("key", 1L, 10L);
    }

    static <K, V> List<KeyValue<K, V>> toList(Iterator<KeyValue<K, V>> iterator) {
        ArrayList<KeyValue<K, V>> results = new ArrayList<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }
}

