/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStoreTest;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StateStoreTestUtils;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlyKeyValueStoreTest {
    private final String storeName = "my-store";
    private StateStoreProviderStub stubProviderTwo;
    private KeyValueStore<String, String> stubOneUnderlying;
    private CompositeReadOnlyKeyValueStore<String, String> theStore;
    private KeyValueStore<String, String> otherUnderlyingStore;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.stubOneUnderlying = this.newStoreInstance();
        stubProviderOne.addStore("my-store", (StateStore)this.stubOneUnderlying);
        this.otherUnderlyingStore = this.newStoreInstance();
        stubProviderOne.addStore("other-store", (StateStore)this.otherUnderlyingStore);
        this.theStore = new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.keyValueStore(), "my-store");
    }

    private KeyValueStore<String, String> newStoreInstance() {
        return StateStoreTestUtils.newKeyValueStore("my-store", String.class, String.class);
    }

    @Test
    public void shouldReturnNullIfKeyDoesntExist() throws Exception {
        Assert.assertNull((Object)this.theStore.get((Object)"whatever"));
    }

    @Test
    public void shouldReturnValueIfExists() throws Exception {
        this.stubOneUnderlying.put((Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)this.theStore.get((Object)"key"));
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() throws Exception {
        this.otherUnderlyingStore.put((Object)"otherKey", (Object)"otherValue");
        Assert.assertNull((Object)this.theStore.get((Object)"otherKey"));
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() throws Exception {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        cache.put((Object)"key-two", (Object)"key-two-value");
        this.stubOneUnderlying.put((Object)"key-one", (Object)"key-one-value");
        Assert.assertEquals((Object)"key-two-value", (Object)this.theStore.get((Object)"key-two"));
        Assert.assertEquals((Object)"key-one-value", (Object)this.theStore.get((Object)"key-one"));
    }

    @Test
    public void shouldSupportRange() throws Exception {
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"c", (Object)"c");
        List results = CompositeReadOnlyWindowStoreTest.toList(this.theStore.range((Object)"a", (Object)"c"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldSupportRangeAcrossMultipleKVStores() throws Exception {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = CompositeReadOnlyWindowStoreTest.toList(this.theStore.range((Object)"a", (Object)"e"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void shouldSupportAllAcrossMultipleStores() throws Exception {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = CompositeReadOnlyWindowStoreTest.toList(this.theStore.all());
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"x", (Object)"x")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"z", (Object)"z")));
        Assert.assertEquals((long)6L, (long)results.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionDuringRebalance() throws Exception {
        this.rebalancing().get((Object)"anything");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnRangeDuringRebalance() throws Exception {
        this.rebalancing().range((Object)"anything", (Object)"something");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnAllDuringRebalance() throws Exception {
        this.rebalancing().all();
    }

    @Test
    public void shouldGetApproximateEntriesAcrossAllStores() throws Exception {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        Assert.assertEquals((long)6L, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnOverflow() throws Exception {
        this.stubProviderTwo.addStore("my-store", new StateStoreTestUtils.NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubOneUnderlying.put((Object)"overflow", (Object)"me");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    private CompositeReadOnlyKeyValueStore<Object, Object> rebalancing() {
        return new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true))), QueryableStoreTypes.keyValueStore(), "my-store");
    }
}

