/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.smoketest;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.smoketest.SmokeTestClient;
import org.apache.kafka.streams.smoketest.SmokeTestDriver;

public class StreamsSmokeTest {
    public static void main(String[] args) throws Exception {
        String command = args[0];
        String kafka = args.length > 1 ? args[1] : null;
        String zookeeper = args.length > 2 ? args[2] : null;
        String stateDir = args.length > 3 ? args[3] : null;
        System.out.println("StreamsSmokeTest instance started");
        System.out.println("command=" + command);
        System.out.println("kafka=" + kafka);
        System.out.println("zookeeper=" + zookeeper);
        System.out.println("stateDir=" + stateDir);
        switch (command) {
            case "standalone": {
                SmokeTestDriver.main(args);
                break;
            }
            case "run": {
                int numKeys = 10;
                int maxRecordsPerKey = 500;
                Map<String, Set<Integer>> allData = SmokeTestDriver.generate(kafka, 10, 500);
                SmokeTestDriver.verify(kafka, allData, 500);
                break;
            }
            case "process": {
                final SmokeTestClient client = new SmokeTestClient(new File(stateDir), kafka, zookeeper);
                client.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        client.close();
                    }
                });
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
            }
        }
    }
}

