/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.smoketest;

import java.io.File;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public class SmokeTestUtil {
    public static final int WINDOW_SIZE = 100;
    public static final long START_TIME = 946080000000L;
    public static final int END = Integer.MAX_VALUE;
    public static Serde<String> stringSerde = Serdes.String();
    public static Serde<Integer> intSerde = Serdes.Integer();
    public static Serde<Long> longSerde = Serdes.Long();
    public static Serde<Double> doubleSerde = Serdes.Double();

    public static <T> ProcessorSupplier<String, T> printProcessorSupplier(String topic) {
        return SmokeTestUtil.printProcessorSupplier(topic, false);
    }

    public static <T> ProcessorSupplier<String, T> printProcessorSupplier(final String topic, final boolean printOffset) {
        return new ProcessorSupplier<String, T>(){

            public Processor<String, T> get() {
                return new AbstractProcessor<String, T>(){
                    private int numRecordsProcessed = 0;
                    private ProcessorContext context;

                    public void init(ProcessorContext context) {
                        System.out.println("initializing processor: topic=" + topic + " taskId=" + context.taskId());
                        this.numRecordsProcessed = 0;
                        this.context = context;
                    }

                    public void process(String key, T value) {
                        if (printOffset) {
                            System.out.println(">>> " + this.context.offset());
                        }
                        ++this.numRecordsProcessed;
                        if (this.numRecordsProcessed % 100 == 0) {
                            System.out.println("processed " + this.numRecordsProcessed + " records from topic=" + topic);
                        }
                    }

                    public void punctuate(long timestamp) {
                    }

                    public void close() {
                    }
                };
            }
        };
    }

    public static File createDir(String path) throws Exception {
        File dir = new File(path);
        dir.mkdir();
        return dir;
    }

    public static File createDir(File parent, String child) throws Exception {
        File dir = new File(parent, child);
        dir.mkdir();
        return dir;
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Agg {
        public KeyValueMapper<String, Long, KeyValue<String, Long>> selector() {
            return new KeyValueMapper<String, Long, KeyValue<String, Long>>(){

                public KeyValue<String, Long> apply(String key, Long value) {
                    return new KeyValue((Object)(value == null ? null : Long.toString(value)), (Object)1L);
                }
            };
        }

        public Initializer<Long> init() {
            return new Initializer<Long>(){

                public Long apply() {
                    return 0L;
                }
            };
        }

        public Aggregator<String, Long, Long> adder() {
            return new Aggregator<String, Long, Long>(){

                public Long apply(String aggKey, Long value, Long aggregate) {
                    return aggregate + value;
                }
            };
        }

        public Aggregator<String, Long, Long> remover() {
            return new Aggregator<String, Long, Long>(){

                public Long apply(String aggKey, Long value, Long aggregate) {
                    return aggregate - value;
                }
            };
        }
    }

    public static final class Unwindow<K, V>
    implements KeyValueMapper<Windowed<K>, V, KeyValue<K, V>> {
        public KeyValue<K, V> apply(Windowed<K> winKey, V value) {
            return new KeyValue(winKey.key(), value);
        }
    }
}

