/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.MockTimestampExtractor;
import org.junit.Assert;
import org.junit.Test;

public class RecordQueueTest {
    private final Serializer<Integer> intSerializer = new IntegerSerializer();
    private final Deserializer<Integer> intDeserializer = new IntegerDeserializer();
    private final TimestampExtractor timestampExtractor = new MockTimestampExtractor();
    private final String[] topics = new String[]{"topic"};
    private final RecordQueue queue = new RecordQueue(new TopicPartition(this.topics[0], 1), new MockSourceNode<Integer, Integer>(this.topics, this.intDeserializer, this.intDeserializer));
    private final byte[] recordValue = this.intSerializer.serialize(null, (Object)10);
    private final byte[] recordKey = this.intSerializer.serialize(null, (Object)1);

    @Test
    public void testTimeTracking() {
        Assert.assertTrue((boolean)this.queue.isEmpty());
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 2L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue));
        this.queue.addRawRecords(list1, this.timestampExtractor);
        Assert.assertEquals((long)3L, (long)this.queue.size());
        Assert.assertEquals((long)1L, (long)this.queue.timestamp());
        Assert.assertEquals((long)2L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)2L, (long)this.queue.size());
        Assert.assertEquals((long)1L, (long)this.queue.timestamp());
        Assert.assertEquals((long)1L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)1L, (long)this.queue.size());
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 1, 4L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 2L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue));
        this.queue.addRawRecords(list2, this.timestampExtractor);
        Assert.assertEquals((long)4L, (long)this.queue.size());
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        Assert.assertEquals((long)3L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)3L, (long)this.queue.size());
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        Assert.assertEquals((long)4L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        Assert.assertEquals((long)1L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        Assert.assertEquals((long)2L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertEquals((long)3L, (long)this.queue.timestamp());
        List<ConsumerRecord> list3 = Arrays.asList(new ConsumerRecord("topic", 1, 4L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 6L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)this.recordValue));
        this.queue.addRawRecords(list3, this.timestampExtractor);
        Assert.assertEquals((long)3L, (long)this.queue.size());
        Assert.assertEquals((long)4L, (long)this.queue.timestamp());
        Assert.assertEquals((long)4L, (long)this.queue.poll().timestamp);
        Assert.assertEquals((long)2L, (long)this.queue.size());
        Assert.assertEquals((long)5L, (long)this.queue.timestamp());
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionWhenKeyDeserializationFails() throws Exception {
        byte[] key = Serdes.Long().serializer().serialize("foo", (Object)1L);
        List<ConsumerRecord> records = Collections.singletonList(new ConsumerRecord("topic", 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)key, (Object)this.recordValue));
        this.queue.addRawRecords(records, this.timestampExtractor);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionWhenValueDeserializationFails() throws Exception {
        byte[] value = Serdes.Long().serializer().serialize("foo", (Object)1L);
        List<ConsumerRecord> records = Collections.singletonList(new ConsumerRecord("topic", 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)this.recordKey, (Object)value));
        this.queue.addRawRecords(records, this.timestampExtractor);
    }
}

