/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.PunctuationQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.Punctuator;
import org.junit.Assert;
import org.junit.Test;

public class PunctuationQueueTest {
    @Test
    public void testPunctuationInterval() {
        TestProcessor processor = new TestProcessor();
        ProcessorNode node = new ProcessorNode("test", (Processor)processor, null);
        PunctuationQueue queue = new PunctuationQueue();
        PunctuationSchedule sched = new PunctuationSchedule(node, 100L);
        long now = sched.timestamp - 100L;
        queue.schedule(sched);
        Punctuator punctuator = new Punctuator(){

            public void punctuate(ProcessorNode node, long time) {
                node.processor().punctuate(time);
            }
        };
        queue.mayPunctuate(now, punctuator);
        Assert.assertEquals((long)0L, (long)processor.punctuatedAt.size());
        queue.mayPunctuate(now + 99L, punctuator);
        Assert.assertEquals((long)0L, (long)processor.punctuatedAt.size());
        queue.mayPunctuate(now + 100L, punctuator);
        Assert.assertEquals((long)1L, (long)processor.punctuatedAt.size());
        queue.mayPunctuate(now + 199L, punctuator);
        Assert.assertEquals((long)1L, (long)processor.punctuatedAt.size());
        queue.mayPunctuate(now + 200L, punctuator);
        Assert.assertEquals((long)2L, (long)processor.punctuatedAt.size());
    }

    private static class TestProcessor
    extends AbstractProcessor<String, String> {
        public final ArrayList<Long> punctuatedAt = new ArrayList();

        private TestProcessor() {
        }

        public void init(ProcessorContext context) {
        }

        public void process(String key, String value) {
        }

        public void punctuate(long streamTime) {
            this.punctuatedAt.add(streamTime);
        }

        public void close() {
        }
    }
}

