/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.ProcessorTopologyTestDriver;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorTopologyTest {
    private static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    private static final Deserializer<String> STRING_DESERIALIZER = new StringDeserializer();
    protected static final String INPUT_TOPIC_1 = "input-topic-1";
    protected static final String INPUT_TOPIC_2 = "input-topic-2";
    protected static final String OUTPUT_TOPIC_1 = "output-topic-1";
    protected static final String OUTPUT_TOPIC_2 = "output-topic-2";
    private static long timestamp = 1000L;
    private ProcessorTopologyTestDriver driver;
    private StreamsConfig config;

    @Before
    public void setup() {
        File localState = TestUtils.tempDirectory();
        Properties props = new Properties();
        props.setProperty("application.id", "processor-topology-test");
        props.setProperty("bootstrap.servers", "localhost:9091");
        props.setProperty("state.dir", localState.getAbsolutePath());
        props.setProperty("key.serde", Serdes.String().getClass().getName());
        props.setProperty("value.serde", Serdes.String().getClass().getName());
        props.setProperty("timestamp.extractor", CustomTimestampExtractor.class.getName());
        this.config = new StreamsConfig((Map)props);
    }

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testTopologyMetadata() {
        TopologyBuilder builder = new TopologyBuilder().setApplicationId("X");
        builder.addSource("source-1", new String[]{"topic-1"});
        builder.addSource("source-2", new String[]{"topic-2", "topic-3"});
        builder.addProcessor("processor-1", new MockProcessorSupplier(), new String[]{"source-1"});
        builder.addProcessor("processor-2", new MockProcessorSupplier(), new String[]{"source-1", "source-2"});
        builder.addSink("sink-1", "topic-3", new String[]{"processor-1"});
        builder.addSink("sink-2", "topic-4", new String[]{"processor-1", "processor-2"});
        ProcessorTopology topology = builder.build(null);
        Assert.assertEquals((long)6L, (long)topology.processors().size());
        Assert.assertEquals((long)2L, (long)topology.sources().size());
        Assert.assertEquals((long)3L, (long)topology.sourceTopics().size());
        Assert.assertNotNull((Object)topology.source("topic-1"));
        Assert.assertNotNull((Object)topology.source("topic-2"));
        Assert.assertNotNull((Object)topology.source("topic-3"));
        Assert.assertEquals((Object)topology.source("topic-2"), (Object)topology.source("topic-3"));
    }

    @Test
    public void testDrivingSimpleTopology() {
        int partition = 10;
        this.driver = new ProcessorTopologyTestDriver(this.config, this.createSimpleTopology(partition), new String[0]);
        this.driver.process(INPUT_TOPIC_1, "key1", "value1", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.process(INPUT_TOPIC_1, "key2", "value2", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.process(INPUT_TOPIC_1, "key3", "value3", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key4", "value4", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key5", "value5", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3", partition);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4", partition);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5", partition);
    }

    @Test
    public void testDrivingMultiplexingTopology() {
        this.driver = new ProcessorTopologyTestDriver(this.config, this.createMultiplexingTopology(), new String[0]);
        this.driver.process(INPUT_TOPIC_1, "key1", "value1", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key1", "value1(2)");
        this.driver.process(INPUT_TOPIC_1, "key2", "value2", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2(2)");
        this.driver.process(INPUT_TOPIC_1, "key3", "value3", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key4", "value4", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key5", "value5", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key3", "value3(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key4", "value4(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key5", "value5(2)");
    }

    @Test
    public void testDrivingMultiplexByNameTopology() {
        this.driver = new ProcessorTopologyTestDriver(this.config, this.createMultiplexByNameTopology(), new String[0]);
        this.driver.process(INPUT_TOPIC_1, "key1", "value1", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key1", "value1(2)");
        this.driver.process(INPUT_TOPIC_1, "key2", "value2", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key2", "value2(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2(2)");
        this.driver.process(INPUT_TOPIC_1, "key3", "value3", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key4", "value4", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key5", "value5", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key3", "value3(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key4", "value4(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key5", "value5(1)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key3", "value3(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key4", "value4(2)");
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key5", "value5(2)");
    }

    @Test
    public void testDrivingStatefulTopology() {
        String storeName = "entries";
        this.driver = new ProcessorTopologyTestDriver(this.config, this.createStatefulTopology(storeName), storeName);
        this.driver.process(INPUT_TOPIC_1, "key1", "value1", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key2", "value2", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key3", "value3", STRING_SERIALIZER, STRING_SERIALIZER);
        this.driver.process(INPUT_TOPIC_1, "key1", "value4", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNoOutputRecord(OUTPUT_TOPIC_1);
        KeyValueStore store = this.driver.getKeyValueStore("entries");
        Assert.assertEquals((Object)"value4", (Object)store.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)store.get((Object)"key2"));
        Assert.assertEquals((Object)"value3", (Object)store.get((Object)"key3"));
        Assert.assertNull((Object)store.get((Object)"key4"));
    }

    @Test
    public void testDrivingSimpleMultiSourceTopology() {
        int partition = 10;
        this.driver = new ProcessorTopologyTestDriver(this.config, this.createSimpleMultiSourceTopology(partition), new String[0]);
        this.driver.process(INPUT_TOPIC_1, "key1", "value1", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_1, "key1", "value1", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_2);
        this.driver.process(INPUT_TOPIC_2, "key2", "value2", STRING_SERIALIZER, STRING_SERIALIZER);
        this.assertNextOutputRecord(OUTPUT_TOPIC_2, "key2", "value2", partition);
        this.assertNoOutputRecord(OUTPUT_TOPIC_1);
    }

    protected void assertNextOutputRecord(String topic, String key, String value) {
        ProducerRecord<String, String> record = this.driver.readOutput(topic, STRING_DESERIALIZER, STRING_DESERIALIZER);
        Assert.assertEquals((Object)topic, (Object)record.topic());
        Assert.assertEquals((Object)key, (Object)record.key());
        Assert.assertEquals((Object)value, (Object)record.value());
        Assert.assertNull((Object)record.partition());
    }

    protected void assertNextOutputRecord(String topic, String key, String value, Integer partition) {
        ProducerRecord<String, String> record = this.driver.readOutput(topic, STRING_DESERIALIZER, STRING_DESERIALIZER);
        Assert.assertEquals((Object)topic, (Object)record.topic());
        Assert.assertEquals((Object)key, (Object)record.key());
        Assert.assertEquals((Object)value, (Object)record.value());
        Assert.assertEquals((Object)partition, (Object)record.partition());
    }

    protected void assertNoOutputRecord(String topic) {
        Assert.assertNull(this.driver.readOutput(topic));
    }

    protected <K, V> StreamPartitioner<K, V> constantPartitioner(final Integer partition) {
        return new StreamPartitioner<K, V>(){

            public Integer partition(K key, V value, int numPartitions) {
                return partition;
            }
        };
    }

    protected TopologyBuilder createSimpleTopology(int partition) {
        return new TopologyBuilder().addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new ForwardingProcessor()), new String[]{"source"}).addSink("sink", OUTPUT_TOPIC_1, this.constantPartitioner(partition), new String[]{"processor"});
    }

    protected TopologyBuilder createMultiplexingTopology() {
        return new TopologyBuilder().addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new MultiplexingProcessor(2)), new String[]{"source"}).addSink("sink1", OUTPUT_TOPIC_1, new String[]{"processor"}).addSink("sink2", OUTPUT_TOPIC_2, new String[]{"processor"});
    }

    protected TopologyBuilder createMultiplexByNameTopology() {
        return new TopologyBuilder().addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new MultiplexByNameProcessor(2)), new String[]{"source"}).addSink("sink0", OUTPUT_TOPIC_1, new String[]{"processor"}).addSink("sink1", OUTPUT_TOPIC_2, new String[]{"processor"});
    }

    protected TopologyBuilder createStatefulTopology(String storeName) {
        return new TopologyBuilder().addSource("source", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor", this.define((Processor)new StatefulProcessor(storeName)), new String[]{"source"}).addStateStore(Stores.create((String)storeName).withStringKeys().withStringValues().inMemory().build(), new String[]{"processor"}).addSink("counts", OUTPUT_TOPIC_1, new String[]{"processor"});
    }

    protected TopologyBuilder createSimpleMultiSourceTopology(int partition) {
        return new TopologyBuilder().addSource("source-1", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_1}).addProcessor("processor-1", this.define((Processor)new ForwardingProcessor()), new String[]{"source-1"}).addSink("sink-1", OUTPUT_TOPIC_1, this.constantPartitioner(partition), new String[]{"processor-1"}).addSource("source-2", STRING_DESERIALIZER, STRING_DESERIALIZER, new String[]{INPUT_TOPIC_2}).addProcessor("processor-2", this.define((Processor)new ForwardingProcessor()), new String[]{"source-2"}).addSink("sink-2", OUTPUT_TOPIC_2, this.constantPartitioner(partition), new String[]{"processor-2"});
    }

    protected <K, V> ProcessorSupplier<K, V> define(final Processor<K, V> processor) {
        return new ProcessorSupplier<K, V>(){

            public Processor<K, V> get() {
                return processor;
            }
        };
    }

    public static class CustomTimestampExtractor
    implements TimestampExtractor {
        public long extract(ConsumerRecord<Object, Object> record) {
            return timestamp;
        }
    }

    protected static class StatefulProcessor
    extends AbstractProcessor<String, String> {
        private KeyValueStore<String, String> store;
        private final String storeName;

        public StatefulProcessor(String storeName) {
            this.storeName = storeName;
        }

        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(this.storeName);
        }

        public void process(String key, String value) {
            this.store.put((Object)key, (Object)value);
        }

        public void punctuate(long streamTime) {
            int count = 0;
            try (KeyValueIterator iter = this.store.all();){
                while (iter.hasNext()) {
                    iter.next();
                    ++count;
                }
            }
            this.context().forward((Object)Long.toString(streamTime), (Object)count);
        }

        public void close() {
            this.store.close();
        }
    }

    protected static class MultiplexByNameProcessor
    extends AbstractProcessor<String, String> {
        private final int numChildren;

        public MultiplexByNameProcessor(int numChildren) {
            this.numChildren = numChildren;
        }

        public void process(String key, String value) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)key, (Object)(value + "(" + (i + 1) + ")"), "sink" + i);
            }
        }

        public void punctuate(long streamTime) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)Long.toString(streamTime), (Object)("punctuate(" + (i + 1) + ")"), "sink" + i);
            }
        }
    }

    protected static class MultiplexingProcessor
    extends AbstractProcessor<String, String> {
        private final int numChildren;

        public MultiplexingProcessor(int numChildren) {
            this.numChildren = numChildren;
        }

        public void process(String key, String value) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)key, (Object)(value + "(" + (i + 1) + ")"), i);
            }
        }

        public void punctuate(long streamTime) {
            for (int i = 0; i != this.numChildren; ++i) {
                this.context().forward((Object)Long.toString(streamTime), (Object)("punctuate(" + (i + 1) + ")"), i);
            }
        }
    }

    protected static class ForwardingProcessor
    extends AbstractProcessor<String, String> {
        protected ForwardingProcessor() {
        }

        public void process(String key, String value) {
            this.context().forward((Object)key, (Object)value);
        }

        public void punctuate(long streamTime) {
            this.context().forward((Object)Long.toString(streamTime), (Object)"punctuate");
        }
    }
}

