/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.internals.MinTimestampTracker;
import org.apache.kafka.streams.processor.internals.Stamped;
import org.junit.Assert;
import org.junit.Test;

public class MinTimestampTrackerTest {
    private Stamped<String> elem(long timestamp) {
        return new Stamped((Object)"", timestamp);
    }

    @Test
    public void testTracking() {
        MinTimestampTracker tracker = new MinTimestampTracker();
        Object[] elems = new Object[]{this.elem(100L), this.elem(101L), this.elem(102L), this.elem(98L), this.elem(99L), this.elem(100L)};
        int insertionIndex = 0;
        int removalIndex = 0;
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)100L, (long)tracker.get());
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)100L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)101L, (long)tracker.get());
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)101L, (long)tracker.get());
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)98L, (long)tracker.get());
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)98L, (long)tracker.get());
        tracker.addElement((Stamped)elems[insertionIndex++]);
        Assert.assertEquals((long)98L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)98L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)98L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)99L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)100L, (long)tracker.get());
        tracker.removeElement((Stamped)elems[removalIndex++]);
        Assert.assertEquals((long)100L, (long)tracker.get());
        Assert.assertEquals((long)insertionIndex, (long)removalIndex);
    }
}

