/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KTableSourceTest {
    private final Serde<String> stringSerde = Serdes.String();
    private final Serde<Integer> intSerde = Serdes.Integer();
    private KStreamTestDriver driver = null;
    private File stateDir = null;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testKTable() {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table(this.stringSerde, this.intSerde, topic1, "anyStoreName");
        MockProcessorSupplier proc1 = new MockProcessorSupplier();
        table1.toStream().process(proc1, new String[0]);
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.process(topic1, "A", 1);
        this.driver.process(topic1, "B", 2);
        this.driver.process(topic1, "C", 3);
        this.driver.process(topic1, "D", 4);
        this.driver.flushState();
        this.driver.process(topic1, "A", null);
        this.driver.process(topic1, "B", null);
        this.driver.flushState();
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:1", "B:2", "C:3", "D:4", "A:null", "B:null"}), proc1.processed);
    }

    @Test
    public void testValueGetter() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        KTableValueGetterSupplier getterSupplier1 = table1.valueGetterSupplier();
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        KTableValueGetter getter1 = getterSupplier1.get();
        getter1.init(this.driver.context());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        this.driver.process(topic1, "A", "03");
        Assert.assertEquals((Object)"03", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        this.driver.process(topic1, "A", null);
        this.driver.process(topic1, "B", null);
        Assert.assertNull((Object)getter1.get((Object)"A"));
        Assert.assertNull((Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
    }

    @Test
    public void testNotSendingOldValue() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        MockProcessorSupplier proc1 = new MockProcessorSupplier();
        builder.addProcessor("proc1", proc1, new String[]{table1.name});
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(01<-null)", "B:(01<-null)", "C:(01<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(02<-null)", "B:(02<-null)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(03<-null)");
        this.driver.process(topic1, "A", null);
        this.driver.process(topic1, "B", null);
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(null<-null)", "B:(null<-null)");
    }

    @Test
    public void testSendingOldValue() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        table1.enableSendingOldValues();
        Assert.assertTrue((boolean)table1.sendingOldValueEnabled());
        MockProcessorSupplier proc1 = new MockProcessorSupplier();
        builder.addProcessor("proc1", proc1, new String[]{table1.name});
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(01<-null)", "B:(01<-null)", "C:(01<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(02<-01)", "B:(02<-01)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(03<-02)");
        this.driver.process(topic1, "A", null);
        this.driver.process(topic1, "B", null);
        this.driver.flushState();
        proc1.checkAndClearProcessResult("A:(null<-03)", "B:(null<-02)");
    }
}

