/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KTableMapValuesTest {
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver = null;
    private File stateDir = null;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testKTable() {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        MockProcessorSupplier proc2 = new MockProcessorSupplier();
        table2.toStream().process(proc2, new String[0]);
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "02");
        this.driver.process(topic1, "C", "03");
        this.driver.process(topic1, "D", "04");
        this.driver.flushState();
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:1", "B:2", "C:3", "D:4"}), proc2.processed);
    }

    @Test
    public void testValueGetter() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName1 = "storeName1";
        String storeName2 = "storeName2";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        KTableImpl table4 = (KTableImpl)table1.through(this.stringSerde, this.stringSerde, topic2, storeName2);
        KTableValueGetterSupplier getterSupplier1 = table1.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier4 = table4.valueGetterSupplier();
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        KTableValueGetter getter1 = getterSupplier1.get();
        getter1.init(this.driver.context());
        KTableValueGetter getter2 = getterSupplier2.get();
        getter2.init(this.driver.context());
        KTableValueGetter getter3 = getterSupplier3.get();
        getter3.init(this.driver.context());
        KTableValueGetter getter4 = getterSupplier4.get();
        getter4.init(this.driver.context());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertNull((Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        Assert.assertEquals((Object)"03", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(3), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"03", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        Assert.assertNull((Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertNull((Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertNull((Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
    }

    @Test
    public void testNotSendingOldValue() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.addProcessor("proc", proc, new String[]{table2.name});
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        Assert.assertFalse((boolean)table1.sendingOldValueEnabled());
        Assert.assertFalse((boolean)table2.sendingOldValueEnabled());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(2<-null)", "B:(2<-null)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(3<-null)");
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(null<-null)");
    }

    @Test
    public void testSendingOldValue() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, "anyStoreName");
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        table2.enableSendingOldValues();
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.addProcessor("proc", proc, new String[]{table2.name});
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        Assert.assertTrue((boolean)table1.sendingOldValueEnabled());
        Assert.assertTrue((boolean)table2.sendingOldValueEnabled());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(1<-null)", "B:(1<-null)", "C:(1<-null)");
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(2<-1)", "B:(2<-1)");
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(3<-2)");
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        proc.checkAndClearProcessResult("A:(null<-3)");
    }
}

