/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KTableKTableJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final String storeName1 = "store-name-1";
    private final String storeName2 = "store-name-2";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver = null;
    private File stateDir = null;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testJoin() throws Exception {
        int i;
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KTable table1 = builder.table(this.intSerde, this.stringSerde, "topic1", "store-name-1");
        KTable table2 = builder.table(this.intSerde, this.stringSerde, "topic2", "store-name-2");
        KTable joined = table1.join(table2, MockValueJoiner.STRING_JOINER);
        joined.toStream().process(processor, new String[0]);
        Collection copartitionGroups = builder.copartitionGroups();
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        KTableValueGetterSupplier getterSupplier = ((KTableImpl)joined).valueGetterSupplier();
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.setTime(0L);
        KTableValueGetter getter = getterSupplier.get();
        getter.init(this.driver.context());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:null", "1:null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, null), this.kv(1, null), this.kv(2, null), this.kv(3, null));
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+Y0"), this.kv(1, "X1+Y1"), this.kv(2, null), this.kv(3, null));
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1", "2:null", "3:null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+Y0"), this.kv(1, "X1+Y1"), this.kv(2, null), this.kv(3, null));
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic2", expectedKeys[i], "YY" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+YY0"), this.kv(1, "X1+YY1"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, "X0+YY0"), this.kv(1, "X1+YY1"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], null);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:null", "1:null");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, null), this.kv(1, null), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "XX" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:null", "1:null", "2:XX2+YY2", "3:XX3+YY3");
        this.checkJoinedValues((KTableValueGetter<Integer, String>)getter, this.kv(0, null), this.kv(1, null), this.kv(2, "XX2+YY2"), this.kv(3, "XX3+YY3"));
    }

    @Test
    public void testNotSendingOldValues() throws Exception {
        int i;
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable table1 = builder.table(this.intSerde, this.stringSerde, "topic1", "store-name-1");
        KTable table2 = builder.table(this.intSerde, this.stringSerde, "topic2", "store-name-2");
        KTable joined = table1.join(table2, MockValueJoiner.STRING_JOINER);
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.addProcessor("proc", proc, new String[]{((KTableImpl)joined).name});
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.setTime(0L);
        Assert.assertFalse((boolean)((KTableImpl)table1).sendingOldValueEnabled());
        Assert.assertFalse((boolean)((KTableImpl)table2).sendingOldValueEnabled());
        Assert.assertFalse((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)", "2:(null<-null)", "3:(null<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic2", expectedKeys[i], "YY" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-null)", "1:(X1+YY1<-null)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-null)", "1:(X1+YY1<-null)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "XX" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)", "2:(XX2+YY2<-null)", "3:(XX3+YY3<-null)");
    }

    @Test
    public void testSendingOldValues() throws Exception {
        int i;
        KStreamBuilder builder = new KStreamBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable table1 = builder.table(this.intSerde, this.stringSerde, "topic1", "store-name-1");
        KTable table2 = builder.table(this.intSerde, this.stringSerde, "topic2", "store-name-2");
        KTable joined = table1.join(table2, MockValueJoiner.STRING_JOINER);
        ((KTableImpl)joined).enableSendingOldValues();
        MockProcessorSupplier proc = new MockProcessorSupplier();
        builder.addProcessor("proc", proc, new String[]{((KTableImpl)joined).name});
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.setTime(0L);
        Assert.assertTrue((boolean)((KTableImpl)table1).sendingOldValueEnabled());
        Assert.assertTrue((boolean)((KTableImpl)table2).sendingOldValueEnabled());
        Assert.assertTrue((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-X0+Y0)", "1:(X1+Y1<-X1+Y1)", "2:(null<-null)", "3:(null<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic2", expectedKeys[i], "YY" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-X0+Y0)", "1:(X1+YY1<-X1+Y1)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-X0+YY0)", "1:(X1+YY1<-X1+YY1)", "2:(X2+YY2<-X2+YY2)", "3:(X3+YY3<-X3+YY3)");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-X0+YY0)", "1:(null<-X1+YY1)");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.driver.process("topic1", expectedKeys[i], "XX" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)", "2:(XX2+YY2<-X2+YY2)", "3:(XX3+YY3<-X3+YY3)");
    }

    private KeyValue<Integer, String> kv(Integer key, String value) {
        return new KeyValue((Object)key, (Object)value);
    }

    private void checkJoinedValues(KTableValueGetter<Integer, String> getter, KeyValue<Integer, String> ... expected) {
        for (KeyValue<Integer, String> kv : expected) {
            String value = (String)getter.get(kv.key);
            if (kv.value == null) {
                Assert.assertNull((Object)value);
                continue;
            }
            Assert.assertEquals((Object)kv.value, (Object)value);
        }
    }
}

