/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockKeyValueMapper;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KTableImplTest {
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver = null;
    private File stateDir = null;
    private KStreamBuilder builder;
    private KTable<String, String> table;

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
        this.builder = new KStreamBuilder();
        this.table = this.builder.table("test", "test");
    }

    @Test
    public void testKTable() {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName1 = "storeName1";
        String storeName2 = "storeName2";
        KTable table1 = builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        MockProcessorSupplier proc1 = new MockProcessorSupplier();
        table1.toStream().process(proc1, new String[0]);
        KTable table2 = table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        MockProcessorSupplier proc2 = new MockProcessorSupplier();
        table2.toStream().process(proc2, new String[0]);
        KTable table3 = table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        MockProcessorSupplier proc3 = new MockProcessorSupplier();
        table3.toStream().process(proc3, new String[0]);
        KTable table4 = table1.through(this.stringSerde, this.stringSerde, topic2, storeName2);
        MockProcessorSupplier proc4 = new MockProcessorSupplier();
        table4.toStream().process(proc4, new String[0]);
        this.driver = new KStreamTestDriver(builder, this.stateDir);
        this.driver.process(topic1, "A", "01");
        this.driver.flushState();
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        this.driver.process(topic1, "C", "03");
        this.driver.flushState();
        this.driver.process(topic1, "D", "04");
        this.driver.flushState();
        this.driver.flushState();
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:01", "B:02", "C:03", "D:04"}), proc1.processed);
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:1", "B:2", "C:3", "D:4"}), proc2.processed);
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:null", "B:2", "C:null", "D:4"}), proc3.processed);
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:01", "B:02", "C:03", "D:04"}), proc4.processed);
    }

    @Test
    public void testValueGetter() throws IOException {
        KStreamBuilder builder = new KStreamBuilder();
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName1 = "storeName1";
        String storeName2 = "storeName2";
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        KTableImpl table2 = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table3 = (KTableImpl)table2.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        KTableImpl table4 = (KTableImpl)table1.through(this.stringSerde, this.stringSerde, topic2, storeName2);
        KTableValueGetterSupplier getterSupplier1 = table1.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier4 = table4.valueGetterSupplier();
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        Assert.assertEquals((long)2L, (long)this.driver.allStateStores().size());
        KTableValueGetter getter1 = getterSupplier1.get();
        getter1.init(this.driver.context());
        KTableValueGetter getter2 = getterSupplier2.get();
        getter2.init(this.driver.context());
        KTableValueGetter getter3 = getterSupplier3.get();
        getter3.init(this.driver.context());
        KTableValueGetter getter4 = getterSupplier4.get();
        getter4.init(this.driver.context());
        this.driver.process(topic1, "A", "01");
        this.driver.process(topic1, "B", "01");
        this.driver.process(topic1, "C", "01");
        this.driver.flushState();
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertNull((Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "02");
        this.driver.process(topic1, "B", "02");
        this.driver.flushState();
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", "03");
        this.driver.flushState();
        Assert.assertEquals((Object)"03", (Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertEquals((Object)new Integer(3), (Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertEquals((Object)"03", (Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
        this.driver.process(topic1, "A", null);
        this.driver.flushState();
        Assert.assertNull((Object)getter1.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter1.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter1.get((Object)"C"));
        Assert.assertNull((Object)getter2.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter2.get((Object)"B"));
        Assert.assertEquals((Object)new Integer(1), (Object)getter2.get((Object)"C"));
        Assert.assertNull((Object)getter3.get((Object)"A"));
        Assert.assertEquals((Object)new Integer(2), (Object)getter3.get((Object)"B"));
        Assert.assertNull((Object)getter3.get((Object)"C"));
        Assert.assertNull((Object)getter4.get((Object)"A"));
        Assert.assertEquals((Object)"02", (Object)getter4.get((Object)"B"));
        Assert.assertEquals((Object)"01", (Object)getter4.get((Object)"C"));
    }

    @Test
    public void testStateStoreLazyEval() throws IOException {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName1 = "storeName1";
        String storeName2 = "storeName2";
        KStreamBuilder builder = new KStreamBuilder();
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        KTableImpl table2 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic2, storeName2);
        KTableImpl table1Mapped = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table1MappedFiltered = (KTableImpl)table1Mapped.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        this.driver.setTime(0L);
        Assert.assertEquals((long)2L, (long)this.driver.allStateStores().size());
    }

    @Test
    public void testStateStore() throws IOException {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String storeName1 = "storeName1";
        String storeName2 = "storeName2";
        KStreamBuilder builder = new KStreamBuilder();
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        KTableImpl table2 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic2, storeName2);
        KTableImpl table1Mapped = (KTableImpl)table1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KTableImpl table1MappedFiltered = (KTableImpl)table1Mapped.filter((Predicate)new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        });
        table2.join((KTable)table1MappedFiltered, (ValueJoiner)new ValueJoiner<String, Integer, String>(){

            public String apply(String v1, Integer v2) {
                return v1 + v2;
            }
        });
        this.driver = new KStreamTestDriver(builder, this.stateDir, null, null);
        this.driver.setTime(0L);
        Assert.assertEquals((long)2L, (long)this.driver.allStateStores().size());
    }

    @Test
    public void testRepartition() throws IOException {
        String topic1 = "topic1";
        String storeName1 = "storeName1";
        KStreamBuilder builder = new KStreamBuilder();
        KTableImpl table1 = (KTableImpl)builder.table(this.stringSerde, this.stringSerde, topic1, storeName1);
        KTableImpl table1Aggregated = (KTableImpl)table1.groupBy(MockKeyValueMapper.NoOpKeyValueMapper()).aggregate(MockInitializer.STRING_INIT, MockAggregator.STRING_ADDER, MockAggregator.STRING_REMOVER, "mock-result1");
        KTableImpl table1Reduced = (KTableImpl)table1.groupBy(MockKeyValueMapper.NoOpKeyValueMapper()).reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, "mock-result2");
        this.driver = new KStreamTestDriver(builder, this.stateDir, this.stringSerde, this.stringSerde);
        this.driver.setTime(0L);
        Assert.assertEquals((long)3L, (long)this.driver.allStateStores().size());
        Assert.assertTrue((boolean)this.driver.allProcessorNames().contains("KSTREAM-SINK-0000000003"));
        Assert.assertTrue((boolean)this.driver.allProcessorNames().contains("KSTREAM-SOURCE-0000000004"));
        Assert.assertTrue((boolean)this.driver.allProcessorNames().contains("KSTREAM-SINK-0000000007"));
        Assert.assertTrue((boolean)this.driver.allProcessorNames().contains("KSTREAM-SOURCE-0000000008"));
        Assert.assertNotNull((Object)((ChangedSerializer)((SinkNode)this.driver.processor("KSTREAM-SINK-0000000003")).valueSerializer()).inner());
        Assert.assertNotNull((Object)((ChangedDeserializer)((SourceNode)this.driver.processor("KSTREAM-SOURCE-0000000004")).valueDeserializer()).inner());
        Assert.assertNotNull((Object)((ChangedSerializer)((SinkNode)this.driver.processor("KSTREAM-SINK-0000000007")).valueSerializer()).inner());
        Assert.assertNotNull((Object)((ChangedDeserializer)((SourceNode)this.driver.processor("KSTREAM-SOURCE-0000000008")).valueDeserializer()).inner());
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSelectorOnToStream() throws Exception {
        this.table.toStream(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicOnTo() throws Exception {
        this.table.to(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullPredicateOnFilter() throws Exception {
        this.table.filter(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullPredicateOnFilterNot() throws Exception {
        this.table.filterNot(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnMapValues() throws Exception {
        this.table.mapValues(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullFilePathOnWriteAsText() throws Exception {
        this.table.writeAsText(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullActionOnForEach() throws Exception {
        this.table.foreach(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicInThrough() throws Exception {
        this.table.through(null, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullStoreInThrough() throws Exception {
        this.table.through("topic", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSelectorOnGroupBy() throws Exception {
        this.table.groupBy(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullOtherTableOnJoin() throws Exception {
        this.table.join(null, MockValueJoiner.STRING_JOINER);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullJoinerJoin() throws Exception {
        this.table.join(this.table, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullOtherTableOnOuterJoin() throws Exception {
        this.table.outerJoin(null, MockValueJoiner.STRING_JOINER);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullJoinerOnOuterJoin() throws Exception {
        this.table.outerJoin(this.table, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullJoinerOnLeftJoin() throws Exception {
        this.table.leftJoin(this.table, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullOtherTableOnLeftJoin() throws Exception {
        this.table.leftJoin(null, MockValueJoiner.STRING_JOINER);
    }
}

