/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamTransformValuesTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private KStreamTestDriver driver;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testTransform() {
        KStreamBuilder builder = new KStreamBuilder();
        ValueTransformerSupplier<Integer, Integer> valueTransformerSupplier = new ValueTransformerSupplier<Integer, Integer>(){

            public ValueTransformer<Integer, Integer> get() {
                return new ValueTransformer<Integer, Integer>(){
                    private int total = 0;

                    public void init(ProcessorContext context) {
                    }

                    public Integer transform(Integer value) {
                        this.total += value.intValue();
                        return this.total;
                    }

                    public Integer punctuate(long timestamp) {
                        return (int)timestamp;
                    }

                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(this.intSerde, this.intSerde, new String[]{this.topicName});
        stream.transformValues((ValueTransformerSupplier)valueTransformerSupplier, new String[0]).process(processor, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        for (int i = 0; i < expectedKeys.length; ++i) {
            this.driver.process(this.topicName, expectedKeys[i], expectedKeys[i] * 10);
        }
        Assert.assertEquals((long)4L, (long)processor.processed.size());
        this.driver.punctuate(2L);
        this.driver.punctuate(3L);
        String[] expected = new String[]{"1:10", "10:110", "100:1110", "1000:11110", "null:2", "null:3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

