/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamImplTest {
    private final Serde<String> stringSerde = Serdes.String();
    private final Serde<Integer> intSerde = Serdes.Integer();
    private KStream<String, String> testStream;
    private KStreamBuilder builder;

    @Before
    public void before() {
        this.builder = new KStreamBuilder();
        this.testStream = this.builder.stream(new String[]{"source"});
    }

    @Test
    public void testNumProcesses() {
        KStreamBuilder builder = new KStreamBuilder();
        KStream source1 = builder.stream(this.stringSerde, this.stringSerde, new String[]{"topic-1", "topic-2"});
        KStream source2 = builder.stream(this.stringSerde, this.stringSerde, new String[]{"topic-3", "topic-4"});
        KStream stream1 = source1.filter((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return true;
            }
        }).filterNot((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return false;
            }
        });
        KStream stream2 = stream1.mapValues((ValueMapper)new ValueMapper<String, Integer>(){

            public Integer apply(String value) {
                return new Integer(value);
            }
        });
        KStream stream3 = source2.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<Integer>>(){

            public Iterable<Integer> apply(String value) {
                return Collections.singletonList(new Integer(value));
            }
        });
        KStream[] streams2 = stream2.branch(new Predicate[]{new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        }, new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return true;
            }
        }});
        KStream[] streams3 = stream3.branch(new Predicate[]{new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return value % 2 == 0;
            }
        }, new Predicate<String, Integer>(){

            public boolean test(String key, Integer value) {
                return true;
            }
        }});
        boolean anyWindowSize = true;
        KStream stream4 = streams2[0].join(streams3[0], (ValueJoiner)new ValueJoiner<Integer, Integer, Integer>(){

            public Integer apply(Integer value1, Integer value2) {
                return value1 + value2;
            }
        }, JoinWindows.of((long)1L), this.stringSerde, this.intSerde, this.intSerde);
        KStream stream5 = streams2[1].join(streams3[1], (ValueJoiner)new ValueJoiner<Integer, Integer, Integer>(){

            public Integer apply(Integer value1, Integer value2) {
                return value1 + value2;
            }
        }, JoinWindows.of((long)1L), this.stringSerde, this.intSerde, this.intSerde);
        stream4.to("topic-5");
        streams2[1].through("topic-6").process(new MockProcessorSupplier(), new String[0]);
        Assert.assertEquals((long)26L, (long)builder.setApplicationId("X").build(null).processors().size());
    }

    @Test
    public void testToWithNullValueSerdeDoesntNPE() {
        KStreamBuilder builder = new KStreamBuilder();
        KStream inputStream = builder.stream(this.stringSerde, this.stringSerde, new String[]{"input"});
        inputStream.to(this.stringSerde, null, "output");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullPredicateOnFilter() throws Exception {
        this.testStream.filter(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullPredicateOnFilterNot() throws Exception {
        this.testStream.filterNot(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnSelectKey() throws Exception {
        this.testStream.selectKey(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnMap() throws Exception {
        this.testStream.map(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnMapValues() throws Exception {
        this.testStream.mapValues(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullFilePathOnWriteAsText() throws Exception {
        this.testStream.writeAsText(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnFlatMap() throws Exception {
        this.testStream.flatMap(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullMapperOnFlatMapValues() throws Exception {
        this.testStream.flatMapValues(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldHaveAtLeastOnPredicateWhenBranching() throws Exception {
        this.testStream.branch(new Predicate[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldCantHaveNullPredicate() throws Exception {
        this.testStream.branch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicOnThrough() throws Exception {
        this.testStream.through(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTopicOnTo() throws Exception {
        this.testStream.to(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTransformSupplierOnTransform() throws Exception {
        this.testStream.transform(null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTransformSupplierOnTransformValues() throws Exception {
        this.testStream.transformValues(null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProcessSupplier() throws Exception {
        this.testStream.process(null, new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullOtherStreamOnJoin() throws Exception {
        this.testStream.join(null, MockValueJoiner.STRING_JOINER, JoinWindows.of((long)10L));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullValueJoinerOnJoin() throws Exception {
        this.testStream.join(this.testStream, null, JoinWindows.of((long)10L));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullJoinWindowsOnJoin() throws Exception {
        this.testStream.join(this.testStream, MockValueJoiner.STRING_JOINER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullTableOnTableJoin() throws Exception {
        this.testStream.leftJoin((KTable)null, MockValueJoiner.STRING_JOINER);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullValueMapperOnTableJoin() throws Exception {
        this.testStream.leftJoin(this.builder.table(Serdes.String(), Serdes.String(), "topic", "store"), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSelectorOnGroupBy() throws Exception {
        this.testStream.groupBy(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullActionOnForEach() throws Exception {
        this.testStream.foreach(null);
    }
}

