/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.test.KStreamTestDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamForeachTest {
    private final String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testForeach() {
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue((Object)0, (Object)"zero"), new KeyValue((Object)1, (Object)"one"), new KeyValue((Object)2, (Object)"two"), new KeyValue((Object)3, (Object)"three"));
        List<KeyValue> expectedRecords = Arrays.asList(new KeyValue((Object)0, (Object)"ZERO"), new KeyValue((Object)2, (Object)"ONE"), new KeyValue((Object)4, (Object)"TWO"), new KeyValue((Object)6, (Object)"THREE"));
        final ArrayList actualRecords = new ArrayList();
        ForeachAction<Integer, String> action = new ForeachAction<Integer, String>(){

            public void apply(Integer key, String value) {
                actualRecords.add(new KeyValue((Object)(key * 2), (Object)value.toUpperCase(Locale.ROOT)));
            }
        };
        KStreamBuilder builder = new KStreamBuilder();
        KStream stream = builder.stream(this.intSerde, this.stringSerde, new String[]{"topic"});
        stream.foreach((ForeachAction)action);
        this.driver = new KStreamTestDriver(builder);
        for (KeyValue record : inputRecords) {
            this.driver.process("topic", record.key, record.value);
        }
        Assert.assertEquals((long)expectedRecords.size(), (long)actualRecords.size());
        for (int i = 0; i < expectedRecords.size(); ++i) {
            KeyValue expectedRecord = expectedRecords.get(i);
            KeyValue actualRecord = (KeyValue)actualRecords.get(i);
            Assert.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
    }
}

