/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockReducer;
import org.junit.Before;
import org.junit.Test;

public class KGroupedStreamImplTest {
    private KGroupedStream<String, String> groupedStream;

    @Before
    public void before() {
        KStream stream = new KStreamBuilder().stream(new String[]{"topic"});
        this.groupedStream = stream.groupByKey();
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullReducerOnReduce() throws Exception {
        this.groupedStream.reduce(null, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullStoreNameOnReduce() throws Exception {
        this.groupedStream.reduce(MockReducer.STRING_ADDER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullReducerWithWindowedReduce() throws Exception {
        this.groupedStream.reduce(null, (Windows)TimeWindows.of((long)10L), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullWindowsWithWindowedReduce() throws Exception {
        this.groupedStream.reduce(MockReducer.STRING_ADDER, null, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullStoreNameWithWindowedReduce() throws Exception {
        this.groupedStream.reduce(MockReducer.STRING_ADDER, (Windows)TimeWindows.of((long)10L), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullInitializerOnAggregate() throws Exception {
        this.groupedStream.aggregate(null, MockAggregator.STRING_ADDER, Serdes.String(), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullAdderOnAggregate() throws Exception {
        this.groupedStream.aggregate(MockInitializer.STRING_INIT, null, Serdes.String(), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullStoreNameOnAggregate() throws Exception {
        this.groupedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.STRING_ADDER, Serdes.String(), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullInitializerOnWindowedAggregate() throws Exception {
        this.groupedStream.aggregate(null, MockAggregator.STRING_ADDER, (Windows)TimeWindows.of((long)10L), Serdes.String(), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullAdderOnWindowedAggregate() throws Exception {
        this.groupedStream.aggregate(MockInitializer.STRING_INIT, null, (Windows)TimeWindows.of((long)10L), Serdes.String(), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullWindowsOnWindowedAggregate() throws Exception {
        this.groupedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.STRING_ADDER, null, Serdes.String(), "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotHaveNullStoreNameOnWindowedAggregate() throws Exception {
        this.groupedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.STRING_ADDER, (Windows)TimeWindows.of((long)10L), Serdes.String(), null);
    }
}

