/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowsTest {
    private static long anySize = 123L;

    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        TimeWindows w1 = TimeWindows.of((long)anySize);
        TimeWindows w2 = TimeWindows.of((long)w1.size);
        Assert.assertEquals((Object)w1, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w1.hashCode());
        Assert.assertEquals((Object)w1, (Object)w2);
        Assert.assertEquals((Object)w2, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w2.hashCode());
        TimeWindows w3 = TimeWindows.of((long)w2.size);
        Assert.assertEquals((Object)w2, (Object)w3);
        Assert.assertEquals((Object)w1, (Object)w3);
        Assert.assertEquals((long)w1.hashCode(), (long)w3.hashCode());
        Assert.assertNotEquals((String)"must be false for null", null, (Object)w1);
        Assert.assertNotEquals((String)"must be false for different window types", (Object)UnlimitedWindows.of(), (Object)w1);
        Assert.assertNotEquals((String)"must be false for different types", (Object)new Object(), (Object)w1);
        TimeWindows differentWindowSize = TimeWindows.of((long)(w1.size + 1L));
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize, (Object)w1);
        TimeWindows differentAdvanceInterval = w1.advanceBy(w1.advance - 1L);
        Assert.assertNotEquals((String)"must be false when advance intervals are different", (Object)differentAdvanceInterval, (Object)w1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeNegative() {
        TimeWindows.of((long)-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeZero() {
        TimeWindows.of((long)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void advanceIntervalMustNotBeNegative() {
        TimeWindows.of((long)anySize).advanceBy(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void advanceIntervalMustNotBeZero() {
        TimeWindows.of((long)anySize).advanceBy(0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void advanceIntervalMustNotBeLargerThanWindowSize() {
        long size = anySize;
        TimeWindows.of((long)size).advanceBy(size + 1L);
    }

    @Test
    public void windowsForHoppingWindows() {
        TimeWindows windows = TimeWindows.of((long)12L).advanceBy(5L);
        Map matched = windows.windowsFor(21L);
        Assert.assertEquals((long)3L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(10L, 22L), matched.get(10L));
        Assert.assertEquals((Object)new TimeWindow(15L, 27L), matched.get(15L));
        Assert.assertEquals((Object)new TimeWindow(20L, 32L), matched.get(20L));
    }

    @Test
    public void windowsForBarelyOverlappingHoppingWindows() {
        TimeWindows windows = TimeWindows.of((long)6L).advanceBy(5L);
        Map matched = windows.windowsFor(7L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(5L, 11L), matched.get(5L));
    }

    @Test
    public void windowsForTumblingWindows() {
        TimeWindows windows = TimeWindows.of((long)12L);
        Map matched = windows.windowsFor(21L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(12L, 24L), matched.get(12L));
    }
}

