/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class KStreamBuilderTest {
    private KStreamTestDriver driver = null;

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test(expected=TopologyBuilderException.class)
    public void testFrom() {
        KStreamBuilder builder = new KStreamBuilder();
        builder.stream(new String[]{"topic-1", "topic-2"});
        builder.addSource("KSTREAM-SOURCE-0000000000", new String[]{"topic-3"});
    }

    @Test
    public void testNewName() {
        KStreamBuilder builder = new KStreamBuilder();
        Assert.assertEquals((Object)"X-0000000000", (Object)builder.newName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)builder.newName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)builder.newName("Z-"));
        builder = new KStreamBuilder();
        Assert.assertEquals((Object)"X-0000000000", (Object)builder.newName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)builder.newName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)builder.newName("Z-"));
    }

    @Test
    public void testMerge() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        KStreamBuilder builder = new KStreamBuilder();
        KStream source1 = builder.stream(new String[]{topic1});
        KStream source2 = builder.stream(new String[]{topic2});
        KStream merged = builder.merge(new KStream[]{source1, source2});
        MockProcessorSupplier processorSupplier = new MockProcessorSupplier();
        merged.process(processorSupplier, new String[0]);
        this.driver = new KStreamTestDriver(builder);
        this.driver.setTime(0L);
        this.driver.process(topic1, "A", "aa");
        this.driver.process(topic2, "B", "bb");
        this.driver.process(topic2, "C", "cc");
        this.driver.process(topic1, "D", "dd");
        Assert.assertEquals((Object)Utils.mkList((Object[])new String[]{"A:aa", "B:bb", "C:cc", "D:dd"}), processorSupplier.processed);
    }

    @Test
    public void shouldHaveCorrectSourceTopicsForTableFromMergedStream() throws Exception {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        KStreamBuilder builder = new KStreamBuilder();
        KStream source1 = builder.stream(new String[]{"topic-1"});
        KStream source2 = builder.stream(new String[]{"topic-2"});
        KStream source3 = builder.stream(new String[]{"topic-3"});
        KStream merged = builder.merge(new KStream[]{source1, source2, source3});
        merged.groupByKey().count("my-table");
        Map actual = builder.stateStoreNameToSourceTopics();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"topic-1", "topic-2", "topic-3"}), actual.get("my-table"));
    }

    @Test
    public void shouldHaveCorrectSourceTopicsForTableFromMergedStreamWithProcessors() throws Exception {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        KStreamBuilder builder = new KStreamBuilder();
        KStream source1 = builder.stream(new String[]{"topic-1"});
        KStream source2 = builder.stream(new String[]{"topic-2"});
        KStream processedSource1 = source1.mapValues((ValueMapper)new ValueMapper<String, String>(){

            public String apply(String value) {
                return value;
            }
        }).filter((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream processedSource2 = source2.filter((Predicate)new Predicate<String, String>(){

            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream merged = builder.merge(new KStream[]{processedSource1, processedSource2});
        merged.groupByKey().count("my-table");
        Map actual = builder.stateStoreNameToSourceTopics();
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"topic-1", "topic-2"}), actual.get("my-table"));
    }

    @Test(expected=TopologyBuilderException.class)
    public void shouldThrowExceptionWhenNoTopicPresent() throws Exception {
        new KStreamBuilder().stream(new String[0]);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionWhenTopicNamesAreNull() throws Exception {
        new KStreamBuilder().stream(Serdes.String(), Serdes.String(), new String[]{null, null});
    }
}

