/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.junit.Assert;
import org.junit.Test;

public class JoinWindowsTest {
    private static long anySize = 123L;
    private static long anyOtherSize = 456L;

    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        JoinWindows w1 = JoinWindows.of((long)anySize);
        JoinWindows w2 = JoinWindows.of((long)anySize);
        Assert.assertEquals((Object)w1, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w1.hashCode());
        Assert.assertEquals((Object)w1, (Object)w2);
        Assert.assertEquals((Object)w2, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w2.hashCode());
        JoinWindows w3 = JoinWindows.of((long)w2.after).before(anyOtherSize);
        JoinWindows w4 = JoinWindows.of((long)anyOtherSize).after(w2.after);
        Assert.assertEquals((Object)w3, (Object)w4);
        Assert.assertEquals((Object)w4, (Object)w3);
        Assert.assertEquals((long)w3.hashCode(), (long)w4.hashCode());
        Assert.assertNotEquals((String)"must be false for null", null, (Object)w1);
        Assert.assertNotEquals((String)"must be false for different window types", (Object)UnlimitedWindows.of(), (Object)w1);
        Assert.assertNotEquals((String)"must be false for different types", (Object)new Object(), (Object)w1);
        JoinWindows differentWindowSize = JoinWindows.of((long)(w1.after + 1L));
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize, (Object)w1);
        JoinWindows differentWindowSize2 = JoinWindows.of((long)w1.after).after(w1.after + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize2, (Object)w1);
        JoinWindows differentWindowSize3 = JoinWindows.of((long)w1.after).before(w1.before + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize3, (Object)w1);
    }

    @Test
    public void validWindows() {
        JoinWindows.of((long)anyOtherSize).before(anySize).before(0L).before(-anySize).before(-anyOtherSize);
        JoinWindows.of((long)anyOtherSize).after(anySize).after(0L).after(-anySize).after(-anyOtherSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeDifferenceMustNotBeNegative() {
        JoinWindows.of((long)-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void afterBelowLower() {
        JoinWindows.of((long)anySize).after(-anySize - 1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void beforeOverUpper() {
        JoinWindows.of((long)anySize).before(-anySize - 1L);
    }
}

