/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration.utils;

import java.io.IOException;
import java.util.Properties;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.zk.EmbeddedZookeeper;
import org.apache.kafka.streams.integration.utils.KafkaEmbedded;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedKafkaCluster
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKafkaCluster.class);
    private static final int DEFAULT_BROKER_PORT = 0;
    private EmbeddedZookeeper zookeeper = null;
    private final KafkaEmbedded[] brokers;
    public MockTime time = new MockTime();

    public EmbeddedKafkaCluster(int numBrokers) {
        this.brokers = new KafkaEmbedded[numBrokers];
    }

    public void start() throws IOException, InterruptedException {
        Properties brokerConfig = new Properties();
        log.debug("Initiating embedded Kafka cluster startup");
        log.debug("Starting a ZooKeeper instance");
        this.zookeeper = new EmbeddedZookeeper();
        log.debug("ZooKeeper instance is running at {}", (Object)this.zKConnectString());
        brokerConfig.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zKConnectString());
        brokerConfig.put(KafkaConfig$.MODULE$.PortProp(), (Object)0);
        brokerConfig.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), (Object)true);
        brokerConfig.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), (Object)0x200000L);
        brokerConfig.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), (Object)0);
        brokerConfig.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), (Object)false);
        for (int i = 0; i < this.brokers.length; ++i) {
            brokerConfig.put(KafkaConfig$.MODULE$.BrokerIdProp(), (Object)i);
            log.debug("Starting a Kafka instance on port {} ...", (Object)brokerConfig.getProperty(KafkaConfig$.MODULE$.PortProp()));
            this.brokers[i] = new KafkaEmbedded(brokerConfig, this.time);
            log.debug("Kafka instance is running at {}, connected to ZooKeeper at {}", (Object)this.brokers[i].brokerList(), (Object)this.brokers[i].zookeeperConnect());
        }
    }

    public void stop() {
        for (KafkaEmbedded broker : this.brokers) {
            broker.stop();
        }
        this.zookeeper.shutdown();
    }

    public String zKConnectString() {
        return "localhost:" + this.zookeeper.port();
    }

    public String bootstrapServers() {
        return this.brokers[0].brokerList();
    }

    protected void before() throws Throwable {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1, 1, new Properties());
    }

    public void createTopic(String topic, int partitions, int replication) {
        this.createTopic(topic, partitions, replication, new Properties());
    }

    public void createTopic(String topic, int partitions, int replication, Properties topicConfig) {
        this.brokers[0].createTopic(topic, partitions, replication, topicConfig);
    }

    public void deleteTopic(String topic) {
        this.brokers[0].deleteTopic(topic);
    }
}

