/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.utils.MockTime;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.test.MockKeyValueMapper;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KStreamAggregationIntegrationTest {
    private static final int NUM_BROKERS = 1;
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(1);
    private static volatile int testNo = 0;
    private final MockTime mockTime;
    private KStreamBuilder builder;
    private Properties streamsConfiguration;
    private KafkaStreams kafkaStreams;
    private String streamOneInput;
    private String outputTopic;
    private KGroupedStream<String, String> groupedStream;
    private Reducer<String> reducer;
    private Initializer<Integer> initializer;
    private Aggregator<String, String, Integer> aggregator;
    private KStream<Integer, String> stream;
    @Parameterized.Parameter
    public long cacheSizeBytes;

    public KStreamAggregationIntegrationTest() {
        this.mockTime = KStreamAggregationIntegrationTest.CLUSTER.time;
    }

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{0, 0xA00000L};
    }

    @Before
    public void before() {
        this.builder = new KStreamBuilder();
        this.createTopics();
        this.streamsConfiguration = new Properties();
        String applicationId = "kgrouped-stream-test-" + ++testNo;
        this.streamsConfiguration.put("application.id", applicationId);
        this.streamsConfiguration.put("bootstrap.servers", CLUSTER.bootstrapServers());
        this.streamsConfiguration.put("zookeeper.connect", CLUSTER.zKConnectString());
        this.streamsConfiguration.put("auto.offset.reset", "earliest");
        this.streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        this.streamsConfiguration.put("commit.interval.ms", (Object)1);
        this.streamsConfiguration.put("cache.max.bytes.buffering", (Object)this.cacheSizeBytes);
        KeyValueMapper mapper = MockKeyValueMapper.SelectValueMapper();
        this.stream = this.builder.stream(Serdes.Integer(), Serdes.String(), new String[]{this.streamOneInput});
        this.groupedStream = this.stream.groupBy(mapper, Serdes.String(), Serdes.String());
        this.reducer = new Reducer<String>(){

            public String apply(String value1, String value2) {
                return value1 + ":" + value2;
            }
        };
        this.initializer = new Initializer<Integer>(){

            public Integer apply() {
                return 0;
            }
        };
        this.aggregator = new Aggregator<String, String, Integer>(){

            public Integer apply(String aggKey, String value, Integer aggregate) {
                return aggregate + value.length();
            }
        };
    }

    @After
    public void whenShuttingDown() throws IOException {
        if (this.kafkaStreams != null) {
            this.kafkaStreams.close();
        }
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfiguration);
    }

    @Test
    public void shouldReduce() throws Exception {
        this.produceMessages(this.mockTime.milliseconds());
        this.groupedStream.reduce(this.reducer, "reduce-by-key").to(Serdes.String(), Serdes.String(), this.outputTopic);
        this.startStreams();
        this.produceMessages(this.mockTime.milliseconds());
        List results = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), 10);
        Collections.sort(results, new Comparator<KeyValue<String, String>>(){

            @Override
            public int compare(KeyValue<String, String> o1, KeyValue<String, String> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        });
        MatcherAssert.assertThat(results, (Matcher)Is.is(Arrays.asList(KeyValue.pair((Object)"A", (Object)"A"), KeyValue.pair((Object)"A", (Object)"A:A"), KeyValue.pair((Object)"B", (Object)"B"), KeyValue.pair((Object)"B", (Object)"B:B"), KeyValue.pair((Object)"C", (Object)"C"), KeyValue.pair((Object)"C", (Object)"C:C"), KeyValue.pair((Object)"D", (Object)"D"), KeyValue.pair((Object)"D", (Object)"D:D"), KeyValue.pair((Object)"E", (Object)"E"), KeyValue.pair((Object)"E", (Object)"E:E"))));
    }

    private static <K extends Comparable, V extends Comparable> int compare(KeyValue<K, V> o1, KeyValue<K, V> o2) {
        int keyComparison = ((Comparable)o1.key).compareTo(o2.key);
        if (keyComparison == 0) {
            return ((Comparable)o1.value).compareTo(o2.value);
        }
        return keyComparison;
    }

    @Test
    public void shouldReduceWindowed() throws Exception {
        long firstBatchTimestamp = this.mockTime.milliseconds();
        this.mockTime.sleep(1000L);
        this.produceMessages(firstBatchTimestamp);
        long secondBatchTimestamp = this.mockTime.milliseconds();
        this.produceMessages(secondBatchTimestamp);
        this.produceMessages(secondBatchTimestamp);
        this.groupedStream.reduce(this.reducer, (Windows)TimeWindows.of((long)500L), "reduce-time-windows").toStream((KeyValueMapper)new KeyValueMapper<Windowed<String>, String, String>(){

            public String apply(Windowed<String> windowedKey, String value) {
                return (String)windowedKey.key() + "@" + windowedKey.window().start();
            }
        }).to(Serdes.String(), Serdes.String(), this.outputTopic);
        this.startStreams();
        List windowedOutput = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), 15);
        Comparator<KeyValue<String, String>> comparator = new Comparator<KeyValue<String, String>>(){

            @Override
            public int compare(KeyValue<String, String> o1, KeyValue<String, String> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        };
        Collections.sort(windowedOutput, comparator);
        long firstBatchWindow = firstBatchTimestamp / 500L * 500L;
        long secondBatchWindow = secondBatchTimestamp / 500L * 500L;
        MatcherAssert.assertThat(windowedOutput, (Matcher)Is.is(Arrays.asList(new KeyValue((Object)("A@" + firstBatchWindow), (Object)"A"), new KeyValue((Object)("A@" + secondBatchWindow), (Object)"A"), new KeyValue((Object)("A@" + secondBatchWindow), (Object)"A:A"), new KeyValue((Object)("B@" + firstBatchWindow), (Object)"B"), new KeyValue((Object)("B@" + secondBatchWindow), (Object)"B"), new KeyValue((Object)("B@" + secondBatchWindow), (Object)"B:B"), new KeyValue((Object)("C@" + firstBatchWindow), (Object)"C"), new KeyValue((Object)("C@" + secondBatchWindow), (Object)"C"), new KeyValue((Object)("C@" + secondBatchWindow), (Object)"C:C"), new KeyValue((Object)("D@" + firstBatchWindow), (Object)"D"), new KeyValue((Object)("D@" + secondBatchWindow), (Object)"D"), new KeyValue((Object)("D@" + secondBatchWindow), (Object)"D:D"), new KeyValue((Object)("E@" + firstBatchWindow), (Object)"E"), new KeyValue((Object)("E@" + secondBatchWindow), (Object)"E"), new KeyValue((Object)("E@" + secondBatchWindow), (Object)"E:E"))));
    }

    @Test
    public void shouldAggregate() throws Exception {
        this.produceMessages(this.mockTime.milliseconds());
        this.groupedStream.aggregate(this.initializer, this.aggregator, Serdes.Integer(), "aggregate-by-selected-key").to(Serdes.String(), Serdes.Integer(), this.outputTopic);
        this.startStreams();
        this.produceMessages(this.mockTime.milliseconds());
        List results = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new IntegerDeserializer(), 10);
        Collections.sort(results, new Comparator<KeyValue<String, Integer>>(){

            @Override
            public int compare(KeyValue<String, Integer> o1, KeyValue<String, Integer> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        });
        MatcherAssert.assertThat(results, (Matcher)Is.is(Arrays.asList(KeyValue.pair((Object)"A", (Object)1), KeyValue.pair((Object)"A", (Object)2), KeyValue.pair((Object)"B", (Object)1), KeyValue.pair((Object)"B", (Object)2), KeyValue.pair((Object)"C", (Object)1), KeyValue.pair((Object)"C", (Object)2), KeyValue.pair((Object)"D", (Object)1), KeyValue.pair((Object)"D", (Object)2), KeyValue.pair((Object)"E", (Object)1), KeyValue.pair((Object)"E", (Object)2))));
    }

    @Test
    public void shouldAggregateWindowed() throws Exception {
        long firstTimestamp = this.mockTime.milliseconds();
        this.mockTime.sleep(1000L);
        this.produceMessages(firstTimestamp);
        long secondTimestamp = this.mockTime.milliseconds();
        this.produceMessages(secondTimestamp);
        this.produceMessages(secondTimestamp);
        this.groupedStream.aggregate(this.initializer, this.aggregator, (Windows)TimeWindows.of((long)500L), Serdes.Integer(), "aggregate-by-key-windowed").toStream((KeyValueMapper)new KeyValueMapper<Windowed<String>, Integer, String>(){

            public String apply(Windowed<String> windowedKey, Integer value) {
                return (String)windowedKey.key() + "@" + windowedKey.window().start();
            }
        }).to(Serdes.String(), Serdes.Integer(), this.outputTopic);
        this.startStreams();
        List windowedMessages = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new IntegerDeserializer(), 15);
        Comparator<KeyValue<String, Integer>> comparator = new Comparator<KeyValue<String, Integer>>(){

            @Override
            public int compare(KeyValue<String, Integer> o1, KeyValue<String, Integer> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        };
        Collections.sort(windowedMessages, comparator);
        long firstWindow = firstTimestamp / 500L * 500L;
        long secondWindow = secondTimestamp / 500L * 500L;
        MatcherAssert.assertThat(windowedMessages, (Matcher)Is.is(Arrays.asList(new KeyValue((Object)("A@" + firstWindow), (Object)1), new KeyValue((Object)("A@" + secondWindow), (Object)1), new KeyValue((Object)("A@" + secondWindow), (Object)2), new KeyValue((Object)("B@" + firstWindow), (Object)1), new KeyValue((Object)("B@" + secondWindow), (Object)1), new KeyValue((Object)("B@" + secondWindow), (Object)2), new KeyValue((Object)("C@" + firstWindow), (Object)1), new KeyValue((Object)("C@" + secondWindow), (Object)1), new KeyValue((Object)("C@" + secondWindow), (Object)2), new KeyValue((Object)("D@" + firstWindow), (Object)1), new KeyValue((Object)("D@" + secondWindow), (Object)1), new KeyValue((Object)("D@" + secondWindow), (Object)2), new KeyValue((Object)("E@" + firstWindow), (Object)1), new KeyValue((Object)("E@" + secondWindow), (Object)1), new KeyValue((Object)("E@" + secondWindow), (Object)2))));
    }

    @Test
    public void shouldCount() throws Exception {
        this.produceMessages(this.mockTime.milliseconds());
        this.groupedStream.count("count-by-key").to(Serdes.String(), Serdes.Long(), this.outputTopic);
        this.startStreams();
        this.produceMessages(this.mockTime.milliseconds());
        List results = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), 10);
        Collections.sort(results, new Comparator<KeyValue<String, Long>>(){

            @Override
            public int compare(KeyValue<String, Long> o1, KeyValue<String, Long> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        });
        MatcherAssert.assertThat(results, (Matcher)Is.is(Arrays.asList(KeyValue.pair((Object)"A", (Object)1L), KeyValue.pair((Object)"A", (Object)2L), KeyValue.pair((Object)"B", (Object)1L), KeyValue.pair((Object)"B", (Object)2L), KeyValue.pair((Object)"C", (Object)1L), KeyValue.pair((Object)"C", (Object)2L), KeyValue.pair((Object)"D", (Object)1L), KeyValue.pair((Object)"D", (Object)2L), KeyValue.pair((Object)"E", (Object)1L), KeyValue.pair((Object)"E", (Object)2L))));
    }

    @Test
    public void shouldGroupByKey() throws Exception {
        long timestamp = this.mockTime.milliseconds();
        this.produceMessages(timestamp);
        this.produceMessages(timestamp);
        this.stream.groupByKey(Serdes.Integer(), Serdes.String()).count((Windows)TimeWindows.of((long)500L), "count-windows").toStream((KeyValueMapper)new KeyValueMapper<Windowed<Integer>, Long, String>(){

            public String apply(Windowed<Integer> windowedKey, Long value) {
                return windowedKey.key() + "@" + windowedKey.window().start();
            }
        }).to(Serdes.String(), Serdes.Long(), this.outputTopic);
        this.startStreams();
        List results = this.receiveMessages((Deserializer)new StringDeserializer(), (Deserializer)new LongDeserializer(), 10);
        Collections.sort(results, new Comparator<KeyValue<String, Long>>(){

            @Override
            public int compare(KeyValue<String, Long> o1, KeyValue<String, Long> o2) {
                return KStreamAggregationIntegrationTest.compare(o1, o2);
            }
        });
        long window = timestamp / 500L * 500L;
        MatcherAssert.assertThat(results, (Matcher)Is.is(Arrays.asList(KeyValue.pair((Object)("1@" + window), (Object)1L), KeyValue.pair((Object)("1@" + window), (Object)2L), KeyValue.pair((Object)("2@" + window), (Object)1L), KeyValue.pair((Object)("2@" + window), (Object)2L), KeyValue.pair((Object)("3@" + window), (Object)1L), KeyValue.pair((Object)("3@" + window), (Object)2L), KeyValue.pair((Object)("4@" + window), (Object)1L), KeyValue.pair((Object)("4@" + window), (Object)2L), KeyValue.pair((Object)("5@" + window), (Object)1L), KeyValue.pair((Object)("5@" + window), (Object)2L))));
    }

    private void produceMessages(long timestamp) throws ExecutionException, InterruptedException {
        IntegrationTestUtils.produceKeyValuesSynchronouslyWithTimestamp(this.streamOneInput, Arrays.asList(new KeyValue((Object)1, (Object)"A"), new KeyValue((Object)2, (Object)"B"), new KeyValue((Object)3, (Object)"C"), new KeyValue((Object)4, (Object)"D"), new KeyValue((Object)5, (Object)"E")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), IntegerSerializer.class, StringSerializer.class, (Properties)new Properties()), timestamp);
    }

    private void createTopics() {
        this.streamOneInput = "stream-one-" + testNo;
        this.outputTopic = "output-" + testNo;
        CLUSTER.createTopic(this.streamOneInput, 3, 1);
        CLUSTER.createTopic(this.outputTopic);
    }

    private void startStreams() {
        this.kafkaStreams = new KafkaStreams((TopologyBuilder)this.builder, this.streamsConfiguration);
        this.kafkaStreams.start();
    }

    private <K, V> List<KeyValue<K, V>> receiveMessages(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int numMessages) throws InterruptedException {
        Properties consumerProperties = new Properties();
        consumerProperties.setProperty("bootstrap.servers", CLUSTER.bootstrapServers());
        consumerProperties.setProperty("group.id", "kgroupedstream-test-" + testNo);
        consumerProperties.setProperty("auto.offset.reset", "earliest");
        consumerProperties.setProperty("key.deserializer", keyDeserializer.getClass().getName());
        consumerProperties.setProperty("value.deserializer", valueDeserializer.getClass().getName());
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived(consumerProperties, this.outputTopic, numMessages, 60000L);
    }
}

