/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.tests.SmokeTestClient;
import org.apache.kafka.streams.tests.SmokeTestDriver;

public class StreamsSmokeTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("StreamsSmokeTest are expecting two parameters: propFile, command; but only see " + args.length + " parameter");
            Exit.exit((int)1);
        }
        String propFileName = args[0];
        String command = args[1];
        boolean disableAutoTerminate = args.length > 2;
        Properties streamsProperties = Utils.loadProps((String)propFileName);
        String kafka = streamsProperties.getProperty("bootstrap.servers");
        String processingGuarantee = streamsProperties.getProperty("processing.guarantee");
        if (kafka == null) {
            System.err.println("No bootstrap kafka servers specified in bootstrap.servers");
            Exit.exit((int)1);
        }
        if ("process".equals(command) && !"at_least_once".equals(processingGuarantee) && !"exactly_once_v2".equals(processingGuarantee)) {
            System.err.println("processingGuarantee must be either at_least_once or exactly_once_v2");
            Exit.exit((int)1);
        }
        System.out.println("StreamsTest instance started (StreamsSmokeTest)");
        System.out.println("command=" + command);
        System.out.println("props=" + streamsProperties);
        System.out.println("disableAutoTerminate=" + disableAutoTerminate);
        switch (command) {
            case "run": {
                int numKeys = 10;
                int maxRecordsPerKey = 500;
                if (disableAutoTerminate) {
                    SmokeTestDriver.generatePerpetually(kafka, 10, 500);
                    break;
                }
                Map<String, Set<Integer>> allData = SmokeTestDriver.generate(kafka, 10, 500, Duration.ofSeconds(30L));
                SmokeTestDriver.verify(kafka, allData, 500);
                break;
            }
            case "process": {
                new SmokeTestClient(UUID.randomUUID().toString()).start(streamsProperties);
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
            }
        }
    }
}

