/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.TopologyTestDriver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockTimeTest {
    @Test
    public void shouldSetStartTime() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assertions.assertEquals((long)42L, (long)time.milliseconds());
        Assertions.assertEquals((long)42000000L, (long)time.nanoseconds());
    }

    @Test
    public void shouldGetNanosAsMillis() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assertions.assertEquals((long)42L, (long)time.hiResClockMs());
    }

    @Test
    public void shouldNotAllowNegativeSleep() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TopologyTestDriver.MockTime(42L).sleep(-1L));
    }

    @Test
    public void shouldAdvanceTimeOnSleep() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assertions.assertEquals((long)42L, (long)time.milliseconds());
        time.sleep(1L);
        Assertions.assertEquals((long)43L, (long)time.milliseconds());
        time.sleep(0L);
        Assertions.assertEquals((long)43L, (long)time.milliseconds());
        time.sleep(3L);
        Assertions.assertEquals((long)46L, (long)time.milliseconds());
    }
}

