/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test.wordcount;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.test.wordcount.WindowedWordCountProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class WindowedWordCountProcessorTest {
    @Test
    public void shouldWorkWithInMemoryStore() {
        MockProcessorContext context = new MockProcessorContext();
        WindowStore store = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"WindowedCounts", (Duration)Duration.ofDays(24L), (Duration)Duration.ofMillis(100L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.Integer()).withLoggingDisabled().withCachingDisabled().build();
        store.init(context.getStateStoreContext(), (StateStore)store);
        context.getStateStoreContext().register((StateStore)store, null);
        Processor<String, String, String, String> processor = new WindowedWordCountProcessorSupplier().get();
        processor.init((ProcessorContext)context);
        processor.process(new Record((Object)"key", (Object)"alpha beta gamma alpha", 101L));
        processor.process(new Record((Object)"key", (Object)"gamma delta", 221L));
        MatcherAssert.assertThat((Object)context.forwarded().isEmpty(), (Matcher)Matchers.is((Object)true));
        ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(1000L);
        List capturedForwards = context.forwarded();
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"[alpha@100/200]", (Object)"2", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[beta@100/200]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[gamma@100/200]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[delta@200/300]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[gamma@200/300]", (Object)"1", 1000L)));
        MatcherAssert.assertThat((Object)capturedForwards, (Matcher)Matchers.is(expected));
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWorkWithPersistentStore() throws IOException {
        File stateDir = TestUtils.tempDirectory();
        try {
            MockProcessorContext context = new MockProcessorContext(new Properties(), new TaskId(0, 0), stateDir);
            WindowStore store = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"WindowedCounts", (Duration)Duration.ofDays(24L), (Duration)Duration.ofMillis(100L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.Integer()).withLoggingDisabled().withCachingDisabled().build();
            store.init(context.getStateStoreContext(), (StateStore)store);
            context.getStateStoreContext().register((StateStore)store, null);
            Processor<String, String, String, String> processor = new WindowedWordCountProcessorSupplier().get();
            processor.init((ProcessorContext)context);
            processor.process(new Record((Object)"key", (Object)"alpha beta gamma alpha", 101L));
            processor.process(new Record((Object)"key", (Object)"gamma delta", 221L));
            MatcherAssert.assertThat((Object)context.forwarded().isEmpty(), (Matcher)Matchers.is((Object)true));
            ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(1000L);
            List capturedForwards = context.forwarded();
            List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"[alpha@100/200]", (Object)"2", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[beta@100/200]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[delta@200/300]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[gamma@100/200]", (Object)"1", 1000L)), new MockProcessorContext.CapturedForward(new Record((Object)"[gamma@200/300]", (Object)"1", 1000L)));
            MatcherAssert.assertThat((Object)capturedForwards, (Matcher)Matchers.is(expected));
            store.close();
        }
        finally {
            Utils.delete((File)stateDir);
        }
    }
}

