/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test.wordcount;

import java.time.Duration;
import java.util.Locale;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;

public final class WindowedWordCountProcessorSupplier
implements ProcessorSupplier<String, String, String, String> {
    public Processor<String, String, String, String> get() {
        return new Processor<String, String, String, String>(){
            private WindowStore<String, Integer> windowStore;

            public void init(ProcessorContext<String, String> context) {
                context.schedule(Duration.ofSeconds(1L), PunctuationType.STREAM_TIME, timestamp -> {
                    try (KeyValueIterator iter = this.windowStore.all();){
                        while (iter.hasNext()) {
                            KeyValue entry = (KeyValue)iter.next();
                            context.forward(new Record((Object)((Windowed)entry.key).toString(), (Object)((Integer)entry.value).toString(), timestamp));
                        }
                    }
                });
                this.windowStore = (WindowStore)context.getStateStore("WindowedCounts");
            }

            public void process(Record<String, String> record) {
                String[] words = ((String)record.value()).toLowerCase(Locale.getDefault()).split(" ");
                long timestamp = record.timestamp();
                long windowStart = timestamp / 100L * 100L;
                for (String word : words) {
                    Integer oldValue = (Integer)this.windowStore.fetch((Object)word, windowStart);
                    if (oldValue == null) {
                        this.windowStore.put((Object)word, (Object)1, windowStart);
                        continue;
                    }
                    this.windowStore.put((Object)word, (Object)(oldValue + 1), windowStart);
                }
            }
        };
    }
}

