/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MockProcessorContextStateStoreTest {
    public static Stream<Arguments> parameters() {
        StoreBuilder builder;
        List<Boolean> booleans = Arrays.asList(true, false);
        ArrayList<Arguments> values = new ArrayList<Arguments>();
        for (Boolean timestamped : booleans) {
            for (Boolean caching : booleans) {
                for (Boolean logging : booleans) {
                    List<KeyValueBytesStoreSupplier> keyValueBytesStoreSuppliers = Arrays.asList(Stores.inMemoryKeyValueStore((String)("kv" + timestamped + caching + logging)), Stores.persistentKeyValueStore((String)("kv" + timestamped + caching + logging)), Stores.persistentTimestampedKeyValueStore((String)("kv" + timestamped + caching + logging)));
                    for (KeyValueBytesStoreSupplier keyValueBytesStoreSupplier : keyValueBytesStoreSuppliers) {
                        builder = timestamped != false ? Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)keyValueBytesStoreSupplier, (Serde)Serdes.String(), (Serde)Serdes.Long()) : Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)keyValueBytesStoreSupplier, (Serde)Serdes.String(), (Serde)Serdes.Long());
                        if (caching.booleanValue()) {
                            builder.withCachingEnabled();
                        } else {
                            builder.withCachingDisabled();
                        }
                        if (logging.booleanValue()) {
                            builder.withLoggingEnabled(Collections.emptyMap());
                        } else {
                            builder.withLoggingDisabled();
                        }
                        values.add(Arguments.of((Object[])new Object[]{builder, timestamped, caching, logging}));
                    }
                }
            }
        }
        for (Boolean timestamped : booleans) {
            for (Boolean caching : booleans) {
                for (Boolean logging : booleans) {
                    List<WindowBytesStoreSupplier> windowBytesStoreSuppliers = Arrays.asList(Stores.inMemoryWindowStore((String)("w" + timestamped + caching + logging), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L), (boolean)false), Stores.persistentWindowStore((String)("w" + timestamped + caching + logging), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L), (boolean)false), Stores.persistentTimestampedWindowStore((String)("w" + timestamped + caching + logging), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L), (boolean)false));
                    for (WindowBytesStoreSupplier windowBytesStoreSupplier : windowBytesStoreSuppliers) {
                        builder = timestamped != false ? Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)windowBytesStoreSupplier, (Serde)Serdes.String(), (Serde)Serdes.Long()) : Stores.windowStoreBuilder((WindowBytesStoreSupplier)windowBytesStoreSupplier, (Serde)Serdes.String(), (Serde)Serdes.Long());
                        if (caching.booleanValue()) {
                            builder.withCachingEnabled();
                        } else {
                            builder.withCachingDisabled();
                        }
                        if (logging.booleanValue()) {
                            builder.withLoggingEnabled(Collections.emptyMap());
                        } else {
                            builder.withLoggingDisabled();
                        }
                        values.add(Arguments.of((Object[])new Object[]{builder, timestamped, caching, logging}));
                    }
                }
            }
        }
        for (Boolean caching : booleans) {
            for (Boolean logging : booleans) {
                List<SessionBytesStoreSupplier> sessionBytesStoreSuppliers = Arrays.asList(Stores.inMemorySessionStore((String)("s" + caching + logging), (Duration)Duration.ofSeconds(1L)), Stores.persistentSessionStore((String)("s" + caching + logging), (Duration)Duration.ofSeconds(1L)));
                for (SessionBytesStoreSupplier supplier : sessionBytesStoreSuppliers) {
                    StoreBuilder builder2 = Stores.sessionStoreBuilder((SessionBytesStoreSupplier)supplier, (Serde)Serdes.String(), (Serde)Serdes.Long());
                    if (caching.booleanValue()) {
                        builder2.withCachingEnabled();
                    } else {
                        builder2.withCachingDisabled();
                    }
                    if (logging.booleanValue()) {
                        builder2.withLoggingEnabled(Collections.emptyMap());
                    } else {
                        builder2.withLoggingDisabled();
                    }
                    values.add(Arguments.of((Object[])new Object[]{builder2, false, caching, logging}));
                }
            }
        }
        return values.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="builder = {0}, timestamped = {1}, caching = {2}, logging = {3}")
    @MethodSource(value={"parameters"})
    public void shouldEitherInitOrThrow(StoreBuilder<StateStore> builder, boolean timestamped, boolean caching, boolean logging) {
        File stateDir = TestUtils.tempDirectory();
        try {
            MockProcessorContext context = new MockProcessorContext(Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)""), Utils.mkEntry((Object)"bootstrap.servers", (Object)"")})), new TaskId(0, 0), stateDir);
            StateStore store = builder.build();
            if (caching || logging) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> store.init(context.getStateStoreContext(), store));
            } else {
                store.init(context.getStateStoreContext(), store);
                store.close();
            }
        }
        finally {
            try {
                Utils.delete((File)stateDir);
            }
            catch (IOException iOException) {}
        }
    }
}

