/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WindowStoreFacadeTest {
    private final TimestampedWindowStore<String, String> mockedWindowTimestampStore = (TimestampedWindowStore)Mockito.mock(TimestampedWindowStore.class);
    private TopologyTestDriver.WindowStoreFacade<String, String> windowStoreFacade;

    @BeforeEach
    public void setup() {
        this.windowStoreFacade = new TopologyTestDriver.WindowStoreFacade(this.mockedWindowTimestampStore);
    }

    @Test
    public void shouldForwardDeprecatedInit() {
        ProcessorContext context = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        StateStore store = (StateStore)Mockito.mock(StateStore.class);
        this.windowStoreFacade.init(context, store);
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).init(context, store);
    }

    @Test
    public void shouldForwardInit() {
        StateStoreContext context = (StateStoreContext)Mockito.mock(StateStoreContext.class);
        StateStore store = (StateStore)Mockito.mock(StateStore.class);
        this.windowStoreFacade.init(context, store);
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).init(context, store);
    }

    @Test
    public void shouldPutWindowStartTimestampWithUnknownTimestamp() {
        this.windowStoreFacade.put((Object)"key", (Object)"value", 21L);
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).put((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L), 21L);
    }

    @Test
    public void shouldForwardFlush() {
        this.windowStoreFacade.flush();
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).flush();
    }

    @Test
    public void shouldForwardClose() {
        this.windowStoreFacade.close();
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).close();
    }

    @Test
    public void shouldReturnName() {
        Mockito.when((Object)this.mockedWindowTimestampStore.name()).thenReturn((Object)"name");
        MatcherAssert.assertThat((Object)this.windowStoreFacade.name(), (Matcher)CoreMatchers.is((Object)"name"));
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore)).name();
    }

    @Test
    public void shouldReturnIsPersistent() {
        Mockito.when((Object)this.mockedWindowTimestampStore.persistent()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        MatcherAssert.assertThat((Object)this.windowStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.windowStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)false));
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore, (VerificationMode)Mockito.times((int)2))).persistent();
    }

    @Test
    public void shouldReturnIsOpen() {
        Mockito.when((Object)this.mockedWindowTimestampStore.isOpen()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        MatcherAssert.assertThat((Object)this.windowStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.windowStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        ((TimestampedWindowStore)Mockito.verify(this.mockedWindowTimestampStore, (VerificationMode)Mockito.times((int)2))).isOpen();
    }
}

