/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.time.Instant;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.streams.test.TestRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestRecordTest {
    private final String key = "testKey";
    private final int value = 1;
    private final Headers headers = new RecordHeaders(new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null), new RecordHeader("\"A\\u00ea\\u00f1\\u00fcC\"", "value".getBytes())});
    private final Instant recordTime = Instant.parse("2019-06-01T10:00:00Z");
    private final long recordMs = this.recordTime.toEpochMilli();

    @Test
    public void testFields() {
        TestRecord testRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        MatcherAssert.assertThat((Object)testRecord.key(), (Matcher)CoreMatchers.equalTo((Object)"testKey"));
        MatcherAssert.assertThat((Object)testRecord.value(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)testRecord.headers(), (Matcher)CoreMatchers.equalTo((Object)this.headers));
        MatcherAssert.assertThat((Object)testRecord.timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.recordMs));
        MatcherAssert.assertThat((Object)testRecord.getKey(), (Matcher)CoreMatchers.equalTo((Object)"testKey"));
        MatcherAssert.assertThat((Object)testRecord.getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)testRecord.getHeaders(), (Matcher)CoreMatchers.equalTo((Object)this.headers));
        MatcherAssert.assertThat((Object)testRecord.getRecordTime(), (Matcher)CoreMatchers.equalTo((Object)this.recordTime));
    }

    @Test
    public void testMultiFieldMatcher() {
        TestRecord testRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        MatcherAssert.assertThat((Object)testRecord, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)CoreMatchers.equalTo((Object)"testKey")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)1)), (Matcher)Matchers.hasProperty((String)"headers", (Matcher)CoreMatchers.equalTo((Object)this.headers))));
        MatcherAssert.assertThat((Object)testRecord, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)CoreMatchers.equalTo((Object)"testKey")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)1)), (Matcher)Matchers.hasProperty((String)"headers", (Matcher)CoreMatchers.equalTo((Object)this.headers)), (Matcher)Matchers.hasProperty((String)"recordTime", (Matcher)CoreMatchers.equalTo((Object)this.recordTime))));
        MatcherAssert.assertThat((Object)testRecord, (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)CoreMatchers.equalTo((Object)"testKey")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.equalTo((Object)1))));
    }

    @Test
    public void testEqualsAndHashCode() {
        TestRecord testRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        Assert.assertEquals((Object)testRecord, (Object)testRecord);
        Assert.assertEquals((long)testRecord.hashCode(), (long)testRecord.hashCode());
        TestRecord equalRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        Assert.assertEquals((Object)testRecord, (Object)equalRecord);
        Assert.assertEquals((long)testRecord.hashCode(), (long)equalRecord.hashCode());
        TestRecord equalRecordMs = new TestRecord((Object)"testKey", (Object)1, this.headers, Long.valueOf(this.recordMs));
        Assert.assertEquals((Object)testRecord, (Object)equalRecordMs);
        Assert.assertEquals((long)testRecord.hashCode(), (long)equalRecordMs.hashCode());
        RecordHeaders headers2 = new RecordHeaders(new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null)});
        TestRecord headerMismatch = new TestRecord((Object)"testKey", (Object)1, (Headers)headers2, this.recordTime);
        Assert.assertNotEquals((Object)testRecord, (Object)headerMismatch);
        TestRecord keyMisMatch = new TestRecord((Object)"test-mismatch", (Object)1, this.headers, this.recordTime);
        Assert.assertNotEquals((Object)testRecord, (Object)keyMisMatch);
        TestRecord valueMisMatch = new TestRecord((Object)"testKey", (Object)2, this.headers, this.recordTime);
        Assert.assertNotEquals((Object)testRecord, (Object)valueMisMatch);
        TestRecord timeMisMatch = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime.plusMillis(1L));
        Assert.assertNotEquals((Object)testRecord, (Object)timeMisMatch);
        TestRecord nullFieldsRecord = new TestRecord(null, null, null, (Instant)null);
        Assert.assertEquals((Object)nullFieldsRecord, (Object)nullFieldsRecord);
        Assert.assertEquals((long)nullFieldsRecord.hashCode(), (long)nullFieldsRecord.hashCode());
    }

    @Test
    public void testPartialConstructorEquals() {
        TestRecord record1 = new TestRecord((Object)1);
        MatcherAssert.assertThat((Object)record1, (Matcher)CoreMatchers.equalTo((Object)new TestRecord(null, (Object)1, null, (Instant)null)));
        TestRecord record2 = new TestRecord((Object)"testKey", (Object)1);
        MatcherAssert.assertThat((Object)record2, (Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)"testKey", (Object)1, null, (Instant)null)));
        TestRecord record3 = new TestRecord((Object)"testKey", (Object)1, this.headers);
        MatcherAssert.assertThat((Object)record3, (Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)"testKey", (Object)1, this.headers, (Long)null)));
        TestRecord record4 = new TestRecord((Object)"testKey", (Object)1, this.recordTime);
        MatcherAssert.assertThat((Object)record4, (Matcher)CoreMatchers.equalTo((Object)new TestRecord((Object)"testKey", (Object)1, null, Long.valueOf(this.recordMs))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRecords() {
        new TestRecord((Object)"testKey", (Object)1, this.headers, Long.valueOf(-1L));
    }

    @Test
    public void testToString() {
        TestRecord testRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        MatcherAssert.assertThat((Object)testRecord.toString(), (Matcher)CoreMatchers.equalTo((Object)"TestRecord[key=testKey, value=1, headers=RecordHeaders(headers = [RecordHeader(key = foo, value = [118, 97, 108, 117, 101]), RecordHeader(key = bar, value = null), RecordHeader(key = \"A\\u00ea\\u00f1\\u00fcC\", value = [118, 97, 108, 117, 101])], isReadOnly = false), recordTime=2019-06-01T10:00:00Z]"));
    }

    @Test
    public void testConsumerRecord() {
        String topicName = "topic";
        ConsumerRecord consumerRecord = new ConsumerRecord("topic", 1, 0L, this.recordMs, TimestampType.CREATE_TIME, Long.valueOf(0L), 0, 0, (Object)"testKey", (Object)1, this.headers);
        TestRecord testRecord = new TestRecord(consumerRecord);
        TestRecord expectedRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        Assert.assertEquals((Object)expectedRecord, (Object)testRecord);
    }

    @Test
    public void testProducerRecord() {
        String topicName = "topic";
        ProducerRecord producerRecord = new ProducerRecord("topic", Integer.valueOf(1), Long.valueOf(this.recordMs), (Object)"testKey", (Object)1, (Iterable)this.headers);
        TestRecord testRecord = new TestRecord(producerRecord);
        TestRecord expectedRecord = new TestRecord((Object)"testKey", (Object)1, this.headers, this.recordTime);
        Assert.assertEquals((Object)expectedRecord, (Object)testRecord);
        Assert.assertNotEquals((Object)expectedRecord, (Object)producerRecord);
    }
}

