/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import org.apache.kafka.streams.internals.WindowStoreFacade;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class WindowStoreFacadeTest {
    @Mock
    private TimestampedWindowStore<String, String> mockedWindowTimestampStore;
    private WindowStoreFacade<String, String> windowStoreFacade;

    @Before
    public void setup() {
        this.windowStoreFacade = new WindowStoreFacade(this.mockedWindowTimestampStore);
    }

    @Test
    public void shouldForwardInit() {
        ProcessorContext context = (ProcessorContext)EasyMock.mock(ProcessorContext.class);
        StateStore store = (StateStore)EasyMock.mock(StateStore.class);
        this.mockedWindowTimestampStore.init(context, store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        this.windowStoreFacade.init(context, store);
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldPutWithUnknownTimestamp() {
        this.mockedWindowTimestampStore.put((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        this.windowStoreFacade.put((Object)"key", (Object)"value");
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldPutWindowStartTimestampWithUnknownTimestamp() {
        this.mockedWindowTimestampStore.put((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L), 21L);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        this.windowStoreFacade.put((Object)"key", (Object)"value", 21L);
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldForwardFlush() {
        this.mockedWindowTimestampStore.flush();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        this.windowStoreFacade.flush();
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldForwardClose() {
        this.mockedWindowTimestampStore.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        this.windowStoreFacade.close();
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnName() {
        EasyMock.expect((Object)this.mockedWindowTimestampStore.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        MatcherAssert.assertThat((Object)this.windowStoreFacade.name(), (Matcher)CoreMatchers.is((Object)"name"));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnIsPersistent() {
        EasyMock.expect((Object)this.mockedWindowTimestampStore.persistent()).andReturn((Object)true).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        MatcherAssert.assertThat((Object)this.windowStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.windowStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)false));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }

    @Test
    public void shouldReturnIsOpen() {
        EasyMock.expect((Object)this.mockedWindowTimestampStore.isOpen()).andReturn((Object)true).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.mockedWindowTimestampStore});
        MatcherAssert.assertThat((Object)this.windowStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.windowStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        EasyMock.verify((Object[])new Object[]{this.mockedWindowTimestampStore});
    }
}

