/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.util.Arrays;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.internals.KeyValueStoreFacade;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class KeyValueStoreFacadeTest {
    @Mock
    private TimestampedKeyValueStore<String, String> mockedKeyValueTimestampStore;
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueTimestampIterator;
    private KeyValueStoreFacade<String, String> keyValueStoreFacade;

    @Before
    public void setup() {
        this.keyValueStoreFacade = new KeyValueStoreFacade(this.mockedKeyValueTimestampStore);
    }

    @Test
    public void shouldForwardInit() {
        ProcessorContext context = (ProcessorContext)EasyMock.mock(ProcessorContext.class);
        StateStore store = (StateStore)EasyMock.mock(StateStore.class);
        this.mockedKeyValueTimestampStore.init(context, store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        this.keyValueStoreFacade.init(context, store);
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldPutWithUnknownTimestamp() {
        this.mockedKeyValueTimestampStore.put((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        this.keyValueStoreFacade.put((Object)"key", (Object)"value");
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldPutIfAbsentWithUnknownTimestamp() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.putIfAbsent((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)-1L))).andReturn(null).andReturn((Object)ValueAndTimestamp.make((Object)"oldValue", (long)42L));
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        Assert.assertNull((Object)this.keyValueStoreFacade.putIfAbsent((Object)"key", (Object)"value"));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.putIfAbsent((Object)"key", (Object)"value"), (Matcher)CoreMatchers.is((Object)"oldValue"));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldPutAllWithUnknownTimestamp() {
        this.mockedKeyValueTimestampStore.put((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)-1L));
        this.mockedKeyValueTimestampStore.put((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)-1L));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        this.keyValueStoreFacade.putAll(Arrays.asList(KeyValue.pair((Object)"key1", (Object)"value1"), KeyValue.pair((Object)"key2", (Object)"value2")));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldDeleteAndReturnPlainValue() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.delete((Object)"key")).andReturn(null).andReturn((Object)ValueAndTimestamp.make((Object)"oldValue", (long)42L));
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        Assert.assertNull((Object)this.keyValueStoreFacade.delete((Object)"key"));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.delete((Object)"key"), (Matcher)CoreMatchers.is((Object)"oldValue"));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldForwardFlush() {
        this.mockedKeyValueTimestampStore.flush();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        this.keyValueStoreFacade.flush();
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldForwardClose() {
        this.mockedKeyValueTimestampStore.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        this.keyValueStoreFacade.close();
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldReturnName() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.name(), (Matcher)CoreMatchers.is((Object)"name"));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldReturnIsPersistent() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.persistent()).andReturn((Object)true).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.persistent(), (Matcher)CoreMatchers.is((Object)false));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }

    @Test
    public void shouldReturnIsOpen() {
        EasyMock.expect((Object)this.mockedKeyValueTimestampStore.isOpen()).andReturn((Object)true).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.mockedKeyValueTimestampStore});
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.keyValueStoreFacade.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        EasyMock.verify((Object[])new Object[]{this.mockedKeyValueTimestampStore});
    }
}

