/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.TopologyTestDriver;
import org.junit.Assert;
import org.junit.Test;

public class MockTimeTest {
    @Test
    public void shouldSetStartTime() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assert.assertEquals((long)42L, (long)time.milliseconds());
        Assert.assertEquals((long)42000000L, (long)time.nanoseconds());
    }

    @Test
    public void shouldGetNanosAsMillis() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assert.assertEquals((long)42L, (long)time.hiResClockMs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNegativeSleep() {
        new TopologyTestDriver.MockTime(42L).sleep(-1L);
    }

    @Test
    public void shouldAdvanceTimeOnSleep() {
        TopologyTestDriver.MockTime time = new TopologyTestDriver.MockTime(42L);
        Assert.assertEquals((long)42L, (long)time.milliseconds());
        time.sleep(1L);
        Assert.assertEquals((long)43L, (long)time.milliseconds());
        time.sleep(0L);
        Assert.assertEquals((long)43L, (long)time.milliseconds());
        time.sleep(3L);
        Assert.assertEquals((long)46L, (long)time.milliseconds());
    }
}

