/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.streams.test.OutputVerifier;
import org.junit.Test;

public class OutputVerifierTest {
    private final byte[] key = new byte[0];
    private final byte[] value = new byte[0];
    private final ProducerRecord<byte[], byte[]> producerRecord = new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.value);
    private final ProducerRecord<byte[], byte[]> nullKeyValueRecord = new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, null);

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordForCompareValue() {
        OutputVerifier.compareValue(null, (Object)this.value);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordWithExpectedRecordForCompareValue() {
        OutputVerifier.compareValue((ProducerRecord)null, this.producerRecord);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullExpectedRecordForCompareValue() {
        OutputVerifier.compareValue(this.producerRecord, (ProducerRecord)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordForCompareKeyValue() {
        OutputVerifier.compareKeyValue(null, (Object)this.key, (Object)this.value);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordWithExpectedRecordForCompareKeyValue() {
        OutputVerifier.compareKeyValue(null, this.producerRecord);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullExpectedRecordForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(null, (Object)this.value, (long)0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordWithExpectedRecordForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(null, this.producerRecord);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullExpectedRecordForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(null, (Object)this.key, (Object)this.value, (long)0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullProducerRecordWithExpectedRecordForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(null, this.producerRecord);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullExpectedRecordForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, null);
    }

    @Test
    public void shouldPassIfValueIsEqualForCompareValue() {
        OutputVerifier.compareValue(this.producerRecord, (Object)this.value);
    }

    @Test
    public void shouldPassIfValueIsEqualWithNullForCompareValue() {
        OutputVerifier.compareValue(this.nullKeyValueRecord, (Object)null);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareValue() {
        OutputVerifier.compareValue(this.producerRecord, (Object)this.key);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareValue() {
        OutputVerifier.compareValue(this.producerRecord, (Object)null);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReverseForCompareValue() {
        OutputVerifier.compareValue(this.nullKeyValueRecord, (Object)this.value);
    }

    @Test
    public void shouldPassIfValueIsEqualForCompareValueWithProducerRecord() {
        OutputVerifier.compareValue(this.producerRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(0L), (Object)this.value, (Object)this.value));
    }

    @Test
    public void shouldPassIfValueIsEqualWithNullForCompareValueWithProducerRecord() {
        OutputVerifier.compareValue(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(0L), (Object)this.value, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareValueWithProducerRecord() {
        OutputVerifier.compareValue(this.producerRecord, (ProducerRecord)new ProducerRecord("sameTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.value, (Object)this.key));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareValueWithProducerRecord() {
        OutputVerifier.compareValue(this.producerRecord, (ProducerRecord)new ProducerRecord("sameTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.value, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReverseForCompareValueWithProducerRecord() {
        OutputVerifier.compareValue(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("sameTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.value, (Object)this.value));
    }

    @Test
    public void shouldPassIfKeyAndValueIsEqualForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, (Object)this.key, (Object)this.value);
    }

    @Test
    public void shouldPassIfKeyAndValueIsEqualWithNullForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.nullKeyValueRecord, null, null);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, (Object)this.value, (Object)this.value);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, null, (Object)this.value);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullReversForCompareKeyValue() {
        OutputVerifier.compareKeyValue((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value), (Object)this.key, (Object)this.value);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, (Object)this.key, (Object)this.key);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareKeyValue() {
        OutputVerifier.compareKeyValue(this.producerRecord, (Object)this.key, null);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReversForCompareKeyValue() {
        OutputVerifier.compareKeyValue((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null), (Object)this.key, (Object)this.value);
    }

    @Test
    public void shouldPassIfKeyAndValueIsEqualForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.producerRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(0L), (Object)this.key, (Object)this.value));
    }

    @Test
    public void shouldPassIfKeyAndValueIsEqualWithNullForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(0L), null, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.value, (Object)this.value));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullReversForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value), this.producerRecord);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.key));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReversForCompareKeyValueWithProducerRecord() {
        OutputVerifier.compareKeyValue((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null), this.producerRecord);
    }

    @Test
    public void shouldPassIfValueAndTimestampIsEqualForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldPassIfValueAndTimestampIsEqualWithNullForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.nullKeyValueRecord, null, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (Object)this.key, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, null, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReverseForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.nullKeyValueRecord, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldPassIfValueAndTimestampIsEqualForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(Long.MAX_VALUE), (Object)this.value, (Object)this.value));
    }

    @Test
    public void shouldPassIfValueAndTimestampIsEqualWithNullForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(Long.MAX_VALUE), (Object)this.value, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.key));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReverseForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.value));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfTimestampIsDifferentForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (Object)this.value, (long)0L);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfTimestampDifferentWithNullReverseForCompareValueTimestamp() {
        OutputVerifier.compareValueTimestamp(this.nullKeyValueRecord, null, (long)0L);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfTimestampIsDifferentForCompareValueTimestampWithProducerRecord() {
        OutputVerifier.compareValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(0L), (Object)this.key, (Object)this.value));
    }

    @Test
    public void shouldPassIfKeyAndValueAndTimestampIsEqualForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (Object)this.key, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldPassIfKeyAndValueIsEqualWithNullForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.nullKeyValueRecord, null, null, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (Object)this.value, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, null, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullReversForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value), (Object)this.key, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (Object)this.key, (Object)this.key, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (Object)this.key, null, (long)Long.MAX_VALUE);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReversForCompareKeyValueTimestamp() {
        OutputVerifier.compareKeyValueTimestamp((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null), (Object)this.key, (Object)this.value, (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldPassIfKeyAndValueAndTimestampIsEqualForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.value));
    }

    @Test
    public void shouldPassIfKeyAndValueAndTimestampIsEqualWithNullForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.nullKeyValueRecord, (ProducerRecord)new ProducerRecord("otherTopic", Integer.valueOf(0), Long.valueOf(Long.MAX_VALUE), null, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.value, (Object)this.value));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfKeyIsDifferentWithNullReversForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), null, (Object)this.value), this.producerRecord);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, (Object)this.key));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp(this.producerRecord, (ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailIfValueIsDifferentWithNullReversForCompareKeyValueTimestampWithProducerRecord() {
        OutputVerifier.compareKeyValueTimestamp((ProducerRecord)new ProducerRecord("someTopic", Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE), (Object)this.key, null), this.producerRecord);
    }
}

