/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.internals.ProducedInternal;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.scala.kstream.Produced$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192A\u0001B\u0003\u0001%!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)A\u0006\u0001C\u0001;\ta\u0001K]8ek\u000e,G\rV3ti*\u0011aaB\u0001\bWN$(/Z1n\u0015\tA\u0011\"A\u0003tG\u0006d\u0017M\u0003\u0002\u000b\u0017\u000591\u000f\u001e:fC6\u001c(B\u0001\u0007\u000e\u0003\u0015Y\u0017MZ6b\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Yi\u0011!\u0006\u0006\u0002\u0011%\u0011q#\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005)\u0011\u0001\b;fgR\u001c%/Z1uKB\u0013x\u000eZ;dK\u0012<\u0016\u000e\u001e5TKJ$Wm\u001d\u000b\u0002=A\u0011AcH\u0005\u0003AU\u0011A!\u00168ji\"\u0012!A\t\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\n1!\u00199j\u0015\t9\u0003&A\u0004kkBLG/\u001a:\u000b\u0005%z\u0011!\u00026v]&$\u0018BA\u0016%\u0005\u0011!Vm\u001d;\u0002aQ,7\u000f^\"sK\u0006$X\r\u0015:pIV\u001cW\rZ,ji\"\u001cVM\u001d3fg\u0006sGm\u0015;sK\u0006l\u0007+\u0019:uSRLwN\\3sQ\t\u0019!\u0005")
public class ProducedTest {
    @Test
    public void testCreateProducedWithSerdes() {
        Produced produced = Produced$.MODULE$.with(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ProducedInternal internalProduced = new ProducedInternal(produced);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalProduced.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalProduced.valueSerde().getClass());
    }

    @Test
    public void testCreateProducedWithSerdesAndStreamPartitioner() {
        StreamPartitioner<String, Object> partitioner = new StreamPartitioner<String, Object>(null){

            public Integer partition(String topic, String key, long value, int numPartitions) {
                return Predef$.MODULE$.int2Integer(0);
            }
        };
        Produced produced = Produced$.MODULE$.with((StreamPartitioner)partitioner, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ProducedInternal internalProduced = new ProducedInternal(produced);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalProduced.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalProduced.valueSerde().getClass());
        Assertions.assertEquals((Object)partitioner, (Object)internalProduced.streamPartitioner());
    }
}

