/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KStreamTest;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Repartitioned$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.apache.kafka.streams.scala.utils.TestDriver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001y3AAE\n\u0001A!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C\u0001c!)\u0001\t\u0001C\u0001c!)!\t\u0001C\u0001c!)A\t\u0001C\u0001c!)a\t\u0001C\u0001c!)\u0001\n\u0001C\u0001c!)!\n\u0001C\u0001c!)A\n\u0001C\u0001c!)a\n\u0001C\u0001c!)\u0001\u000b\u0001C\u0001c!)!\u000b\u0001C\u0001c!)A\u000b\u0001C\u0001c!)a\u000b\u0001C\u0001c!)\u0001\f\u0001C\u0001c!)!\f\u0001C\u0001c!)A\f\u0001C\u0001c\tY1j\u0015;sK\u0006lG+Z:u\u0015\t!R#A\u0004lgR\u0014X-Y7\u000b\u0005Y9\u0012!B:dC2\f'B\u0001\r\u001a\u0003\u001d\u0019HO]3b[NT!AG\u000e\u0002\u000b-\fgm[1\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011E\n\t\u0003E\u0011j\u0011a\t\u0006\u0002-%\u0011Qe\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%*\u0012!B;uS2\u001c\u0018BA\u0016)\u0005)!Vm\u001d;Ee&4XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003M\tA\u0005^3ti\u001aKG\u000e^3s%\u0016\u001cwN\u001d3t'\u0006$\u0018n\u001d4zS:<\u0007K]3eS\u000e\fG/\u001a\u000b\u0002eA\u0011!eM\u0005\u0003i\r\u0012A!\u00168ji\"\u0012!A\u000e\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\n1!\u00199j\u0015\tYD(A\u0004kkBLG/\u001a:\u000b\u0005uj\u0012!\u00026v]&$\u0018BA 9\u0005\u0011!Vm\u001d;\u0002OQ,7\u000f\u001e$jYR,'OU3d_J$7OT8u'\u0006$\u0018n\u001d4zS:<\u0007K]3eS\u000e\fG/\u001a\u0015\u0003\u0007Y\n1\u0004^3ti\u001a{'/Z1dQ\u0006\u001bG/[8og>s'+Z2pe\u0012\u001c\bF\u0001\u00037\u0003a!Xm\u001d;QK\u0016\\\u0017i\u0019;j_:\u001cxJ\u001c*fG>\u0014Hm\u001d\u0015\u0003\u000bY\n\u0001\u0003^3tiN+G.Z2u\u001d\u0016<8*Z=)\u0005\u00191\u0014A\u0006;fgR\u0014V\r]1si&$\u0018n\u001c8L'R\u0014X-Y7)\u0005\u001d1\u0014\u0001\u0007;fgRTu.\u001b8D_J\u0014Xm\u0019;msJ+7m\u001c:eg\"\u0012\u0001BN\u0001\u001ei\u0016\u001cH\u000f\u0016:b]N4wN]7D_J\u0014Xm\u0019;msJ+7m\u001c:eg\"\u0012\u0011BN\u0001\"i\u0016\u001cHO\u00127biR\u0013\u0018M\\:g_Jl7i\u001c:sK\u000e$H.\u001f*fG>\u0014Hm\u001d\u0015\u0003\u0015Y\n\u0011\u0006^3ti\u000e{'O]3di2Lh\t\\1u)J\fgn\u001d4pe64\u0016\r\\;fg&s'+Z2pe\u0012\u001c\bFA\u00067\u0003A\"Xm\u001d;D_J\u0014Xm\u0019;ms\u001ac\u0017\r\u001e+sC:\u001chm\u001c:n-\u0006dW/Z:J]J+7m\u001c:eg^KG\u000f[&fs\"\u0012ABN\u0001\u001bi\u0016\u001cHOS8j]R;xnS*ue\u0016\fW\u000eV8UC\ndWm\u001d\u0015\u0003\u001bY\nq\u0003^3tiN+G\u000f^5oO:\u000bW.Z(o\r&dG/\u001a:)\u000591\u0014\u0001\b;fgR\u001cV\r\u001e;j]\u001et\u0015-\\3P]>+H\u000f];u)\u0006\u0014G.\u001a\u0015\u0003\u001fY\nQ\u0003^3tiN+G\u000f^5oO:\u000bW.Z(o\u0015>Lg\u000e\u000b\u0002\u0011m\u0005QB/Z:u'\u0016$H/\u001b8h\u001d\u0006lWm\u00148Ue\u0006t7OZ8s[\"\u0012\u0011C\u000e")
public class KStreamTest
implements TestDriver {
    @Override
    public TopologyTestDriver createTestDriver(StreamsBuilder builder, Instant initialWallClockTime) {
        return TestDriver.createTestDriver$(this, builder, initialWallClockTime);
    }

    @Override
    public Instant createTestDriver$default$2() {
        return TestDriver.createTestDriver$default$2$(this);
    }

    @Override
    public TestDriver.TopologyTestDriverOps TopologyTestDriverOps(TopologyTestDriver inner) {
        return TestDriver.TopologyTestDriverOps$(this, inner);
    }

    @Test
    public void testFilterRecordsSatisfyingPredicate() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).filter((Function2 & Serializable & scala.Serializable)(x$1, value) -> BoxesRunTime.boxToBoolean((boolean)KStreamTest.$anonfun$testFilterRecordsSatisfyingPredicate$1(x$1, value))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)testOutput.readValue());
        testInput.pipeInput((Object)"2", (Object)"value2");
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"3", (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testFilterRecordsNotSatisfyingPredicate() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).filterNot((Function2 & Serializable & scala.Serializable)(x$2, value) -> BoxesRunTime.boxToBoolean((boolean)KStreamTest.$anonfun$testFilterRecordsNotSatisfyingPredicate$1(x$2, value))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)testOutput.readValue());
        testInput.pipeInput((Object)"2", (Object)"value2");
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"3", (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testForeachActionsOnRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        ObjectRef acc = ObjectRef.create((Object)"");
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).foreach((Function2 & Serializable & scala.Serializable)(x$3, value) -> {
            acc.elem = new StringBuilder(0).append((String)acc.elem).append(value).toString();
            return BoxedUnit.UNIT;
        });
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)((String)acc.elem));
        testInput.pipeInput((Object)"2", (Object)"value2");
        Assertions.assertEquals((Object)"value1value2", (Object)((String)acc.elem));
        testDriver.close();
    }

    @Test
    public void testPeekActionsOnRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        ObjectRef acc = ObjectRef.create((Object)"");
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).peek((Function2 & Serializable & scala.Serializable)(x$4, v) -> {
            acc.elem = new StringBuilder(0).append((String)acc.elem).append(v).toString();
            return BoxedUnit.UNIT;
        }).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)((String)acc.elem));
        Assertions.assertEquals((Object)"value1", (Object)testOutput.readValue());
        testInput.pipeInput((Object)"2", (Object)"value2");
        Assertions.assertEquals((Object)"value1value2", (Object)((String)acc.elem));
        Assertions.assertEquals((Object)"value2", (Object)testOutput.readValue());
        testDriver.close();
    }

    @Test
    public void testSelectNewKey() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).selectKey((Function2 & Serializable & scala.Serializable)(x$5, value) -> value).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)testOutput.readKeyValue().key);
        testInput.pipeInput((Object)"1", (Object)"value2");
        Assertions.assertEquals((Object)"value2", (Object)testOutput.readKeyValue().key);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testRepartitionKStream() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String repartitionName = "repartition";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).repartition(Repartitioned$.MODULE$.with(repartitionName, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        KeyValue kv1 = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"1", (Object)kv1.key);
        Assertions.assertEquals((Object)"value1", (Object)kv1.value);
        testInput.pipeInput((Object)"2", (Object)"value2");
        KeyValue kv2 = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"2", (Object)kv2.key);
        Assertions.assertEquals((Object)"value2", (Object)kv2.value);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.producedTopicNames().contains(new StringBuilder(17).append("test-").append(repartitionName).append("-repartition").toString());
        testDriver.close();
    }

    @Test
    public void testJoinCorrectlyRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sourceTopic2 = "source2";
        String sinkTopic = "sink";
        KStream stream1 = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        KStream stream2 = builder.stream(sourceTopic2, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        stream1.join(stream2, (Function2 & Serializable & scala.Serializable)(a, b) -> new StringBuilder(1).append((String)a).append("-").append((String)b).toString(), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofHours(24L)), ImplicitConversions$.MODULE$.streamJoinFromKeyValueOtherSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Instant now = Instant.now();
        TopologyTestDriver testDriver = this.createTestDriver(builder, now);
        TestInputTopic testInput1 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic1, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestInputTopic testInput2 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic2, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput1.pipeInput((Object)"1", (Object)"topic1value1", now);
        testInput2.pipeInput((Object)"1", (Object)"topic2value1", now);
        Assertions.assertEquals((Object)"topic1value1-topic2value1", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testTransformCorrectlyRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).transform(() -> {
            public class Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$1
            implements Transformer<String, String, KeyValue<String, String>> {
                public void init(ProcessorContext context) {
                }

                public KeyValue<String, String> transform(String key, String value) {
                    return new KeyValue((Object)new StringBuilder(12).append(key).append("-transformed").toString(), (Object)new StringBuilder(12).append(value).append("-transformed").toString());
                }

                public void close() {
                }

                public Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$1(KStreamTest $outer) {
                }
            }
            return new Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$1(null);
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Instant now = Instant.now();
        TopologyTestDriver testDriver = this.createTestDriver(builder, now);
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value", now);
        KeyValue result = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"value-transformed", (Object)result.value);
        Assertions.assertEquals((Object)"1-transformed", (Object)result.key);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testFlatTransformCorrectlyRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).flatTransform(() -> {
            public class Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$2
            implements Transformer<String, String, Iterable<KeyValue<String, String>>> {
                public void init(ProcessorContext context) {
                }

                public Iterable<KeyValue<String, String>> transform(String key, String value) {
                    return Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue((Object)new StringBuilder(12).append(key).append("-transformed").toString(), (Object)new StringBuilder(12).append(value).append("-transformed").toString())});
                }

                public void close() {
                }

                public Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$2(KStreamTest $outer) {
                }
            }
            return new Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$2(null);
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Instant now = Instant.now();
        TopologyTestDriver testDriver = this.createTestDriver(builder, now);
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value", now);
        KeyValue result = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"value-transformed", (Object)result.value);
        Assertions.assertEquals((Object)"1-transformed", (Object)result.key);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlyFlatTransformValuesInRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).flatTransformValues((ValueTransformerSupplier)new ValueTransformerSupplier<String, Iterable<String>>(this){
            private final /* synthetic */ KStreamTest $outer;

            public ValueTransformer<String, Iterable<String>> get() {
                public class Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$3
                implements ValueTransformer<String, Iterable<String>> {
                    public void init(ProcessorContext context) {
                    }

                    public Iterable<String> transform(String value) {
                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(value).append("-transformed").toString()});
                    }

                    public void close() {
                    }

                    public Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$3(KStreamTest $outer) {
                    }
                }
                return new Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$3(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Instant now = Instant.now();
        TopologyTestDriver testDriver = this.createTestDriver(builder, now);
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value", now);
        Assertions.assertEquals((Object)"value-transformed", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlyFlatTransformValuesInRecordsWithKey() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).flatTransformValues((ValueTransformerWithKeySupplier)new ValueTransformerWithKeySupplier<String, String, Iterable<String>>(this){
            private final /* synthetic */ KStreamTest $outer;

            public ValueTransformerWithKey<String, String, Iterable<String>> get() {
                public class Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$4
                implements ValueTransformerWithKey<String, String, Iterable<String>> {
                    public void init(ProcessorContext context) {
                    }

                    public Iterable<String> transform(String key, String value) {
                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(13).append(value).append("-transformed-").append(key).toString()});
                    }

                    public void close() {
                    }

                    public Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$4(KStreamTest $outer) {
                    }
                }
                return new Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$4(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Instant now = Instant.now();
        TopologyTestDriver testDriver = this.createTestDriver(builder, now);
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput.pipeInput((Object)"1", (Object)"value", now);
        Assertions.assertEquals((Object)"value-transformed-1", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testJoinTwoKStreamToTables() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sourceTopic2 = "source2";
        String sinkTopic = "sink";
        KTable table1 = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).toTable();
        KTable table2 = builder.stream(sourceTopic2, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).toTable();
        table1.join(table2, (Function2 & Serializable & scala.Serializable)(a, b) -> new StringBuilder(0).append((String)a).append((String)b).toString()).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput1 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic1, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestInputTopic testInput2 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic2, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        testInput1.pipeInput((Object)"1", (Object)"topic1value1");
        testInput2.pipeInput((Object)"1", (Object)"topic2value1");
        Assertions.assertEquals((Object)"topic1value1topic2value1", (Object)testOutput.readValue());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testSettingNameOnFilter() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).filter((Function2 & Serializable & scala.Serializable)(x$6, value) -> BoxesRunTime.boxToBoolean((boolean)KStreamTest.$anonfun$testSettingNameOnFilter$1(x$6, value)), Named.as((String)"my-name")).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyDescription.Node filterNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).head()).nodes()).asScala()).toList().apply(1);
        Assertions.assertEquals((Object)"my-name", (Object)filterNode.name());
    }

    @Test
    public void testSettingNameOnOutputTable() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sinkTopic = "sink";
        builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).toTable(Named.as((String)"my-name")).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyDescription.Node tableNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).head()).nodes()).asScala()).toList().apply(1);
        Assertions.assertEquals((Object)"my-name", (Object)tableNode.name());
    }

    @Test
    public void testSettingNameOnJoin() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source";
        String sourceGTable = "table";
        String sinkTopic = "sink";
        KStream stream = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        GlobalKTable table = builder.globalTable(sourceGTable, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        stream.join(table, Named.as((String)"my-name"), (Function2 & Serializable & scala.Serializable)(a, b) -> new StringBuilder(1).append((String)a).append("-").append((String)b).toString(), (Function2 & Serializable & scala.Serializable)(a, b) -> new StringBuilder(0).append((String)a).append((String)b).toString()).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyDescription.Node joinNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).head()).nodes()).asScala()).toList().apply(1);
        Assertions.assertEquals((Object)"my-name", (Object)joinNode.name());
    }

    @Test
    public void testSettingNameOnTransform() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).transform(() -> {
            public class Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$5
            implements Transformer<String, String, KeyValue<String, String>> {
                public void init(ProcessorContext context) {
                }

                public KeyValue<String, String> transform(String key, String value) {
                    return new KeyValue((Object)new StringBuilder(12).append(key).append("-transformed").toString(), (Object)new StringBuilder(12).append(value).append("-transformed").toString());
                }

                public void close() {
                }

                public Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$5(KStreamTest $outer) {
                }
            }
            return new Org_apache_kafka_streams_scala_kstream_KStreamTest$TestTransformer$5(null);
        }, Named.as((String)"my-name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        TopologyDescription.Node transformNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).head()).nodes()).asScala()).toList().apply(1);
        Assertions.assertEquals((Object)"my-name", (Object)transformNode.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFilterRecordsSatisfyingPredicate$1(String x$1, String value) {
        String string = value;
        String string2 = "value2";
        return string == null || !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testFilterRecordsNotSatisfyingPredicate$1(String x$2, String value) {
        String string = value;
        String string2 = "value2";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSettingNameOnFilter$1(String x$6, String value) {
        String string = value;
        String string2 = "value2";
        return string == null || !string.equals(string2);
    }

    public KStreamTest() {
        TestDriver.$init$(this);
    }
}

