/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.scala.kstream.Consumed$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q2AAB\u0004\u0001)!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)a\u0006\u0001C\u0001?!)\u0001\u0007\u0001C\u0001?!)!\u0007\u0001C\u0001?\ta1i\u001c8tk6,G\rV3ti*\u0011\u0001\"C\u0001\bWN$(/Z1n\u0015\tQ1\"A\u0003tG\u0006d\u0017M\u0003\u0002\r\u001b\u000591\u000f\u001e:fC6\u001c(B\u0001\b\u0010\u0003\u0015Y\u0017MZ6b\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ai\u0011a\u0006\u0006\u0002\u0015%\u0011\u0011d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u00059\u0011A\u0005;fgR\u001c%/Z1uK\u000e{gn];nK\u0012$\u0012\u0001\t\t\u0003-\u0005J!AI\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0011\u0002\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002*U\u00059!.\u001e9ji\u0016\u0014(BA\u0016\u0012\u0003\u0015QWO\\5u\u0013\ticE\u0001\u0003UKN$\u0018A\u000e;fgR\u001c%/Z1uK\u000e{gn];nK\u0012<\u0016\u000e\u001e5US6,7\u000f^1na\u0016CHO]1di>\u0014\u0018I\u001c3SKN,G\u000fU8mS\u000eL\bFA\u0002%\u0003!\"Xm\u001d;De\u0016\fG/Z\"p]N,X.\u001a3XSRDG+[7fgR\fW\u000e]#yiJ\f7\r^8sQ\t!A%A\u0011uKN$8I]3bi\u0016\u001cuN\\:v[\u0016$w+\u001b;i%\u0016\u001cX\r\u001e)pY&\u001c\u0017\u0010\u000b\u0002\u0006I\u0001")
public class ConsumedTest {
    @Test
    public void testCreateConsumed() {
        Consumed consumed = Consumed$.MODULE$.with(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ConsumedInternal internalConsumed = new ConsumedInternal(consumed);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalConsumed.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalConsumed.valueSerde().getClass());
    }

    @Test
    public void testCreateConsumedWithTimestampExtractorAndResetPolicy() {
        FailOnInvalidTimestamp timestampExtractor = new FailOnInvalidTimestamp();
        Topology.AutoOffsetReset resetPolicy = Topology.AutoOffsetReset.LATEST;
        Consumed consumed = Consumed$.MODULE$.with((TimestampExtractor)timestampExtractor, resetPolicy, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ConsumedInternal internalConsumed = new ConsumedInternal(consumed);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalConsumed.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalConsumed.valueSerde().getClass());
        Assertions.assertEquals((Object)timestampExtractor, (Object)internalConsumed.timestampExtractor());
        Assertions.assertEquals((Object)resetPolicy, (Object)internalConsumed.offsetResetPolicy());
    }

    @Test
    public void testCreateConsumedWithTimestampExtractor() {
        FailOnInvalidTimestamp timestampExtractor = new FailOnInvalidTimestamp();
        Consumed consumed = Consumed$.MODULE$.with((TimestampExtractor)timestampExtractor, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ConsumedInternal internalConsumed = new ConsumedInternal(consumed);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalConsumed.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalConsumed.valueSerde().getClass());
        Assertions.assertEquals((Object)timestampExtractor, (Object)internalConsumed.timestampExtractor());
    }

    @Test
    public void testCreateConsumedWithResetPolicy() {
        Topology.AutoOffsetReset resetPolicy = Topology.AutoOffsetReset.LATEST;
        Consumed consumed = Consumed$.MODULE$.with(resetPolicy, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        ConsumedInternal internalConsumed = new ConsumedInternal(consumed);
        Assertions.assertEquals(Serdes$.MODULE$.stringSerde().getClass(), internalConsumed.keySerde().getClass());
        Assertions.assertEquals(Serdes$.MODULE$.longSerde().getClass(), internalConsumed.valueSerde().getClass());
        Assertions.assertEquals((Object)resetPolicy, (Object)internalConsumed.offsetResetPolicy());
    }
}

