/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.kstream;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.apache.kafka.streams.scala.utils.TestDriver;
import org.apache.kafka.streams.test.TestRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001a3A\u0001E\t\u0001=!)!\u0006\u0001C\u0001W!)a\u0006\u0001C\u0001_!)a\b\u0001C\u0001_!)\u0001\t\u0001C\u0001_!)!\t\u0001C\u0001_!)A\t\u0001C\u0001_!)a\t\u0001C\u0001_!)\u0001\n\u0001C\u0001_!)!\n\u0001C\u0001_!)A\n\u0001C\u0001_!)a\n\u0001C\u0001_!)\u0001\u000b\u0001C\u0001_!)!\u000b\u0001C\u0001_!)A\u000b\u0001C\u0001_!)a\u000b\u0001C\u0001_\tQ1\nV1cY\u0016$Vm\u001d;\u000b\u0005I\u0019\u0012aB6tiJ,\u0017-\u001c\u0006\u0003)U\tQa]2bY\u0006T!AF\f\u0002\u000fM$(/Z1ng*\u0011\u0001$G\u0001\u0006W\u000647.\u0019\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yB\u0005\u0005\u0002!E5\t\u0011EC\u0001\u0015\u0013\t\u0019\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003K!j\u0011A\n\u0006\u0003OM\tQ!\u001e;jYNL!!\u000b\u0014\u0003\u0015Q+7\u000f\u001e#sSZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u0002#\u0005!C/Z:u\r&dG/\u001a:SK\u000e|'\u000fZ:TCRL7OZ=j]\u001e\u0004&/\u001a3jG\u0006$X\rF\u00011!\t\u0001\u0013'\u0003\u00023C\t!QK\\5uQ\t\u0011A\u0007\u0005\u00026y5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wm\tQA[;oSRL!!\u0010\u001c\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHOR5mi\u0016\u0014(+Z2pe\u0012\u001chj\u001c;TCRL7OZ=j]\u001e\u0004&/\u001a3jG\u0006$X\r\u000b\u0002\u0004i\u0005AB/Z:u\u0015>LgnQ8se\u0016\u001cG\u000f\\=SK\u000e|'\u000fZ:)\u0005\u0011!\u0014!\n;fgRTu.\u001b8D_J\u0014Xm\u0019;msJ+7m\u001c:eg\u0006sGm\u0015;bi\u0016\u001cFo\u001c:fQ\t)A'A\u001duKN$8i\u001c:sK\u000e$H._*vaB\u0014Xm]:SKN,H\u000e^:Vg&twmU;qaJ,7o]3e+:$\u0018\u000e\u001c+j[\u0016d\u0015.\\5uQ\t1A'\u0001\u0018uKN$8i\u001c:sK\u000e$H._$s_V\u0004()_&fs^Kg\u000eZ8xK\u0012\u0014\u0015p\u00157jI&twmV5oI><\bFA\u00045\u0003\u0019#Xm\u001d;D_J\u0014Xm\u0019;msN+\b\u000f\u001d:fgN\u0014Vm];miN,6/\u001b8h'V\u0004\bO]3tg\u0016$WK\u001c;jY^Kg\u000eZ8x\u00072|7/Z:Cs^Kg\u000eZ8xK\u0012D#\u0001\u0003\u001b\u0002\u000bR,7\u000f^\"peJ,7\r\u001e7z'V\u0004\bO]3tgJ+7/\u001e7ugV\u001b\u0018N\\4TkB\u0004(/Z:tK\u0012,f\u000e^5m/&tGm\\<DY>\u001cXm\u001d\"z'\u0016\u001c8/[8oQ\tIA'A#uKN$8i\u001c:sK\u000e$H._*vaB\u0014Xm]:SKN,H\u000e^:Vg&twmU;qaJ,7o]3e+:$\u0018\u000e\u001c+j[\u0016d\u0015.\u001c;Cs:{gnV5oI><X\r\u001a\u0015\u0003\u0015Q\n\u0001\u0005^3tiN+G\u000f^5oO:\u000bW.Z(o\r&dG/\u001a:Qe>\u001cWm]:pe\"\u00121\u0002N\u0001 i\u0016\u001cHoU3ui&twMT1nK>s7i\\;oiB\u0013xnY3tg>\u0014\bF\u0001\u00075\u0003y!Xm\u001d;TKR$\u0018N\\4OC6,wJ\u001c&pS:\u0004&o\\2fgN|'\u000f\u000b\u0002\u000ei\u0005aC/Z:u\u001b\u0006\u0004h+\u00197vKN<\u0016\u000e\u001e5WC2,X-T1qa\u0016\u0014x+\u001b;i\u001b\u0006$XM]5bY&TX\r\u001a\u0015\u0003\u001dQ\na\u0007^3ti6\u000b\u0007OV1mk\u0016\u001cx+\u001b;i-\u0006dW/Z'baB,'oV5uQ.+\u00170\u00118e/&$\b.T1uKJL\u0017\r\\5{K\u0012D#a\u0004\u001b")
public class KTableTest
implements TestDriver {
    @Override
    public TopologyTestDriver createTestDriver(StreamsBuilder builder, Instant initialWallClockTime) {
        return TestDriver.createTestDriver$(this, builder, initialWallClockTime);
    }

    @Override
    public Instant createTestDriver$default$2() {
        return TestDriver.createTestDriver$default$2$(this);
    }

    @Override
    public TestDriver.TopologyTestDriverOps TopologyTestDriverOps(TopologyTestDriver inner) {
        return TestDriver.TopologyTestDriverOps$(this, inner);
    }

    @Test
    public void testFilterRecordsSatisfyingPredicate() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$1) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).filter((Function2 & Serializable & scala.Serializable)(key, value) -> BoxesRunTime.boxToBoolean((boolean)KTableTest.$anonfun$testFilterRecordsSatisfyingPredicate$2(key, BoxesRunTime.unboxToLong((Object)value)))).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"a", (Object)"passes filter : add new row to table");
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"a", (Object)record.key);
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        testInput.pipeInput((Object)"a", (Object)"fails filter : remove existing row from table");
        KeyValue record2 = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"a", (Object)record2.key);
        Assertions.assertNull((Object)record2.value);
        testInput.pipeInput((Object)"b", (Object)"fails filter : no output");
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testFilterRecordsNotSatisfyingPredicate() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$2) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).filterNot((Function2 & Serializable & scala.Serializable)(x$3, value) -> BoxesRunTime.boxToBoolean((boolean)KTableTest.$anonfun$testFilterRecordsNotSatisfyingPredicate$2(x$3, BoxesRunTime.unboxToLong((Object)value)))).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"1", (Object)"value1");
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"1", (Object)record.key);
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        testInput.pipeInput((Object)"1", (Object)"value2");
        KeyValue record2 = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"1", (Object)record2.key);
        Assertions.assertNull((Object)record2.value);
        testInput.pipeInput((Object)"2", (Object)"value1");
        KeyValue record3 = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"2", (Object)record3.key);
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)record3.value));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testJoinCorrectlyRecords() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sourceTopic2 = "source2";
        String sinkTopic = "sink";
        KTable table1 = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$4) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        KTable table2 = builder.stream(sourceTopic2, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$5) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        table1.join(table2, (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(a, b) -> a + b).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput1 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic1, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestInputTopic testInput2 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic2, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput1.pipeInput((Object)"1", (Object)"topic1value1");
        testInput2.pipeInput((Object)"1", (Object)"topic2value1");
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToLong((Object)testOutput.readValue()));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testJoinCorrectlyRecordsAndStateStore() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sourceTopic2 = "source2";
        String sinkTopic = "sink";
        String stateStore = "store";
        Materialized materialized = Materialized$.MODULE$.as(stateStore, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        KTable table1 = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$6) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        KTable table2 = builder.stream(sourceTopic2, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$7) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        table1.join(table2, materialized, (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(a, b) -> a + b).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput1 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic1, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestInputTopic testInput2 = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic2, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput1.pipeInput((Object)"1", (Object)"topic1value1");
        testInput2.pipeInput((Object)"1", (Object)"topic2value1");
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToLong((Object)testOutput.readValue()));
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToLong((Object)testDriver.getKeyValueStore(stateStore).get((Object)"1")));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlySuppressResultsUsingSuppressedUntilTimeLimit() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        TimeWindows window = TimeWindows.ofSizeAndGrace((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofHours(24L));
        Suppressed suppression = Suppressed.untilTimeLimit((Duration)Duration.ofSeconds(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).windowedBy((Windows)window).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).suppress(suppression).toStream((Function2 & Serializable & scala.Serializable)(k, x$8) -> KTableTest.$anonfun$testCorrectlySuppressResultsUsingSuppressedUntilTimeLimit$1(k, BoxesRunTime.unboxToLong((Object)x$8))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"1", (Object)"value1", 0L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value2", 1L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value1", 1001L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value2", 1999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value3", 999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value3", 2001L);
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"0:1000:1", (Object)record.key);
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlyGroupByKeyWindowedBySlidingWindow() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        SlidingWindows window = SlidingWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(1000L));
        Suppressed suppression = Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).windowedBy(window).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).suppress(suppression).toStream((Function2 & Serializable & scala.Serializable)(k, x$9) -> KTableTest.$anonfun$testCorrectlyGroupByKeyWindowedBySlidingWindow$1(k, BoxesRunTime.unboxToLong((Object)x$9))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"1", (Object)"value1", 0L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value3", 5001L);
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"0:1000:1", (Object)record.key);
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesByWindowed() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        TimeWindows window = TimeWindows.ofSizeAndGrace((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L));
        Suppressed suppression = Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).windowedBy((Windows)window).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).suppress(suppression).toStream((Function2 & Serializable & scala.Serializable)(k, x$10) -> KTableTest.$anonfun$testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesByWindowed$1(k, BoxesRunTime.unboxToLong((Object)x$10))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"1", (Object)"value1", 0L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value2", 1L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value1", 1001L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value2", 1999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value3", 999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value3", 2001L);
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"0:1000:1", (Object)record.key);
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesBySession() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        SessionWindows window = SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(5L), (Duration)Duration.ofMillis(10L));
        Suppressed suppression = Suppressed.untilWindowCloses((Suppressed.StrictBufferConfig)Suppressed.BufferConfig.unbounded());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).windowedBy(window).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).suppress(suppression).toStream((Function2 & Serializable & scala.Serializable)(k, x$11) -> KTableTest.$anonfun$testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesBySession$1(k, BoxesRunTime.unboxToLong((Object)x$11))).to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"k1", (Object)"v1", 0L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 1L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 8L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 2L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 13L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 10L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"k1", (Object)"v1", 30L);
        testInput.pipeInput((Object)"k1", (Object)"v1", 3L);
        TestRecord r1 = testOutput.readRecord();
        Assertions.assertEquals((Object)"0:2:k1", (Object)r1.key());
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)r1.value()));
        Assertions.assertEquals((long)2L, (Long)r1.timestamp());
        TestRecord r2 = testOutput.readRecord();
        Assertions.assertEquals((Object)"8:13:k1", (Object)r2.key());
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)r2.value()));
        Assertions.assertEquals((long)13L, (Long)r2.timestamp());
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testCorrectlySuppressResultsUsingSuppressedUntilTimeLimtByNonWindowed() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        Suppressed suppression = Suppressed.untilTimeLimit((Duration)Duration.ofSeconds(2L), (Suppressed.BufferConfig)Suppressed.BufferConfig.unbounded());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).suppress(suppression).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        TestInputTopic testInput = this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde());
        TestOutputTopic testOutput = this.TopologyTestDriverOps(testDriver).createOutput(sinkTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        testInput.pipeInput((Object)"1", (Object)"value1", 0L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value2", 1L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value1", 1001L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value2", 1999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"1", (Object)"value3", 999L);
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testInput.pipeInput((Object)"2", (Object)"value3", 2001L);
        KeyValue record = testOutput.readKeyValue();
        Assertions.assertEquals((Object)"1", (Object)record.key);
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)record.value));
        Assertions.assertTrue((boolean)testOutput.isEmpty());
        testDriver.close();
    }

    @Test
    public void testSettingNameOnFilterProcessor() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$12) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).filter((Function2 & Serializable & scala.Serializable)(key, value) -> BoxesRunTime.boxToBoolean((boolean)KTableTest.$anonfun$testSettingNameOnFilterProcessor$2(key, BoxesRunTime.unboxToLong((Object)value))), Named.as((String)"my-name")).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyDescription.Node filterNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).toList().apply(1)).nodes()).asScala()).toList().apply(3);
        Assertions.assertEquals((Object)"my-name", (Object)filterNode.name());
    }

    @Test
    public void testSettingNameOnCountProcessor() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String sinkTopic = "sink";
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$13) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(Named.as((String)"my-name"), ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyDescription.Node countNode = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).toList().apply(1)).nodes()).asScala()).toList().apply(1);
        Assertions.assertEquals((Object)"my-name", (Object)countNode.name());
    }

    @Test
    public void testSettingNameOnJoinProcessor() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic1 = "source1";
        String sourceTopic2 = "source2";
        String sinkTopic = "sink";
        KTable table1 = builder.stream(sourceTopic1, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$14) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        KTable table2 = builder.stream(sourceTopic2, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).groupBy((Function2 & Serializable & scala.Serializable)(key, x$15) -> key, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        table1.join(table2, Named.as((String)"my-name"), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(a, b) -> a + b).toStream().to(sinkTopic, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        TopologyDescription.Node joinNodeLeft = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).toList().apply(1)).nodes()).asScala()).toList().apply(6);
        TopologyDescription.Node joinNodeRight = (TopologyDescription.Node)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((TopologyDescription.Subtopology)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(builder.build().describe().subtopologies()).asScala()).toList().apply(1)).nodes()).asScala()).toList().apply(7);
        Assertions.assertTrue((boolean)joinNodeLeft.name().contains("my-name"));
        Assertions.assertTrue((boolean)joinNodeRight.name().contains("my-name"));
    }

    @Test
    public void testMapValuesWithValueMapperWithMaterialized() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String stateStore = "store";
        Materialized materialized = Materialized$.MODULE$.as(stateStore, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).toTable().mapValues((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToLong((long)value.length()), materialized);
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()).pipeInput((Object)"1", (Object)"topic1value1");
        Assertions.assertEquals((long)12L, (long)BoxesRunTime.unboxToLong((Object)testDriver.getKeyValueStore(stateStore).get((Object)"1")));
        testDriver.close();
    }

    @Test
    public void testMapValuesWithValueMapperWithKeyAndWithMaterialized() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        String sourceTopic = "source";
        String stateStore = "store";
        Materialized materialized = Materialized$.MODULE$.as(stateStore, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde());
        builder.stream(sourceTopic, ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).toTable().mapValues((Function2 & Serializable & scala.Serializable)(key, value) -> BoxesRunTime.boxToLong((long)KTableTest.$anonfun$testMapValuesWithValueMapperWithKeyAndWithMaterialized$1(key, value)), materialized);
        TopologyTestDriver testDriver = this.createTestDriver(builder, this.createTestDriver$default$2());
        this.TopologyTestDriverOps(testDriver).createInput(sourceTopic, Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()).pipeInput((Object)"1", (Object)"topic1value1");
        Assertions.assertEquals((long)13L, (long)BoxesRunTime.unboxToLong((Object)testDriver.getKeyValueStore(stateStore).get((Object)"1")));
        testDriver.close();
    }

    public static final /* synthetic */ boolean $anonfun$testFilterRecordsSatisfyingPredicate$2(String key, long value) {
        return key.equals("a") && value == 1L;
    }

    public static final /* synthetic */ boolean $anonfun$testFilterRecordsNotSatisfyingPredicate$2(String x$3, long value) {
        return value > 1L;
    }

    public static final /* synthetic */ String $anonfun$testCorrectlySuppressResultsUsingSuppressedUntilTimeLimit$1(Windowed k, long x$8) {
        return new StringBuilder(2).append(k.window().start()).append(":").append(k.window().end()).append(":").append(k.key()).toString();
    }

    public static final /* synthetic */ String $anonfun$testCorrectlyGroupByKeyWindowedBySlidingWindow$1(Windowed k, long x$9) {
        return new StringBuilder(2).append(k.window().start()).append(":").append(k.window().end()).append(":").append(k.key()).toString();
    }

    public static final /* synthetic */ String $anonfun$testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesByWindowed$1(Windowed k, long x$10) {
        return new StringBuilder(2).append(k.window().start()).append(":").append(k.window().end()).append(":").append(k.key()).toString();
    }

    public static final /* synthetic */ String $anonfun$testCorrectlySuppressResultsUsingSuppressedUntilWindowClosesBySession$1(Windowed k, long x$11) {
        return new StringBuilder(2).append(k.window().start()).append(":").append(k.window().end()).append(":").append(k.key()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testSettingNameOnFilterProcessor$2(String key, long value) {
        return key.equals("a") && value == 1L;
    }

    public static final /* synthetic */ long $anonfun$testMapValuesWithValueMapperWithKeyAndWithMaterialized$1(String key, String value) {
        return (long)key.length() + (long)value.length();
    }

    public KTableTest() {
        TestDriver.$init$(this);
    }
}

