/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.WordCountTestData;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.streams.scala.serialization.Serdes$;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\u000b\u0016\u0001\u0001BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\u0006q\u0001!\tA\f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0002B\u0011\u0019)\u0005\u0001)A\u0007\u0005\"9a\t\u0001b\u0001\n\u00039\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ra\u0003\u0001\u0015!\u0003S\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015!\u0007\u0001\"\u0001]\u0011\u0015I\u0007\u0001\"\u0001]\u0011\u0015Y\u0007\u0001\"\u0001]\u0011\u00159\b\u0001\"\u0003y\u0011\u0019\t\u0019\u0001\u0001C\u0005q\"1\u0011Q\u0001\u0001\u0005\naDq!a\u0002\u0001\t\u0013\tIAA\u0007X_J$7i\\;oiR+7\u000f\u001e\u0006\u0003-]\tQa]2bY\u0006T!\u0001G\r\u0002\u000fM$(/Z1ng*\u0011!dG\u0001\u0006W\u000647.\u0019\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tc\u0005\u0005\u0002#I5\t1EC\u0001\u0017\u0013\t)3E\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011!F\u0005\u0003SU\u0011\u0011cV8sI\u000e{WO\u001c;UKN$H)\u0019;b\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002(\u0001\u0005q\u0001O]5wCR,7\t\\;ti\u0016\u0014X#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014!B;uS2\u001c(B\u0001\u001b\u0018\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005Y\n$\u0001F#nE\u0016$G-\u001a3LC\u001a\\\u0017m\u00117vgR,'/A\bqe&4\u0018\r^3DYV\u001cH/\u001a:!\u0003\u001d\u0019G.^:uKJD#\u0001\u0002\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uj\u0012!\u00026v]&$\u0018BA =\u0005\u0011\u0011V\u000f\\3\u0002\u0017\u0005d\u0017n\u001a8fIRKW.Z\u000b\u0002\u0005B\u0011!eQ\u0005\u0003\t\u000e\u0012A\u0001T8oO\u0006a\u0011\r\\5h]\u0016$G+[7fA\u0005AQn\\2l)&lW-F\u0001I!\tIU*D\u0001K\u0015\t\u00114J\u0003\u0002M3\u000511m\\7n_:L!A\u0014&\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u000fQ4u\u000e\u001c3feV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002Vy\u0005)!/\u001e7fg&\u0011q\u000b\u0016\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\u0006AAOR8mI\u0016\u0014\b%\u0001\u0006uKN$hi\u001c7eKJD#a\u0003\u001e\u0002#M$\u0018M\u001d;LC\u001a\\\u0017m\u00117vgR,'\u000fF\u0001^!\t\u0011c,\u0003\u0002`G\t!QK\\5uQ\ta\u0011\r\u0005\u0002<E&\u00111\r\u0010\u0002\u0007\u0005\u00164wN]3\u0002)Q,7\u000f^*i_VdGmQ8v]R<vN\u001d3tQ\tia\r\u0005\u0002<O&\u0011\u0001\u000e\u0010\u0002\u0005)\u0016\u001cH/\u0001\u0011uKN$8\u000b[8vY\u0012\u001cu.\u001e8u/>\u0014Hm]'bi\u0016\u0014\u0018.\u00197ju\u0016$\u0007F\u0001\bg\u0003a!Xm\u001d;TQ>,H\u000eZ\"pk:$xk\u001c:eg*\u000bg/\u0019\u0015\u0003\u001f\u0019DCa\u00048ukB\u0011qN]\u0007\u0002a*\u0011\u0011oI\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005\u0019qwn^1s]\u0006)a/\u00197vK\u0006\na/A\bdCRlD-\u001a9sK\u000e\fG/[8o\u0003]9W\r^*ue\u0016\fWn]\"p]\u001aLw-\u001e:bi&|g\u000eF\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003vi&d'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(A\u0003)s_B,'\u000f^5fg\u0006\tr-\u001a;Qe>$WoY3s\u0007>tg-[4\u0002#\u001d,GoQ8ogVlWM]\"p]\u001aLw-A\bqe>$WoY3O\u0007>t7/^7f)\u0019\tY!a\f\u00024A)!0!\u0004\u0002\u0012%\u0019\u0011qB>\u0003\t1K7\u000f\u001e\t\b\u0003'\t)\"!\u0007C\u001b\u00059\u0012bAA\f/\tA1*Z=WC2,X\r\u0005\u0003\u0002\u001c\u0005%b\u0002BA\u000f\u0003K\u00012!a\b$\u001b\t\t\tCC\u0002\u0002$}\ta\u0001\u0010:p_Rt\u0014bAA\u0014G\u00051\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\n$\u0011\u001d\t\td\u0005a\u0001\u00033\t!\"\u001b8qkR$v\u000e]5d\u0011\u001d\t)d\u0005a\u0001\u00033\t1b\\;uaV$Hk\u001c9jG\"2\u0001!!\u000fu\u0003\u0013\u0002B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0006dCR,wm\u001c:jKNT1!a\u0011=\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0013\u0011\t9%!\u0010\u0003\u0011\r\u000bG/Z4pefd#!a\u0013$\u0005\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0013$\u0001\u0003uKN$\u0018\u0002BA,\u0003#\u0012q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e")
public class WordCountTest
implements WordCountTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String inputTopic;
    private final String outputTopic;
    private final String inputTopicJ;
    private final String outputTopicJ;
    private final List<String> inputValues;
    private final List<KeyValue<String, Object>> expectedWordCounts;

    @Override
    public String inputTopic() {
        return this.inputTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String inputTopicJ() {
        return this.inputTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public List<String> inputValues() {
        return this.inputValues;
    }

    @Override
    public List<KeyValue<String, Object>> expectedWordCounts() {
        return this.expectedWordCounts;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopic_$eq(String x$1) {
        this.inputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopicJ_$eq(String x$1) {
        this.inputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputValues_$eq(List<String> x$1) {
        this.inputValues = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$expectedWordCounts_$eq(List<KeyValue<String, Object>> x$1) {
        this.expectedWordCounts = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.inputTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.inputTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @Test
    public void testShouldCountWords() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(x$1, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsMaterialized() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(k, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.stringSerde())).count(Materialized$.MODULE$.as("word-count", Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde())).toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.stringSerde(), Serdes$.MODULE$.longSerde()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsJava() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        streamsConfiguration.put("default.key.serde", Serdes$.MODULE$.stringSerde().getClass().getName());
        streamsConfiguration.put("default.value.serde", Serdes$.MODULE$.stringSerde().getClass().getName());
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopicJ());
        Pattern pattern = Pattern.compile("\\W+", 256);
        textLines.flatMapValues(line -> (Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern.split(line.toLowerCase()))).toIterable()).asJava()).groupBy((x$6, v) -> v).count().toStream().to(this.outputTopicJ(), Produced.with((Serde)Serdes$.MODULE$.stringSerde(), (Serde)Serdes$.MODULE$.javaLongSerde()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopicJ(), this.outputTopicJ());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.key, (Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "wordcount-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "10000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "wordcount-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    private java.util.List<KeyValue<String, Object>> produceNConsume(String inputTopic, String outputTopic) {
        Properties linesProducerConfig = this.getProducerConfig();
        IntegrationTestUtils.produceValuesSynchronously((String)inputTopic, (Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.inputValues()).asJava()), (Properties)linesProducerConfig, (Time)this.mockTime());
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived((Properties)this.getConsumerConfig(), (String)outputTopic, (int)this.expectedWordCounts().size());
    }

    public WordCountTest() {
        WordCountTestData.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

