/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.scala.utils.StreamToTableJoinTestData;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\n\u0015\u0001\u0005BQa\u000b\u0001\u0005\u00021BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00048\u0001\u0001\u0006I\u0001\r\u0005\u0006q\u0001!\ta\f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0002B\u0011\u0019)\u0005\u0001)A\u0007\u0005\"9a\t\u0001b\u0001\n\u00039\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ra\u0003\u0001\u0015!\u0003S\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015q\u0007\u0001\"\u0003f\u0011\u0015y\u0007\u0001\"\u0003f\u0011\u0015\u0001\b\u0001\"\u0003f\u0011\u0015\t\b\u0001\"\u0001s\u0011%\t\t\u0003AI\u0001\n\u0003\t\u0019CA\u0015TiJ,\u0017-\u001c+p)\u0006\u0014G.\u001a&pS:\u001c6-\u00197b\u0013:$Xm\u001a:bi&|g\u000eV3ti\n\u000b7/\u001a\u0006\u0003+Y\tQ!\u001e;jYNT!a\u0006\r\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005eQ\u0012aB:ue\u0016\fWn\u001d\u0006\u00037q\tQa[1gW\u0006T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#OA\u00111%J\u0007\u0002I)\tq#\u0003\u0002'I\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0015\u000e\u0003QI!A\u000b\u000b\u00033M#(/Z1n)>$\u0016M\u00197f\u0015>Lg\u000eV3ti\u0012\u000bG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"\u0001\u000b\u0001\u0002\u001dA\u0014\u0018N^1uK\u000ecWo\u001d;feV\t\u0001\u0007\u0005\u00022k5\t!G\u0003\u0002\u0016g)\u0011A\u0007G\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00027e\t!R)\u001c2fI\u0012,GmS1gW\u0006\u001cE.^:uKJ\fq\u0002\u001d:jm\u0006$Xm\u00117vgR,'\u000fI\u0001\bG2,8\u000f^3sQ\t!!\b\u0005\u0002<}5\tAH\u0003\u0002>=\u0005)!.\u001e8ji&\u0011q\b\u0010\u0002\u0005%VdW-A\u0006bY&<g.\u001a3US6,W#\u0001\"\u0011\u0005\r\u001a\u0015B\u0001#%\u0005\u0011auN\\4\u0002\u0019\u0005d\u0017n\u001a8fIRKW.\u001a\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012\u0001\u0013\t\u0003\u00136k\u0011A\u0013\u0006\u0003+-S!\u0001\u0014\u000e\u0002\r\r|W.\\8o\u0013\tq%J\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0004u\r>dG-\u001a:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u001f\u0002\u000bI,H.Z:\n\u0005]#&a\u0004+f[B|'/\u0019:z\r>dG-\u001a:\u0002\u0011Q4u\u000e\u001c3fe\u0002\n!\u0002^3ti\u001a{G\u000eZ3sQ\tY!(A\tti\u0006\u0014HoS1gW\u0006\u001cE.^:uKJ$\u0012!\u0018\t\u0003GyK!a\u0018\u0013\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0019\u0005\u0004\"a\u000f2\n\u0005\rd$A\u0002\"fM>\u0014X-A\fhKR\u001cFO]3b[N\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\ta\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!Q\u000f^5m\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u000fhKR,6/\u001a:SK\u001eLwN\\:Qe>$WoY3s\u0007>tg-[4\u00027\u001d,G/V:fe\u000ec\u0017nY6t!J|G-^2fe\u000e{gNZ5h\u0003E9W\r^\"p]N,X.\u001a:D_:4\u0017nZ\u0001\u0010aJ|G-^2f\u001d\u000e{gn];nKRI1/a\u0003\u0002\u0010\u0005M\u0011q\u0003\t\u0004OR4\u0018BA;i\u0005\u0011a\u0015n\u001d;\u0011\t]D(PQ\u0007\u00021%\u0011\u0011\u0010\u0007\u0002\t\u0017\u0016Lh+\u00197vKB\u001910!\u0002\u000f\u0007q\f\t\u0001\u0005\u0002~I5\taP\u0003\u0002\u0000A\u00051AH]8pizJ1!a\u0001%\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0005\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0001\u0013\t\r\u00055\u0011\u00031\u0001{\u0003=)8/\u001a:DY&\u001c7n\u001d+pa&\u001c\u0007BBA\t#\u0001\u0007!0\u0001\tvg\u0016\u0014(+Z4j_:\u001cHk\u001c9jG\"1\u0011QC\tA\u0002i\f1b\\;uaV$Hk\u001c9jG\"I\u0011\u0011D\t\u0011\u0002\u0003\u0007\u00111D\u0001\u0018o\u0006LG\u000fV5mYJ+7m\u001c:egJ+7-Z5wK\u0012\u00042aIA\u000f\u0013\r\ty\u0002\n\u0002\b\u0005>|G.Z1o\u0003e\u0001(o\u001c3vG\u0016t5i\u001c8tk6,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0015\"\u0006BA\u000e\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g!\u0013AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\b\u0001\u0005m\u00121JA'!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n!bY1uK\u001e|'/[3t\u0015\r\t)\u0005P\u0001\rKb\u0004XM]5nK:$\u0018\r\\\u0005\u0005\u0003\u0013\nyD\u0001\u0005DCR,wm\u001c:z\u0003\u00151\u0018\r\\;fY\t\tye\t\u0002\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002Xi\tA\u0001^3ti&!\u00111LA+\u0005=Ie\u000e^3he\u0006$\u0018n\u001c8UKN$\b")
public class StreamToTableJoinScalaIntegrationTestBase
implements StreamToTableJoinTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String brokers;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final String outputTopic;
    private final String userClicksTopicJ;
    private final String userRegionsTopicJ;
    private final String outputTopicJ;
    private final Seq<KeyValue<String, Object>> userClicks;
    private final Seq<KeyValue<String, String>> userRegions;
    private final Seq<KeyValue<String, Object>> expectedClicksPerRegion;

    @Override
    public String brokers() {
        return this.brokers;
    }

    @Override
    public String userClicksTopic() {
        return this.userClicksTopic;
    }

    @Override
    public String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String userClicksTopicJ() {
        return this.userClicksTopicJ;
    }

    @Override
    public String userRegionsTopicJ() {
        return this.userRegionsTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public Seq<KeyValue<String, Object>> userClicks() {
        return this.userClicks;
    }

    @Override
    public Seq<KeyValue<String, String>> userRegions() {
        return this.userRegions;
    }

    @Override
    public Seq<KeyValue<String, Object>> expectedClicksPerRegion() {
        return this.expectedClicksPerRegion;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$brokers_$eq(String x$1) {
        this.brokers = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopic_$eq(String x$1) {
        this.userClicksTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopic_$eq(String x$1) {
        this.userRegionsTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopicJ_$eq(String x$1) {
        this.userClicksTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopicJ_$eq(String x$1) {
        this.userRegionsTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicks_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.userClicks = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegions_$eq(Seq<KeyValue<String, String>> x$1) {
        this.userRegions = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$expectedClicksPerRegion_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.expectedClicksPerRegion = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.userClicksTopic());
        this.cluster().createTopic(this.userRegionsTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.userClicksTopicJ());
        this.cluster().createTopic(this.userRegionsTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    /*
     * WARNING - void declaration
     */
    public Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "stream-table-join-scala-integration-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "1000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserRegionsProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserClicksProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", LongSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "join-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    public List<KeyValue<String, Object>> produceNConsume(String userClicksTopic, String userRegionsTopic, String outputTopic, boolean waitTillRecordsReceived) {
        Properties userRegionsProducerConfig = this.getUserRegionsProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userRegionsTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userRegions()).asJava()), (Properties)userRegionsProducerConfig, (Time)this.mockTime(), (boolean)false);
        Properties userClicksProducerConfig = this.getUserClicksProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userClicksTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userClicks()).asJava()), (Properties)userClicksProducerConfig, (Time)this.mockTime(), (boolean)false);
        if (waitTillRecordsReceived) {
            return IntegrationTestUtils.waitUntilFinalKeyValueRecordsReceived((Properties)this.getConsumerConfig(), (String)outputTopic, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.expectedClicksPerRegion()).asJava()));
        }
        return Collections.emptyList();
    }

    public boolean produceNConsume$default$4() {
        return true;
    }

    public StreamToTableJoinScalaIntegrationTestBase() {
        StreamToTableJoinTestData.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

