/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.Serdes$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.WordCountTestData;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\u000b\u0016\u0001\u0001BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\u0006q\u0001!\tA\f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0002B\u0011\u0019)\u0005\u0001)A\u0007\u0005\"9a\t\u0001b\u0001\n\u00039\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ra\u0003\u0001\u0015!\u0003S\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015!\u0007\u0001\"\u0001]\u0011\u0015I\u0007\u0001\"\u0001]\u0011\u0015Y\u0007\u0001\"\u0001]\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u00159\b\u0001\"\u0003o\u0011\u0015A\b\u0001\"\u0003o\u0011\u0015I\b\u0001\"\u0003{\u000559vN\u001d3D_VtG\u000fV3ti*\u0011acF\u0001\u0006g\u000e\fG.\u0019\u0006\u00031e\tqa\u001d;sK\u0006l7O\u0003\u0002\u001b7\u0005)1.\u00194lC*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011'!\t\u0011C%D\u0001$\u0015\u00051\u0012BA\u0013$\u0005\u0019\te.\u001f*fMB\u0011q\u0005K\u0007\u0002+%\u0011\u0011&\u0006\u0002\u0012/>\u0014HmQ8v]R$Vm\u001d;ECR\f\u0017A\u0002\u001fj]&$h\bF\u0001-!\t9\u0003!\u0001\bqe&4\u0018\r^3DYV\u001cH/\u001a:\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u000bU$\u0018\u000e\\:\u000b\u0005Q:\u0012aC5oi\u0016<'/\u0019;j_:L!AN\u0019\u0003)\u0015k'-\u001a3eK\u0012\\\u0015MZ6b\u00072,8\u000f^3s\u0003=\u0001(/\u001b<bi\u0016\u001cE.^:uKJ\u0004\u0013aB2mkN$XM\u001d\u0015\u0003\ti\u0002\"a\u000f \u000e\u0003qR!!P\u000f\u0002\u000b),h.\u001b;\n\u0005}b$\u0001\u0002*vY\u0016\f1\"\u00197jO:,G\rV5nKV\t!\t\u0005\u0002#\u0007&\u0011Ai\t\u0002\u0005\u0019>tw-\u0001\u0007bY&<g.\u001a3US6,\u0007%\u0001\u0005n_\u000e\\G+[7f+\u0005A\u0005CA%N\u001b\u0005Q%B\u0001\u001aL\u0015\ta\u0015$\u0001\u0004d_6lwN\\\u0005\u0003\u001d*\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nq\u0001\u001e$pY\u0012,'/F\u0001S!\t\u0019f+D\u0001U\u0015\t)F(A\u0003sk2,7/\u0003\u0002X)\nyA+Z7q_J\f'/\u001f$pY\u0012,'/\u0001\u0005u\r>dG-\u001a:!\u0003)!Xm\u001d;G_2$WM\u001d\u0015\u0003\u0017i\n\u0011c\u001d;beR\\\u0015MZ6b\u00072,8\u000f^3s)\u0005i\u0006C\u0001\u0012_\u0013\ty6E\u0001\u0003V]&$\bF\u0001\u0007b!\tY$-\u0003\u0002dy\t1!)\u001a4pe\u0016\fA\u0003^3tiNCw.\u001e7e\u0007>,h\u000e^,pe\u0012\u001c\bFA\u0007g!\tYt-\u0003\u0002iy\t!A+Z:u\u0003\u0001\"Xm\u001d;TQ>,H\u000eZ\"pk:$xk\u001c:eg6\u000bG/\u001a:jC2L'0\u001a3)\u000591\u0017\u0001\u0007;fgR\u001c\u0006n\\;mI\u000e{WO\u001c;X_J$7OS1wC\"\u0012qBZ\u0001\u0018O\u0016$8\u000b\u001e:fC6\u001c8i\u001c8gS\u001e,(/\u0019;j_:$\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA!\u001e;jY*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005)\u0001&o\u001c9feRLWm]\u0001\u0012O\u0016$\bK]8ek\u000e,'oQ8oM&<\u0017!E4fi\u000e{gn];nKJ\u001cuN\u001c4jO\u0006y\u0001O]8ek\u000e,gjQ8ogVlW\rF\u0003|\u00037\ty\u0002E\u0002qyzL!!`9\u0003\t1K7\u000f\u001e\t\u0007\u007f\u0006\u0005\u0011Q\u0001\"\u000e\u0003]I1!a\u0001\u0018\u0005!YU-\u001f,bYV,\u0007\u0003BA\u0004\u0003+qA!!\u0003\u0002\u0012A\u0019\u00111B\u0012\u000e\u0005\u00055!bAA\b?\u00051AH]8pizJ1!a\u0005$\u0003\u0019\u0001&/\u001a3fM&!\u0011qCA\r\u0005\u0019\u0019FO]5oO*\u0019\u00111C\u0012\t\u000f\u0005u1\u00031\u0001\u0002\u0006\u0005Q\u0011N\u001c9viR{\u0007/[2\t\u000f\u0005\u00052\u00031\u0001\u0002\u0006\u0005Yq.\u001e;qkR$v\u000e]5dQ\u001d\u0001\u0011QEA\u001b\u0003o\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0006dCR,wm\u001c:jKNT1!a\f=\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0013\u0011\t\u0019$!\u000b\u0003\u0011\r\u000bG/Z4pef\fQA^1mk\u0016d#!!\u000f$\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u0013$\u0001\u0003uKN$\u0018\u0002BA#\u0003\u007f\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e")
public class WordCountTest
implements WordCountTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String inputTopic;
    private final String outputTopic;
    private final String inputTopicJ;
    private final String outputTopicJ;
    private final List<String> inputValues;
    private final List<KeyValue<String, Object>> expectedWordCounts;

    @Override
    public String inputTopic() {
        return this.inputTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String inputTopicJ() {
        return this.inputTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public List<String> inputValues() {
        return this.inputValues;
    }

    @Override
    public List<KeyValue<String, Object>> expectedWordCounts() {
        return this.expectedWordCounts;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopic_$eq(String x$1) {
        this.inputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopicJ_$eq(String x$1) {
        this.inputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputValues_$eq(List<String> x$1) {
        this.inputValues = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$expectedWordCounts_$eq(List<KeyValue<String, Object>> x$1) {
        this.expectedWordCounts = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.inputTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.inputTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @Test
    public void testShouldCountWords() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(x$1, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsMaterialized() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(k, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(Materialized$.MODULE$.as("word-count", Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsJava() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        streamsConfiguration.put("default.key.serde", Serdes$.MODULE$.String().getClass().getName());
        streamsConfiguration.put("default.value.serde", Serdes$.MODULE$.String().getClass().getName());
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopicJ());
        Pattern pattern = Pattern.compile("\\W+", 256);
        org.apache.kafka.streams.kstream.KStream splits = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(null, pattern){
            private final Pattern pattern$3;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.pattern$3.split(s.toLowerCase()))).toIterable()).asJava();
            }
            {
                this.pattern$3 = pattern$3;
            }
        });
        KGroupedStream grouped = splits.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(null){

            public String apply(String k, String v) {
                return v;
            }
        });
        org.apache.kafka.streams.kstream.KTable wordCounts = grouped.count();
        wordCounts.toStream().to(this.outputTopicJ(), Produced.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.JavaLong()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopicJ(), this.outputTopicJ());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.key, (Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "wordcount-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "10000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "wordcount-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    private java.util.List<KeyValue<String, Object>> produceNConsume(String inputTopic, String outputTopic) {
        Properties linesProducerConfig = this.getProducerConfig();
        IntegrationTestUtils.produceValuesSynchronously((String)inputTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.inputValues()).asJava()), (Properties)linesProducerConfig, (Time)this.mockTime());
        Properties consumerConfig = this.getConsumerConfig();
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (int)this.expectedWordCounts().size());
    }

    public WordCountTest() {
        WordCountTestData.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

