/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.scala.utils.StreamToTableJoinTestData;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.scalatest.junit.JUnitSuite;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\n\u0015\u0001\u0005BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004;\u0001\u0001\u0006Ia\r\u0005\u0006w\u0001!\tA\r\u0005\b\u0005\u0002\u0011\r\u0011\"\u0002D\u0011\u0019I\u0005\u0001)A\u0007\t\"9!\n\u0001b\u0001\n\u0003Y\u0005BB*\u0001A\u0003%A\nC\u0004U\u0001\t\u0007I\u0011A+\t\rq\u0003\u0001\u0015!\u0003W\u0011\u0015i\u0006\u0001\"\u0001V\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015\u0011\b\u0001\"\u0003j\u0011\u0015\u0019\b\u0001\"\u0003j\u0011\u0015!\b\u0001\"\u0003j\u0011\u0015)\b\u0001\"\u0001w\u0011%\tI\u0003AI\u0001\n\u0003\tYCA\u0015TiJ,\u0017-\u001c+p)\u0006\u0014G.\u001a&pS:\u001c6-\u00197b\u0013:$Xm\u001a:bi&|g\u000eV3ti\n\u000b7/\u001a\u0006\u0003+Y\tQ!\u001e;jYNT!a\u0006\r\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005eQ\u0012aB:ue\u0016\fWn\u001d\u0006\u00037q\tQa[1gW\u0006T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011c\u0001\u0001#UA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003Oy\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005%\"#A\u0003&V]&$8+^5uKB\u00111\u0006L\u0007\u0002)%\u0011Q\u0006\u0006\u0002\u001a'R\u0014X-Y7U_R\u000b'\r\\3K_&tG+Z:u\t\u0006$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u00111\u0006A\u0001\u000faJLg/\u0019;f\u00072,8\u000f^3s+\u0005\u0019\u0004C\u0001\u001b9\u001b\u0005)$BA\u000b7\u0015\t9\u0004$A\u0006j]R,wM]1uS>t\u0017BA\u001d6\u0005Q)UNY3eI\u0016$7*\u00194lC\u000ecWo\u001d;fe\u0006y\u0001O]5wCR,7\t\\;ti\u0016\u0014\b%A\u0004dYV\u001cH/\u001a:)\u0005\u0011i\u0004C\u0001 A\u001b\u0005y$BA\u0013\u001f\u0013\t\tuH\u0001\u0003Sk2,\u0017aC1mS\u001etW\r\u001a+j[\u0016,\u0012\u0001\u0012\t\u0003\u000b\u001ek\u0011A\u0012\u0006\u0002/%\u0011\u0001J\u0012\u0002\u0005\u0019>tw-\u0001\u0007bY&<g.\u001a3US6,\u0007%\u0001\u0005n_\u000e\\G+[7f+\u0005a\u0005CA'R\u001b\u0005q%BA\u000bP\u0015\t\u0001&$\u0001\u0004d_6lwN\\\u0005\u0003%:\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nq\u0001\u001e$pY\u0012,'/F\u0001W!\t9&,D\u0001Y\u0015\tIv(A\u0003sk2,7/\u0003\u0002\\1\nyA+Z7q_J\f'/\u001f$pY\u0012,'/\u0001\u0005u\r>dG-\u001a:!\u0003)!Xm\u001d;G_2$WM\u001d\u0015\u0003\u0017u\n\u0011c\u001d;beR\\\u0015MZ6b\u00072,8\u000f^3s)\u0005\t\u0007CA#c\u0013\t\u0019gI\u0001\u0003V]&$\bF\u0001\u0007f!\tqd-\u0003\u0002h\u007f\t1!)\u001a4pe\u0016\fqcZ3u'R\u0014X-Y7t\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\tU$\u0018\u000e\u001c\u0006\u0002_\u0006!!.\u0019<b\u0013\t\tHN\u0001\u0006Qe>\u0004XM\u001d;jKN\fAdZ3u+N,'OU3hS>t7\u000f\u0015:pIV\u001cWM]\"p]\u001aLw-A\u000ehKR,6/\u001a:DY&\u001c7n\u001d)s_\u0012,8-\u001a:D_:4\u0017nZ\u0001\u0012O\u0016$8i\u001c8tk6,'oQ8oM&<\u0017a\u00049s_\u0012,8-\u001a(D_:\u001cX/\\3\u0015\u0013]\f\u0019\"a\u0006\u0002\u001c\u0005}\u0001cA6yu&\u0011\u0011\u0010\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003|yz$U\"\u0001\r\n\u0005uD\"\u0001C&fsZ\u000bG.^3\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\r6\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0001\u0013A\u0002\u001fs_>$h(C\u0002\u0002\f\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\r\"1\u0011QC\tA\u0002y\fq\"^:fe\u000ec\u0017nY6t)>\u0004\u0018n\u0019\u0005\u0007\u00033\t\u0002\u0019\u0001@\u0002!U\u001cXM\u001d*fO&|gn\u001d+pa&\u001c\u0007BBA\u000f#\u0001\u0007a0A\u0006pkR\u0004X\u000f\u001e+pa&\u001c\u0007\"CA\u0011#A\u0005\t\u0019AA\u0012\u0003]9\u0018-\u001b;US2d'+Z2pe\u0012\u001c(+Z2fSZ,G\rE\u0002F\u0003KI1!a\nG\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0004\u001d:pIV\u001cWMT\"p]N,X.\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0006\u0016\u0005\u0003G\tyc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tYDR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQ\u001d\u0001\u00111IA*\u0003+\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0006dCR,wm\u001c:jKNT1!!\u0014@\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0013\u0011\t\t&a\u0012\u0003\u0011\r\u000bG/Z4pef\fQA^1mk\u0016d#!a\u0016$\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}#$\u0001\u0003uKN$\u0018\u0002BA2\u0003;\u0012q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e")
public class StreamToTableJoinScalaIntegrationTestBase
extends JUnitSuite
implements StreamToTableJoinTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String brokers;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final String outputTopic;
    private final String userClicksTopicJ;
    private final String userRegionsTopicJ;
    private final String outputTopicJ;
    private final Seq<KeyValue<String, Object>> userClicks;
    private final Seq<KeyValue<String, String>> userRegions;
    private final Seq<KeyValue<String, Object>> expectedClicksPerRegion;

    @Override
    public String brokers() {
        return this.brokers;
    }

    @Override
    public String userClicksTopic() {
        return this.userClicksTopic;
    }

    @Override
    public String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String userClicksTopicJ() {
        return this.userClicksTopicJ;
    }

    @Override
    public String userRegionsTopicJ() {
        return this.userRegionsTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public Seq<KeyValue<String, Object>> userClicks() {
        return this.userClicks;
    }

    @Override
    public Seq<KeyValue<String, String>> userRegions() {
        return this.userRegions;
    }

    @Override
    public Seq<KeyValue<String, Object>> expectedClicksPerRegion() {
        return this.expectedClicksPerRegion;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$brokers_$eq(String x$1) {
        this.brokers = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopic_$eq(String x$1) {
        this.userClicksTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopic_$eq(String x$1) {
        this.userRegionsTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopicJ_$eq(String x$1) {
        this.userClicksTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopicJ_$eq(String x$1) {
        this.userRegionsTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicks_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.userClicks = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegions_$eq(Seq<KeyValue<String, String>> x$1) {
        this.userRegions = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$expectedClicksPerRegion_$eq(Seq<KeyValue<String, Object>> x$1) {
        this.expectedClicksPerRegion = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.userClicksTopic());
        this.cluster().createTopic(this.userRegionsTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.userClicksTopicJ());
        this.cluster().createTopic(this.userRegionsTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    /*
     * WARNING - void declaration
     */
    public Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "stream-table-join-scala-integration-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "1000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserRegionsProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserClicksProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", LongSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "join-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    public List<KeyValue<String, Object>> produceNConsume(String userClicksTopic, String userRegionsTopic, String outputTopic, boolean waitTillRecordsReceived) {
        List list;
        Properties userRegionsProducerConfig = this.getUserRegionsProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userRegionsTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userRegions()).asJava()), (Properties)userRegionsProducerConfig, (Time)this.mockTime(), (boolean)false);
        Properties userClicksProducerConfig = this.getUserClicksProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userClicksTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userClicks()).asJava()), (Properties)userClicksProducerConfig, (Time)this.mockTime(), (boolean)false);
        if (waitTillRecordsReceived) {
            Properties consumerConfig = this.getConsumerConfig();
            list = IntegrationTestUtils.waitUntilFinalKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.expectedClicksPerRegion()).asJava()));
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public boolean produceNConsume$default$4() {
        return true;
    }

    public StreamToTableJoinScalaIntegrationTestBase() {
        StreamToTableJoinTestData.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

