/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.Serdes$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.WordCountTestData;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000b\u0016\u0001\u0001BQ!\f\u0001\u0005\u00029Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\u0006w\u0001!\t!\r\u0005\b\u0005\u0002\u0011\r\u0011\"\u0002D\u0011\u0019I\u0005\u0001)A\u0007\t\"9!\n\u0001b\u0001\n\u0003Y\u0005BB*\u0001A\u0003%A\nC\u0004U\u0001\t\u0007I\u0011A+\t\rq\u0003\u0001\u0015!\u0003W\u0011\u0015i\u0006\u0001\"\u0001V\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015A\u0007\u0001\"\u0001a\u0011\u0015i\u0007\u0001\"\u0001a\u0011\u0015y\u0007\u0001\"\u0001a\u0011\u0015\t\b\u0001\"\u0003s\u0011\u0015Y\b\u0001\"\u0003s\u0011\u0015a\b\u0001\"\u0003s\u0011\u0015i\b\u0001\"\u0003\u007f\u000559vN\u001d3D_VtG\u000fV3ti*\u0011acF\u0001\u0006g\u000e\fG.\u0019\u0006\u00031e\tqa\u001d;sK\u0006l7O\u0003\u0002\u001b7\u0005)1.\u00194lC*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011*!\t\u0011s%D\u0001$\u0015\t!S%A\u0003kk:LGO\u0003\u0002';\u0005I1oY1mCR,7\u000f^\u0005\u0003Q\r\u0012!BS+oSR\u001cV/\u001b;f!\tQ3&D\u0001\u0016\u0013\taSCA\tX_J$7i\\;oiR+7\u000f\u001e#bi\u0006\fa\u0001P5oSRtD#A\u0018\u0011\u0005)\u0002\u0011A\u00049sSZ\fG/Z\"mkN$XM]\u000b\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0006kRLGn\u001d\u0006\u0003o]\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011\u0011\b\u000e\u0002\u0015\u000b6\u0014W\r\u001a3fI.\u000bgm[1DYV\u001cH/\u001a:\u0002\u001fA\u0014\u0018N^1uK\u000ecWo\u001d;fe\u0002\nqa\u00197vgR,'\u000f\u000b\u0002\u0005{A\u0011a\bQ\u0007\u0002\u007f)\u0011A%H\u0005\u0003\u0003~\u0012AAU;mK\u0006Y\u0011\r\\5h]\u0016$G+[7f+\u0005!\u0005CA#H\u001b\u00051%\"\u0001\f\n\u0005!3%\u0001\u0002'p]\u001e\fA\"\u00197jO:,G\rV5nK\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0002\u0019B\u0011Q*U\u0007\u0002\u001d*\u0011Qg\u0014\u0006\u0003!f\taaY8n[>t\u0017B\u0001*O\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u001d!hi\u001c7eKJ,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033~\nQA];mKNL!a\u0017-\u0003\u001fQ+W\u000e]8sCJLhi\u001c7eKJ\f\u0001\u0002\u001e$pY\u0012,'\u000fI\u0001\u000bi\u0016\u001cHOR8mI\u0016\u0014\bFA\u0006>\u0003E\u0019H/\u0019:u\u0017\u000647.Y\"mkN$XM\u001d\u000b\u0002CB\u0011QIY\u0005\u0003G\u001a\u0013A!\u00168ji\"\u0012A\"\u001a\t\u0003}\u0019L!aZ \u0003\r\t+gm\u001c:f\u0003Q!Xm\u001d;TQ>,H\u000eZ\"pk:$xk\u001c:eg\"\u0012QB\u001b\t\u0003}-L!\u0001\\ \u0003\tQ+7\u000f^\u0001!i\u0016\u001cHo\u00155pk2$7i\\;oi^{'\u000fZ:NCR,'/[1mSj,G\r\u000b\u0002\u000fU\u0006AB/Z:u'\"|W\u000f\u001c3D_VtGoV8sINT\u0015M^1)\u0005=Q\u0017aF4fiN#(/Z1ng\u000e{gNZ5hkJ\fG/[8o)\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!0\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!E4fiB\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\u0006\tr-\u001a;D_:\u001cX/\\3s\u0007>tg-[4\u0002\u001fA\u0014x\u000eZ;dK:\u001buN\\:v[\u0016$Ra`A\u0012\u0003O\u0001R\u0001^A\u0001\u0003\u000bI1!a\u0001v\u0005\u0011a\u0015n\u001d;\u0011\u000f\u0005\u001d\u0011\u0011BA\u0007\t6\tq#C\u0002\u0002\f]\u0011\u0001bS3z-\u0006dW/\u001a\t\u0005\u0003\u001f\tiB\u0004\u0003\u0002\u0012\u0005e\u0001cAA\n\r6\u0011\u0011Q\u0003\u0006\u0004\u0003/y\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u001c\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000e\r\"9\u0011QE\nA\u0002\u00055\u0011AC5oaV$Hk\u001c9jG\"9\u0011\u0011F\nA\u0002\u00055\u0011aC8viB,H\u000fV8qS\u000eDs\u0001AA\u0017\u0003{\ty\u0004\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0015\r\fG/Z4pe&,7OC\u0002\u00028}\nA\"\u001a=qKJLW.\u001a8uC2LA!a\u000f\u00022\tA1)\u0019;fO>\u0014\u00180A\u0003wC2,X\r\f\u0002\u0002B\r\u0012\u00111\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\r\u0002\tQ,7\u000f^\u0005\u0005\u0003\u001b\n9EA\bJ]R,wM]1uS>tG+Z:u\u0001")
public class WordCountTest
extends JUnitSuite
implements WordCountTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String inputTopic;
    private final String outputTopic;
    private final String inputTopicJ;
    private final String outputTopicJ;
    private final List<String> inputValues;
    private final List<KeyValue<String, Object>> expectedWordCounts;

    @Override
    public String inputTopic() {
        return this.inputTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String inputTopicJ() {
        return this.inputTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public List<String> inputValues() {
        return this.inputValues;
    }

    @Override
    public List<KeyValue<String, Object>> expectedWordCounts() {
        return this.expectedWordCounts;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopic_$eq(String x$1) {
        this.inputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopicJ_$eq(String x$1) {
        this.inputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputValues_$eq(List<String> x$1) {
        this.inputValues = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$expectedWordCounts_$eq(List<KeyValue<String, Object>> x$1) {
        this.expectedWordCounts = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.inputTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.inputTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @Test
    public void testShouldCountWords() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(x$1, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsMaterialized() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])pattern.split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(k, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(Materialized$.MODULE$.as("word-count", Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.key, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsJava() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        streamsConfiguration.put("default.key.serde", Serdes$.MODULE$.String().getClass().getName());
        streamsConfiguration.put("default.value.serde", Serdes$.MODULE$.String().getClass().getName());
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopicJ());
        Pattern pattern = Pattern.compile("\\W+", 256);
        org.apache.kafka.streams.kstream.KStream splits = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(null, pattern){
            private final Pattern pattern$3;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.pattern$3.split(s.toLowerCase()))).toIterable()).asJava();
            }
            {
                this.pattern$3 = pattern$3;
            }
        });
        KGroupedStream grouped = splits.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(null){

            public String apply(String k, String v) {
                return v;
            }
        });
        org.apache.kafka.streams.kstream.KTable wordCounts = grouped.count();
        wordCounts.toStream().to(this.outputTopicJ(), Produced.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.JavaLong()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopicJ(), this.outputTopicJ());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6.key, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.key, (Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "wordcount-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "10000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "wordcount-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    private java.util.List<KeyValue<String, Object>> produceNConsume(String inputTopic, String outputTopic) {
        Properties linesProducerConfig = this.getProducerConfig();
        IntegrationTestUtils.produceValuesSynchronously((String)inputTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.inputValues()).asJava()), (Properties)linesProducerConfig, (Time)this.mockTime());
        Properties consumerConfig = this.getConsumerConfig();
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (int)this.expectedWordCounts().size());
    }

    public WordCountTest() {
        WordCountTestData.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

