/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.Serdes$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.kstream.Consumed$;
import org.apache.kafka.streams.scala.kstream.Grouped$;
import org.apache.kafka.streams.scala.kstream.Joined$;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.streams.scala.kstream.Produced$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001F\u000b\u0001A!)\u0011\u0006\u0001C\u0001U!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00049\u0001\t\u0007I\u0011\u0001\u0018\t\re\u0002\u0001\u0015!\u00030\u0011\u001dQ\u0004A1A\u0005\u00029Baa\u000f\u0001!\u0002\u0013y\u0003b\u0002\u001f\u0001\u0005\u0004%\t!\u0010\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002 \t\u000b\u001d\u0003A\u0011\u0001%\t\u000bQ\u0003A\u0011\u0001%\t\u000bY\u0003A\u0011\u0001%\t\u000ba\u0003A\u0011\u0001%\t\u000bi\u0003A\u0011\u0001%\u0007\tq\u0003A!\u0018\u0005\t]>\u0011)\u0019!C\u0001_\"AAo\u0004B\u0001B\u0003%\u0001\u000f\u0003\u0004*\u001f\u0011\u0005\u0001!\u001e\u0005\u0006s>!\tE\u001f\u0002\r)>\u0004x\u000e\\8hsR+7\u000f\u001e\u0006\u0003-]\tQa]2bY\u0006T!\u0001G\r\u0002\u000fM$(/Z1ng*\u0011!dG\u0001\u0006W\u000647.\u0019\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\t1S$A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001f\t\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0016\u0003)Ig\u000e];u)>\u0004\u0018nY\u000b\u0002_A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0005Y\u0006twMC\u00015\u0003\u0011Q\u0017M^1\n\u0005Y\n$AB*ue&tw-A\u0006j]B,H\u000fV8qS\u000e\u0004\u0013aD;tKJ\u001cE.[2lgR{\u0007/[2\u0002!U\u001cXM]\"mS\u000e\\7\u000fV8qS\u000e\u0004\u0013\u0001E;tKJ\u0014VmZ5p]N$v\u000e]5d\u0003E)8/\u001a:SK\u001eLwN\\:U_BL7\rI\u0001\ba\u0006$H/\u001a:o+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003\u0015\u0011XmZ3y\u0015\t\u00195'\u0001\u0003vi&d\u0017BA#A\u0005\u001d\u0001\u0016\r\u001e;fe:\f\u0001\u0002]1ui\u0016\u0014h\u000eI\u0001/g\"|W\u000f\u001c3Ck&dG-\u00133f]RL7-\u00197U_B|Gn\\4z\u0013:T\u0015M^1O'\u000e\fG.Y*j[BdW\rF\u0001J!\tQE*D\u0001L\u0015\u00051\u0012BA'L\u0005\u0011)f.\u001b;)\u0005)y\u0005C\u0001)S\u001b\u0005\t&B\u0001\u0013\u001e\u0013\t\u0019\u0016K\u0001\u0003UKN$\u0018!M:i_VdGMQ;jY\u0012LE-\u001a8uS\u000e\fG\u000eV8q_2|w-_%o\u0015\u00064\u0018MT*dC2\f\u0017iZ4sK\u001e\fG/\u001a\u0015\u0003\u0017=\u000bAf\u001d5pk2$')^5mI&#WM\u001c;jG\u0006dGk\u001c9pY><\u00170\u00138KCZ\fgjU2bY\u0006Tu.\u001b8)\u00051y\u0015!M:i_VdGMQ;jY\u0012LE-\u001a8uS\u000e\fG\u000eV8q_2|w-_%o\u0015\u00064\u0018MT*dC2\fGK]1og\u001a|'/\u001c\u0015\u0003\u001b=\u000b!g\u001d5pk2$')^5mI&#WM\u001c;jG\u0006dGk\u001c9pY><\u00170\u00138KCZ\fgjU2bY\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u001d=\u0013qbU5na2,\u0007K]8dKN\u001cxN]\n\u0003\u001fy\u0003Ba\u00182eI6\t\u0001M\u0003\u0002b/\u0005I\u0001O]8dKN\u001cxN]\u0005\u0003G\u0002\u0014\u0011#\u00112tiJ\f7\r\u001e)s_\u000e,7o]8s!\t)GN\u0004\u0002gUB\u0011qmS\u0007\u0002Q*\u0011\u0011nH\u0001\u0007yI|w\u000e\u001e \n\u0005-\\\u0015A\u0002)sK\u0012,g-\u0003\u00027[*\u00111nS\u0001\nm\u0006dW/\u001a'jgR,\u0012\u0001\u001d\t\u0004cJ$W\"\u0001\"\n\u0005M\u0014%\u0001\u0002'jgR\f!B^1mk\u0016d\u0015n\u001d;!)\t1\b\u0010\u0005\u0002x\u001f5\t\u0001\u0001C\u0003o%\u0001\u0007\u0001/A\u0004qe>\u001cWm]:\u0015\u0007%[X\u0010C\u0003}'\u0001\u0007A-A\u0002lKfDQA`\nA\u0002\u0011\fQA^1mk\u0016\u0004")
public class TopologyTest
extends JUnitSuite {
    private final String inputTopic;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final Pattern pattern = Pattern.compile("\\W+", 256);

    public String inputTopic() {
        return this.inputTopic;
    }

    public String userClicksTopic() {
        return this.userClicksTopic;
    }

    public String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaSimple() {
        Assert.assertEquals((Object)this.getTopologyScala$1(), (Object)this.getTopologyJava$1());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaAggregate() {
        Assert.assertEquals((Object)this.getTopologyScala$2(), (Object)this.getTopologyJava$2());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaJoin() {
        Assert.assertEquals((Object)this.getTopologyScala$3(), (Object)this.getTopologyJava$3());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaTransform() {
        Assert.assertEquals((Object)this.getTopologyScala$4(), (Object)this.getTopologyJava$4());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaProperties() {
        Properties props = new Properties();
        props.put("topology.optimization", "all");
        Properties propsNoOptimization = new Properties();
        propsNoOptimization.put("topology.optimization", "none");
        String AGGREGATION_TOPIC = "aggregationTopic";
        String REDUCE_TOPIC = "reduceTopic";
        String JOINED_TOPIC = "joinedTopic";
        Assert.assertNotEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString(), (Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString());
        Assert.assertEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString(), (Object)this.getTopologyJava$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString());
        Assert.assertEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString(), (Object)this.getTopologyJava$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString());
    }

    private final TopologyDescription getTopologyScala$1() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KStream _ = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])this.pattern().split(v.toLowerCase())));
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$1() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream _ = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(this){
            private final /* synthetic */ TopologyTest $outer;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.pattern().split(s.toLowerCase()))).toIterable()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyScala$2() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KTable _ = textLines.flatMapValues((Function1 & Serializable & scala.Serializable)v -> Predef$.MODULE$.wrapRefArray((Object[])this.pattern().split(v.toLowerCase()))).groupBy((Function2 & Serializable & scala.Serializable)(k, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$2() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream splits = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(this){
            private final /* synthetic */ TopologyTest $outer;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.pattern().split(s.toLowerCase()))).toIterable()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        KGroupedStream grouped = splits.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(null){

            public String apply(String k, String v) {
                return v;
            }
        });
        org.apache.kafka.streams.kstream.KTable wordCounts = grouped.count();
        return streamBuilder.build().describe();
    }

    public static final /* synthetic */ Tuple2 $anonfun$shouldBuildIdenticalTopologyInJavaNScalaJoin$1(long clicks, String region) {
        return new Tuple2((Object)(region == null ? "UNKNOWN" : region), (Object)BoxesRunTime.boxToLong((long)clicks));
    }

    private final TopologyDescription getTopologyScala$3() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream userClicksStream = builder.stream(this.userClicksTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KTable userRegionsTable = builder.table(this.userRegionsTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KTable clicksPerRegion = userClicksStream.leftJoin(userRegionsTable, (Function2 & Serializable & scala.Serializable)(clicks, region) -> TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaJoin$1(BoxesRunTime.unboxToLong((Object)clicks), region), ImplicitConversions$.MODULE$.joinedFromKeyValueOtherSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long(), Serdes$.MODULE$.String())).map((Function2 & Serializable & scala.Serializable)(x$1, regionWithClicks) -> regionWithClicks).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long())).reduce((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3, ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return builder.build().describe();
    }

    private final TopologyDescription getTopologyJava$3() {
        org.apache.kafka.streams.StreamsBuilder builder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream userClicksStream = builder.stream(this.userClicksTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong()));
        org.apache.kafka.streams.kstream.KTable userRegionsTable = builder.table(this.userRegionsTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream userClicksJoinRegion = userClicksStream.leftJoin(userRegionsTable, (ValueJoiner)new ValueJoiner<Long, String, Tuple2<String, Long>>(null){

            public Tuple2<String, Long> apply(Long clicks, String region) {
                return new Tuple2((Object)(region == null ? "UNKNOWN" : region), (Object)clicks);
            }
        }, Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream clicksByRegion = userClicksJoinRegion.map((KeyValueMapper)new KeyValueMapper<String, Tuple2<String, Long>, KeyValue<String, Long>>(null){

            public KeyValue<String, Long> apply(String k, Tuple2<String, Long> regionWithClicks) {
                return new KeyValue(regionWithClicks._1(), regionWithClicks._2());
            }
        });
        org.apache.kafka.streams.kstream.KTable clicksPerRegion = clicksByRegion.groupByKey(Grouped$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong())).reduce((Reducer)new Reducer<Long>(null){

            public Long apply(Long v1, Long v2) {
                return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(v1) + Predef$.MODULE$.Long2long(v2));
            }
        });
        return builder.build().describe();
    }

    private final TopologyDescription getTopologyScala$4() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KTable _ = textLines.transform((TransformerSupplier)new TransformerSupplier<String, String, KeyValue<String, String>>(null){

            public Transformer<String, String, KeyValue<String, String>> get() {
                return new Transformer<String, String, KeyValue<String, String>>(null){

                    public void init(ProcessorContext context) {
                    }

                    public KeyValue<String, String> transform(String key, String value) {
                        return new KeyValue((Object)key, (Object)value.toLowerCase());
                    }

                    public void close() {
                    }
                };
            }
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).groupBy((Function2 & Serializable & scala.Serializable)(k, v) -> v, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$4() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream lowered = textLines.transform((TransformerSupplier)new TransformerSupplier<String, String, KeyValue<String, String>>(null){

            public Transformer<String, String, KeyValue<String, String>> get() {
                return new Transformer<String, String, KeyValue<String, String>>(null){

                    public void init(ProcessorContext context) {
                    }

                    public KeyValue<String, String> transform(String key, String value) {
                        return new KeyValue((Object)key, (Object)value.toLowerCase());
                    }

                    public void close() {
                    }
                };
            }
        }, new String[0]);
        KGroupedStream grouped = lowered.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(null){

            public String apply(String k, String v) {
                return v;
            }
        });
        org.apache.kafka.streams.kstream.KTable wordCounts = grouped.count();
        return streamBuilder.build().describe();
    }

    public static final /* synthetic */ int $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$1(String x$4, String v, int agg) {
        return agg + v.length();
    }

    public static final /* synthetic */ boolean $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$4(String k, String x$5) {
        String string = k;
        String string2 = "B";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$8(String x$6, String x$7) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$10(String k, String x$8) {
        String string = k;
        String string2 = "A";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$11(String v1, int v2) {
        return new StringBuilder(1).append(v1).append(":").append(((Object)BoxesRunTime.boxToInteger((int)v2)).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$12(String k, String x$9) {
        String string = k;
        String string2 = "A";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final StreamsBuilder getTopologyScala$5(String AGGREGATION_TOPIC$1, String REDUCE_TOPIC$1, String JOINED_TOPIC$1) {
        Function3 & Serializable & scala.Serializable aggregator = (Function3 & Serializable & scala.Serializable)(x$4, v, agg) -> BoxesRunTime.boxToInteger((int)TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$1(x$4, v, BoxesRunTime.unboxToInt((Object)agg)));
        Function2 & Serializable & scala.Serializable reducer = (Function2 & Serializable & scala.Serializable)(v1, v2) -> new StringBuilder(1).append((String)v1).append(":").append((String)v2).toString();
        ArrayList processorValueCollector = new ArrayList();
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream sourceStream = builder.stream(this.inputTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KStream mappedStream = sourceStream.map((Function2 & Serializable & scala.Serializable)(k, v) -> new Tuple2((Object)k.toUpperCase(Locale.getDefault()), v));
        mappedStream.filter((Function2 & Serializable & scala.Serializable)(k, x$5) -> BoxesRunTime.boxToBoolean((boolean)TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$4(k, x$5))).mapValues((Function1 & Serializable & scala.Serializable)v -> v.toUpperCase(Locale.getDefault())).process((Function0 & Serializable & scala.Serializable)() -> new SimpleProcessor(this, processorValueCollector), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        KStream stream2 = mappedStream.groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).aggregate((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function3)aggregator, Materialized$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer())).toStream();
        stream2.to(AGGREGATION_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer()));
        KStream stream3 = mappedStream.filter((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean((boolean)TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$8(x$6, x$7))).peek((Function2 & Serializable & scala.Serializable)(k, v) -> {
            System.out.println(new StringBuilder(1).append(k).append(":").append(v).toString());
            return BoxedUnit.UNIT;
        }).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).reduce((Function2)reducer, Materialized$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).toStream();
        stream3.to(REDUCE_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Function2 & Serializable & scala.Serializable)(k, x$8) -> BoxesRunTime.boxToBoolean((boolean)TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$10(k, x$8))).join(stream2, (Function2 & Serializable & scala.Serializable)(v1, v2) -> TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$11(v1, BoxesRunTime.unboxToInt((Object)v2)), JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer())).to(JOINED_TOPIC$1, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Function2 & Serializable & scala.Serializable)(k, x$9) -> BoxesRunTime.boxToBoolean((boolean)TopologyTest.$anonfun$shouldBuildIdenticalTopologyInJavaNScalaProperties$12(k, x$9))).join(stream3, (Function2 & Serializable & scala.Serializable)(v1, v2) -> new StringBuilder(1).append((String)v1).append(":").append(v2.toString()).toString(), JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).to(JOINED_TOPIC$1, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        return builder;
    }

    private final org.apache.kafka.streams.StreamsBuilder getTopologyJava$5(String AGGREGATION_TOPIC$1, String REDUCE_TOPIC$1, String JOINED_TOPIC$1) {
        KeyValueMapper<String, String, KeyValue<String, String>> keyValueMapper = new KeyValueMapper<String, String, KeyValue<String, String>>(null){

            public KeyValue<String, String> apply(String key, String value) {
                return KeyValue.pair((Object)key.toUpperCase(Locale.getDefault()), (Object)value);
            }
        };
        Initializer<Integer> initializer = new Initializer<Integer>(null){

            public Integer apply() {
                return Predef$.MODULE$.int2Integer(0);
            }
        };
        Aggregator<String, String, Integer> aggregator = new Aggregator<String, String, Integer>(null){

            public Integer apply(String key, String value, Integer aggregate) {
                return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(aggregate) + value.length());
            }
        };
        Reducer<String> reducer = new Reducer<String>(null){

            public String apply(String v1, String v2) {
                return new StringBuilder(1).append(v1).append(":").append(v2).toString();
            }
        };
        ValueMapper<String, String> valueMapper = new ValueMapper<String, String>(null){

            public String apply(String v) {
                return v.toUpperCase(Locale.getDefault());
            }
        };
        ArrayList processorValueCollector = new ArrayList();
        ProcessorSupplier<String, String> processorSupplier = new ProcessorSupplier<String, String>(this, processorValueCollector){
            private final /* synthetic */ TopologyTest $outer;
            private final ArrayList processorValueCollector$2;

            public SimpleProcessor get() {
                return new SimpleProcessor(this.$outer, this.processorValueCollector$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processorValueCollector$2 = processorValueCollector$2;
            }
        };
        ValueJoiner<String, Integer, String> valueJoiner2 = new ValueJoiner<String, Integer, String>(null){

            public String apply(String value1, Integer value2) {
                return new StringBuilder(1).append(value1).append(":").append(value2.toString()).toString();
            }
        };
        ValueJoiner<String, String, String> valueJoiner3 = new ValueJoiner<String, String, String>(null){

            public String apply(String value1, String value2) {
                return new StringBuilder(1).append(value1).append(":").append(value2.toString()).toString();
            }
        };
        org.apache.kafka.streams.StreamsBuilder builder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream sourceStream = builder.stream(this.inputTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream mappedStream = sourceStream.map((KeyValueMapper)keyValueMapper);
        mappedStream.filter((Predicate)new Predicate<String, String>(null){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "B";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).mapValues((ValueMapper)valueMapper).process((ProcessorSupplier)processorSupplier, new String[0]);
        org.apache.kafka.streams.kstream.KStream stream2 = mappedStream.groupByKey().aggregate((Initializer)initializer, (Aggregator)aggregator, Materialized.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes.Integer())).toStream();
        stream2.to(AGGREGATION_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes.Integer()));
        org.apache.kafka.streams.kstream.KStream stream3 = mappedStream.filter((Predicate)new Predicate<String, String>(null){

            public boolean test(String k, String v) {
                return true;
            }
        }).peek((ForeachAction)new ForeachAction<String, String>(null){

            public void apply(String k, String v) {
                System.out.println(new StringBuilder(1).append(k).append(":").append(v).toString());
            }
        }).groupByKey().reduce((Reducer)reducer, Materialized.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String())).toStream();
        stream3.to(REDUCE_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Predicate)new Predicate<String, String>(null){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream2, (ValueJoiner)valueJoiner2, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String(), (Serde)Serdes.Integer())).to(JOINED_TOPIC$1);
        mappedStream.filter((Predicate)new Predicate<String, String>(null){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream3, (ValueJoiner)valueJoiner3, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String(), (Serde)Serdes.String())).to(JOINED_TOPIC$1);
        return builder;
    }

    public TopologyTest() {
        this.inputTopic = "input-topic";
        this.userClicksTopic = "user-clicks-topic";
        this.userRegionsTopic = "user-regions-topic";
    }

    public class SimpleProcessor
    extends AbstractProcessor<String, String> {
        private final List<String> valueList;
        public final /* synthetic */ TopologyTest $outer;

        public List<String> valueList() {
            return this.valueList;
        }

        public void process(String key, String value) {
            this.valueList().add(value);
        }

        public /* synthetic */ TopologyTest org$apache$kafka$streams$scala$TopologyTest$SimpleProcessor$$$outer() {
            return this.$outer;
        }

        public SimpleProcessor(TopologyTest $outer, List<String> valueList) {
            this.valueList = valueList;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

