/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.scala.utils.StreamToTableJoinTestData;
import org.apache.kafka.streams.scala.utils.StreamToTableJoinTestData$class;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001=\u0011\u0011f\u0015;sK\u0006lGk\u001c+bE2,'j\\5o'\u000e\fG.Y%oi\u0016<'/\u0019;j_:$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0003tG\u0006d\u0017M\u0003\u0002\b\u0011\u000591\u000f\u001e:fC6\u001c(BA\u0005\u000b\u0003\u0015Y\u0017MZ6b\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001E\u000b\u0011\u0005E\u0019R\"\u0001\n\u000b\u0003\u0015I!\u0001\u0006\n\u0003\r\u0005s\u0017PU3g!\t1r#D\u0001\u0003\u0013\tA\"AA\rTiJ,\u0017-\u001c+p)\u0006\u0014G.\u001a&pS:$Vm\u001d;ECR\f\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t1\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u001dA\u0014\u0018N^1uK\u000ecWo\u001d;feV\t\u0001\u0005\u0005\u0002\"K5\t!E\u0003\u0002\u0004G)\u0011AEB\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002'E\t!R)\u001c2fI\u0012,GmS1gW\u0006\u001cE.^:uKJDa\u0001\u000b\u0001!\u0002\u0013\u0001\u0013a\u00049sSZ\fG/Z\"mkN$XM\u001d\u0011\t\u000b)\u0002A\u0011A\u0010\u0002\u000f\rdWo\u001d;fe\"\u0012\u0011\u0006\f\t\u0003[Aj\u0011A\f\u0006\u0003_1\tQA[;oSRL!!\r\u0018\u0003\tI+H.\u001a\u0005\bg\u0001\u0011\r\u0011\"\u00025\u0003-\tG.[4oK\u0012$\u0016.\\3\u0016\u0003U\u0002\"!\u0005\u001c\n\u0005]\u0012\"\u0001\u0002'p]\u001eDa!\u000f\u0001!\u0002\u001b)\u0014\u0001D1mS\u001etW\r\u001a+j[\u0016\u0004\u0003bB\u001e\u0001\u0005\u0004%\t\u0001P\u0001\t[>\u001c7\u000eV5nKV\tQ\b\u0005\u0002?\u00056\tqH\u0003\u0002\u0004\u0001*\u0011\u0011\tC\u0001\u0007G>lWn\u001c8\n\u0005\r{$\u0001C'pG.$\u0016.\\3\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003%iwnY6US6,\u0007\u0005C\u0004H\u0001\t\u0007I\u0011\u0001%\u0002\u000fQ4u\u000e\u001c3feV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M]\u0005)!/\u001e7fg&\u0011aj\u0013\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"1\u0001\u000b\u0001Q\u0001\n%\u000b\u0001\u0002\u001e$pY\u0012,'\u000f\t\u0005\u0006%\u0002!\t\u0001S\u0001\u000bi\u0016\u001cHOR8mI\u0016\u0014\bFA)-\u0011\u0015)\u0006\u0001\"\u0001W\u0003E\u0019H/\u0019:u\u0017\u000647.Y\"mkN$XM\u001d\u000b\u0002/B\u0011\u0011\u0003W\u0005\u00033J\u0011A!\u00168ji\"\u0012Ak\u0017\t\u0003[qK!!\u0018\u0018\u0003\r\t+gm\u001c:f\u0011\u0015y\u0006\u0001\"\u0001a\u0003]9W\r^*ue\u0016\fWn]\"p]\u001aLw-\u001e:bi&|g\u000eF\u0001b!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0003vi&d'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u000e\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015Q\u0007\u0001\"\u0003a\u0003q9W\r^+tKJ\u0014VmZ5p]N\u0004&o\u001c3vG\u0016\u00148i\u001c8gS\u001eDQ\u0001\u001c\u0001\u0005\n\u0001\f1dZ3u+N,'o\u00117jG.\u001c\bK]8ek\u000e,'oQ8oM&<\u0007\"\u00028\u0001\t\u0013\u0001\u0017!E4fi\u000e{gn];nKJ\u001cuN\u001c4jO\")\u0001\u000f\u0001C\u0001c\u0006y\u0001O]8ek\u000e,gjQ8ogVlW\rF\u0005s\u0003\u0003\t)!!\u0003\u0002\u000eA\u0019!m];\n\u0005Q\u001c'\u0001\u0002'jgR\u0004BA^<zk5\ta!\u0003\u0002y\r\tA1*Z=WC2,X\r\u0005\u0002{{:\u0011\u0011c_\u0005\u0003yJ\ta\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011AP\u0005\u0005\u0007\u0003\u0007y\u0007\u0019A=\u0002\u001fU\u001cXM]\"mS\u000e\\7\u000fV8qS\u000eDa!a\u0002p\u0001\u0004I\u0018\u0001E;tKJ\u0014VmZ5p]N$v\u000e]5d\u0011\u0019\tYa\u001ca\u0001s\u0006Yq.\u001e;qkR$v\u000e]5d\u0011%\tya\u001cI\u0001\u0002\u0004\t\t\"A\fxC&$H+\u001b7m%\u0016\u001cwN\u001d3t%\u0016\u001cW-\u001b<fIB\u0019\u0011#a\u0005\n\u0007\u0005U!CA\u0004C_>dW-\u00198\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0011!\u00079s_\u0012,8-\u001a(D_:\u001cX/\\3%I\u00164\u0017-\u001e7uIQ*\"!!\b+\t\u0005E\u0011qD\u0016\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0006\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0005\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001!a\r\u0002D\u0005\u0015\u0003\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u000bG\u0006$XmZ8sS\u0016\u001c(bAA\u001f]\u0005aQ\r\u001f9fe&lWM\u001c;bY&!\u0011\u0011IA\u001c\u0005!\u0019\u0015\r^3h_JL\u0018!\u0002<bYV,GFAA$G\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\ty\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0003\u0002T\u00055#aD%oi\u0016<'/\u0019;j_:$Vm\u001d;")
public class StreamToTableJoinScalaIntegrationTestBase
implements StreamToTableJoinTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String brokers;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final String outputTopic;
    private final String userClicksTopicJ;
    private final String userRegionsTopicJ;
    private final String outputTopicJ;
    private final Seq<KeyValue<String, Object>> userClicks;
    private final Seq<KeyValue<String, String>> userRegions;
    private final Seq<KeyValue<String, Object>> expectedClicksPerRegion;

    @Override
    public String brokers() {
        return this.brokers;
    }

    @Override
    public String userClicksTopic() {
        return this.userClicksTopic;
    }

    @Override
    public String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String userClicksTopicJ() {
        return this.userClicksTopicJ;
    }

    @Override
    public String userRegionsTopicJ() {
        return this.userRegionsTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public Seq<KeyValue<String, Object>> userClicks() {
        return this.userClicks;
    }

    @Override
    public Seq<KeyValue<String, String>> userRegions() {
        return this.userRegions;
    }

    @Override
    public Seq<KeyValue<String, Object>> expectedClicksPerRegion() {
        return this.expectedClicksPerRegion;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$brokers_$eq(String x$1) {
        this.brokers = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopic_$eq(String x$1) {
        this.userClicksTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopic_$eq(String x$1) {
        this.userRegionsTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicksTopicJ_$eq(String x$1) {
        this.userClicksTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegionsTopicJ_$eq(String x$1) {
        this.userRegionsTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userClicks_$eq(Seq x$1) {
        this.userClicks = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$userRegions_$eq(Seq x$1) {
        this.userRegions = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$utils$StreamToTableJoinTestData$_setter_$expectedClicksPerRegion_$eq(Seq x$1) {
        this.expectedClicksPerRegion = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.userClicksTopic());
        this.cluster().createTopic(this.userRegionsTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.userClicksTopicJ());
        this.cluster().createTopic(this.userRegionsTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    /*
     * WARNING - void declaration
     */
    public Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "stream-table-join-scala-integration-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "1000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserRegionsProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getUserClicksProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", LongSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "join-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    public List<KeyValue<String, Object>> produceNConsume(String userClicksTopic, String userRegionsTopic, String outputTopic, boolean waitTillRecordsReceived) {
        List list;
        Properties userRegionsProducerConfig = this.getUserRegionsProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userRegionsTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userRegions()).asJava()), (Properties)userRegionsProducerConfig, (Time)this.mockTime(), (boolean)false);
        Properties userClicksProducerConfig = this.getUserClicksProducerConfig();
        IntegrationTestUtils.produceKeyValuesSynchronously((String)userClicksTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.userClicks()).asJava()), (Properties)userClicksProducerConfig, (Time)this.mockTime(), (boolean)false);
        if (waitTillRecordsReceived) {
            Properties consumerConfig = this.getConsumerConfig();
            list = IntegrationTestUtils.waitUntilFinalKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.expectedClicksPerRegion()).asJava()));
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public boolean produceNConsume$default$4() {
        return true;
    }

    public StreamToTableJoinScalaIntegrationTestBase() {
        StreamToTableJoinTestData$class.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

