/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.Serdes$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.WordCountTestData;
import org.apache.kafka.streams.scala.WordCountTestData$class;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u0011QbV8sI\u000e{WO\u001c;UKN$(BA\u0002\u0005\u0003\u0015\u00198-\u00197b\u0015\t)a!A\u0004tiJ,\u0017-\\:\u000b\u0005\u001dA\u0011!B6bM.\f'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dM\u0001\"aD\t\u000e\u0003AQ\u0011aA\u0005\u0003%A\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005E9vN\u001d3D_VtG\u000fV3ti\u0012\u000bG/\u0019\u0005\u00061\u0001!\t!G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"\u0001\u0006\u0001\t\u000fq\u0001!\u0019!C\u0005;\u0005q\u0001O]5wCR,7\t\\;ti\u0016\u0014X#\u0001\u0010\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B;uS2\u001c(BA\u0012\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005\u0015\u0002#\u0001F#nE\u0016$G-\u001a3LC\u001a\\\u0017m\u00117vgR,'\u000f\u0003\u0004(\u0001\u0001\u0006IAH\u0001\u0010aJLg/\u0019;f\u00072,8\u000f^3sA!)\u0011\u0006\u0001C\u0001;\u000591\r\\;ti\u0016\u0014\bF\u0001\u0015,!\tas&D\u0001.\u0015\tq#\"A\u0003kk:LG/\u0003\u00021[\t!!+\u001e7f\u0011\u001d\u0011\u0004A1A\u0005\u0006M\n1\"\u00197jO:,G\rV5nKV\tA\u0007\u0005\u0002\u0010k%\u0011a\u0007\u0005\u0002\u0005\u0019>tw\r\u0003\u00049\u0001\u0001\u0006i\u0001N\u0001\rC2LwM\\3e)&lW\r\t\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0003!iwnY6US6,W#\u0001\u001f\u0011\u0005u\nU\"\u0001 \u000b\u0005\u0005z$B\u0001!\u0007\u0003\u0019\u0019w.\\7p]&\u0011!I\u0010\u0002\t\u001b>\u001c7\u000eV5nK\"1A\t\u0001Q\u0001\nq\n\u0011\"\\8dWRKW.\u001a\u0011\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u00069AOR8mI\u0016\u0014X#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-k\u0013!\u0002:vY\u0016\u001c\u0018BA'K\u0005=!V-\u001c9pe\u0006\u0014\u0018PR8mI\u0016\u0014\bBB(\u0001A\u0003%\u0001*\u0001\u0005u\r>dG-\u001a:!\u0011\u0015\t\u0006\u0001\"\u0001H\u0003)!Xm\u001d;G_2$WM\u001d\u0015\u0003!.BQ\u0001\u0016\u0001\u0005\u0002U\u000b\u0011c\u001d;beR\\\u0015MZ6b\u00072,8\u000f^3s)\u00051\u0006CA\bX\u0013\tA\u0006C\u0001\u0003V]&$\bFA*[!\ta3,\u0003\u0002][\t1!)\u001a4pe\u0016DQA\u0018\u0001\u0005\u0002U\u000bA\u0003^3tiNCw.\u001e7e\u0007>,h\u000e^,pe\u0012\u001c\bFA/a!\ta\u0013-\u0003\u0002c[\t!A+Z:u\u0011\u0015!\u0007\u0001\"\u0001V\u0003\u0001\"Xm\u001d;TQ>,H\u000eZ\"pk:$xk\u001c:eg6\u000bG/\u001a:jC2L'0\u001a3)\u0005\r\u0004\u0007\"B4\u0001\t\u0003)\u0016\u0001\u0007;fgR\u001c\u0006n\\;mI\u000e{WO\u001c;X_J$7OS1wC\"\u0012a\r\u0019\u0005\u0006U\u0002!Ia[\u0001\u0018O\u0016$8\u000b\u001e:fC6\u001c8i\u001c8gS\u001e,(/\u0019;j_:$\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA!\u001e;jY*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006k\u0002!Ia[\u0001\u0012O\u0016$\bK]8ek\u000e,'oQ8oM&<\u0007\"B<\u0001\t\u0013Y\u0017!E4fi\u000e{gn];nKJ\u001cuN\u001c4jO\")\u0011\u0010\u0001C\u0005u\u0006y\u0001O]8ek\u000e,gjQ8ogVlW\rF\u0003|\u0003'\t9\u0002E\u0002nyzL!! 8\u0003\t1K7\u000f\u001e\t\u0007\u007f\u0006\u0005\u0011Q\u0001\u001b\u000e\u0003\u0011I1!a\u0001\u0005\u0005!YU-\u001f,bYV,\u0007\u0003BA\u0004\u0003\u001bq1aDA\u0005\u0013\r\tY\u0001E\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0001\u0003C\u0004\u0002\u0016a\u0004\r!!\u0002\u0002\u0015%t\u0007/\u001e;U_BL7\rC\u0004\u0002\u001aa\u0004\r!!\u0002\u0002\u0017=,H\u000f];u)>\u0004\u0018n\u0019\u0015\b\u0001\u0005u\u0011QFA\u0018!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t!bY1uK\u001e|'/[3t\u0015\r\t9#L\u0001\rKb\u0004XM]5nK:$\u0018\r\\\u0005\u0005\u0003W\t\tC\u0001\u0005DCR,wm\u001c:z\u0003\u00151\u0018\r\\;fY\t\t\td\t\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0019\tA\u0001^3ti&!\u0011QHA\u001c\u0005=Ie\u000e^3he\u0006$\u0018n\u001c8UKN$\b")
public class WordCountTest
implements WordCountTestData {
    private final EmbeddedKafkaCluster privateCluster;
    private final long alignedTime;
    private final MockTime mockTime;
    private final TemporaryFolder tFolder;
    private final String inputTopic;
    private final String outputTopic;
    private final String inputTopicJ;
    private final String outputTopicJ;
    private final List<String> inputValues;
    private final List<KeyValue<String, Object>> expectedWordCounts;

    @Override
    public String inputTopic() {
        return this.inputTopic;
    }

    @Override
    public String outputTopic() {
        return this.outputTopic;
    }

    @Override
    public String inputTopicJ() {
        return this.inputTopicJ;
    }

    @Override
    public String outputTopicJ() {
        return this.outputTopicJ;
    }

    @Override
    public List<String> inputValues() {
        return this.inputValues;
    }

    @Override
    public List<KeyValue<String, Object>> expectedWordCounts() {
        return this.expectedWordCounts;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopic_$eq(String x$1) {
        this.inputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopic_$eq(String x$1) {
        this.outputTopic = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputTopicJ_$eq(String x$1) {
        this.inputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$outputTopicJ_$eq(String x$1) {
        this.outputTopicJ = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$inputValues_$eq(List x$1) {
        this.inputValues = x$1;
    }

    @Override
    public void org$apache$kafka$streams$scala$WordCountTestData$_setter_$expectedWordCounts_$eq(List x$1) {
        this.expectedWordCounts = x$1;
    }

    private EmbeddedKafkaCluster privateCluster() {
        return this.privateCluster;
    }

    @Rule
    public EmbeddedKafkaCluster cluster() {
        return this.privateCluster();
    }

    public final long alignedTime() {
        return this.alignedTime;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TemporaryFolder tFolder() {
        return this.tFolder;
    }

    @Rule
    public TemporaryFolder testFolder() {
        return this.tFolder();
    }

    @Before
    public void startKafkaCluster() {
        this.cluster().createTopic(this.inputTopic());
        this.cluster().createTopic(this.outputTopic());
        this.cluster().createTopic(this.inputTopicJ());
        this.cluster().createTopic(this.outputTopicJ());
    }

    @Test
    public void testShouldCountWords() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1)new Serializable(this, pattern){
            public static final long serialVersionUID = 0L;
            private final Pattern pattern$1;

            public final WrappedArray<String> apply(String v) {
                return Predef$.MODULE$.wrapRefArray((Object[])this.pattern$1.split(v.toLowerCase()));
            }
            {
                this.pattern$1 = pattern$1;
            }
        }).groupBy((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1, String v) {
                return v;
            }
        }, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$2) {
                return (String)x$2.key;
            }
        }, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$3) {
                return (String)x$3.key;
            }
        }, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsMaterialized() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        Pattern pattern = Pattern.compile("\\W+", 256);
        KTable wordCounts = textLines.flatMapValues((Function1)new Serializable(this, pattern){
            public static final long serialVersionUID = 0L;
            private final Pattern pattern$2;

            public final WrappedArray<String> apply(String v) {
                return Predef$.MODULE$.wrapRefArray((Object[])this.pattern$2.split(v.toLowerCase()));
            }
            {
                this.pattern$2 = pattern$2;
            }
        }).groupBy((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String k, String v) {
                return v;
            }
        }, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(Materialized$.MODULE$.as("word-count", Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        wordCounts.toStream().to(this.outputTopic(), ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopic(), this.outputTopic());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$4) {
                return (String)x$4.key;
            }
        }, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$5) {
                return (String)x$5.key;
            }
        }, (Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testShouldCountWordsJava() {
        Properties streamsConfiguration = this.getStreamsConfiguration();
        streamsConfiguration.put("default.key.serde", Serdes$.MODULE$.String().getClass().getName());
        streamsConfiguration.put("default.value.serde", Serdes$.MODULE$.String().getClass().getName());
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopicJ());
        Pattern pattern = Pattern.compile("\\W+", 256);
        org.apache.kafka.streams.kstream.KStream splits = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(this, pattern){
            private final Pattern pattern$3;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(Predef$.MODULE$.refArrayOps((Object[])this.pattern$3.split(s.toLowerCase())).toIterable()).asJava();
            }
            {
                this.pattern$3 = pattern$3;
            }
        });
        KGroupedStream grouped = splits.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(this){

            public String apply(String k, String v) {
                return v;
            }
        });
        org.apache.kafka.streams.kstream.KTable wordCounts = grouped.count();
        wordCounts.toStream().to(this.outputTopicJ(), Produced.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.JavaLong()));
        KafkaStreams streams = new KafkaStreams(streamBuilder.build(), streamsConfiguration);
        streams.start();
        java.util.List<KeyValue<String, Object>> actualWordCounts = this.produceNConsume(this.inputTopicJ(), this.outputTopicJ());
        streams.close();
        Assert.assertEquals((Object)((SeqLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualWordCounts).asScala()).take(this.expectedWordCounts().size())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$6) {
                return (String)x$6.key;
            }
        }, (Ordering)Ordering.String$.MODULE$), (Object)this.expectedWordCounts().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue<String, Object> x$7) {
                return (String)x$7.key;
            }
        }, (Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private Properties getStreamsConfiguration() {
        void var1_1;
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("application.id", "wordcount-test");
        streamsConfiguration.put("bootstrap.servers", this.cluster().bootstrapServers());
        streamsConfiguration.put("commit.interval.ms", "10000");
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("state.dir", this.testFolder().getRoot().getPath());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getProducerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("acks", "all");
        p.put("retries", "0");
        p.put("key.serializer", StringSerializer.class);
        p.put("value.serializer", StringSerializer.class);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties getConsumerConfig() {
        void var1_1;
        Properties p = new Properties();
        p.put("bootstrap.servers", this.cluster().bootstrapServers());
        p.put("group.id", "wordcount-scala-integration-test-standard-consumer");
        p.put("auto.offset.reset", "earliest");
        p.put("key.deserializer", StringDeserializer.class);
        p.put("value.deserializer", LongDeserializer.class);
        return var1_1;
    }

    private java.util.List<KeyValue<String, Object>> produceNConsume(String inputTopic, String outputTopic) {
        Properties linesProducerConfig = this.getProducerConfig();
        IntegrationTestUtils.produceValuesSynchronously((String)inputTopic, (Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.inputValues()).asJava()), (Properties)linesProducerConfig, (Time)this.mockTime());
        Properties consumerConfig = this.getConsumerConfig();
        return IntegrationTestUtils.waitUntilMinKeyValueRecordsReceived((Properties)consumerConfig, (String)outputTopic, (int)this.expectedWordCounts().size());
    }

    public WordCountTest() {
        WordCountTestData$class.$init$(this);
        this.privateCluster = new EmbeddedKafkaCluster(1);
        this.alignedTime = (System.currentTimeMillis() / 1000L + 1L) * 1000L;
        this.mockTime = this.cluster().time;
        this.mockTime().setCurrentTimeMs(this.alignedTime());
        this.tFolder = new TemporaryFolder(TestUtils.tempDirectory());
    }
}

