/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.scala;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TopologyDescription;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.scala.ImplicitConversions$;
import org.apache.kafka.streams.scala.Serdes$;
import org.apache.kafka.streams.scala.StreamsBuilder;
import org.apache.kafka.streams.scala.StreamsBuilder$;
import org.apache.kafka.streams.scala.kstream.Consumed$;
import org.apache.kafka.streams.scala.kstream.Grouped$;
import org.apache.kafka.streams.scala.kstream.Joined$;
import org.apache.kafka.streams.scala.kstream.KStream;
import org.apache.kafka.streams.scala.kstream.KTable;
import org.apache.kafka.streams.scala.kstream.Materialized$;
import org.apache.kafka.streams.scala.kstream.Produced$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u001b\taAk\u001c9pY><\u0017\u0010V3ti*\u00111\u0001B\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000b\u0019\tqa\u001d;sK\u0006l7O\u0003\u0002\b\u0011\u0005)1.\u00194lC*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\tR\"\u0001\t\u000b\u0003\rI!A\u0005\t\u0003\r\u0005s\u0017PU3g\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\t!\u0001C\u0004\u001a\u0001\t\u0007I\u0011\u0002\u000e\u0002\u0015%t\u0007/\u001e;U_BL7-F\u0001\u001c!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003mC:<'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011aa\u0015;sS:<\u0007B\u0002\u0013\u0001A\u0003%1$A\u0006j]B,H\u000fV8qS\u000e\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%IAG\u0001\u0010kN,'o\u00117jG.\u001cHk\u001c9jG\"1\u0001\u0006\u0001Q\u0001\nm\t\u0001#^:fe\u000ec\u0017nY6t)>\u0004\u0018n\u0019\u0011\t\u000f)\u0002!\u0019!C\u00055\u0005\u0001Ro]3s%\u0016<\u0017n\u001c8t)>\u0004\u0018n\u0019\u0005\u0007Y\u0001\u0001\u000b\u0011B\u000e\u0002#U\u001cXM\u001d*fO&|gn\u001d+pa&\u001c\u0007\u0005C\u0004/\u0001\t\u0007I\u0011B\u0018\u0002\u000fA\fG\u000f^3s]V\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005)!/Z4fq*\u0011QgH\u0001\u0005kRLG.\u0003\u00028e\t9\u0001+\u0019;uKJt\u0007BB\u001d\u0001A\u0003%\u0001'\u0001\u0005qCR$XM\u001d8!\u0011\u0015Y\u0004\u0001\"\u0001=\u00039\u001a\bn\\;mI\n+\u0018\u000e\u001c3JI\u0016tG/[2bYR{\u0007o\u001c7pOfLeNS1wC:\u001b6-\u00197b'&l\u0007\u000f\\3\u0015\u0003u\u0002\"a\u0004 \n\u0005}\u0002\"\u0001B+oSRD#AO!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011S\u0011!\u00026v]&$\u0018B\u0001$D\u0005\u0011!Vm\u001d;\t\u000b!\u0003A\u0011\u0001\u001f\u0002cMDw.\u001e7e\u0005VLG\u000eZ%eK:$\u0018nY1m)>\u0004x\u000e\\8hs&s'*\u0019<b\u001dN\u001b\u0017\r\\1BO\u001e\u0014XmZ1uK\"\u0012q)\u0011\u0005\u0006\u0017\u0002!\t\u0001P\u0001-g\"|W\u000f\u001c3Ck&dG-\u00133f]RL7-\u00197U_B|Gn\\4z\u0013:T\u0015M^1O'\u000e\fG.\u0019&pS:D#AS!\t\u000b9\u0003A\u0011\u0001\u001f\u0002cMDw.\u001e7e\u0005VLG\u000eZ%eK:$\u0018nY1m)>\u0004x\u000e\\8hs&s'*\u0019<b\u001dN\u001b\u0017\r\\1Ue\u0006t7OZ8s[\"\u0012Q*\u0011\u0005\u0006#\u0002!\t\u0001P\u00013g\"|W\u000f\u001c3Ck&dG-\u00133f]RL7-\u00197U_B|Gn\\4z\u0013:T\u0015M^1O'\u000e\fG.\u0019)s_B,'\u000f^5fg\"\u0012\u0001+\u0011\u0004\u0005)\u0002!QKA\bTS6\u0004H.\u001a)s_\u000e,7o]8s'\t\u0019f\u000b\u0005\u0003X5rcV\"\u0001-\u000b\u0005e#\u0011!\u00039s_\u000e,7o]8s\u0013\tY\u0006LA\tBEN$(/Y2u!J|7-Z:t_J\u0004\"!\u00181\u000f\u0005=q\u0016BA0\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!%\u0019\u0006\u0003?BA\u0001bY*\u0003\u0006\u0004%\t\u0001Z\u0001\nm\u0006dW/\u001a'jgR,\u0012!\u001a\t\u0004M\u001edV\"\u0001\u001b\n\u0005!$$\u0001\u0002'jgRD\u0001B[*\u0003\u0002\u0003\u0006I!Z\u0001\u000bm\u0006dW/\u001a'jgR\u0004\u0003B\u0002\u000bT\t\u0003\u0001A\u000e\u0006\u0002n_B\u0011anU\u0007\u0002\u0001!)1m\u001ba\u0001K\")\u0011o\u0015C!e\u00069\u0001O]8dKN\u001cHcA\u001ftk\")A\u000f\u001da\u00019\u0006\u00191.Z=\t\u000bY\u0004\b\u0019\u0001/\u0002\u000bY\fG.^3")
public class TopologyTest {
    private final String inputTopic;
    private final String userClicksTopic;
    private final String userRegionsTopic;
    private final Pattern org$apache$kafka$streams$scala$TopologyTest$$pattern = Pattern.compile("\\W+", 256);

    private String inputTopic() {
        return this.inputTopic;
    }

    private String userClicksTopic() {
        return this.userClicksTopic;
    }

    private String userRegionsTopic() {
        return this.userRegionsTopic;
    }

    public Pattern org$apache$kafka$streams$scala$TopologyTest$$pattern() {
        return this.org$apache$kafka$streams$scala$TopologyTest$$pattern;
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaSimple() {
        Assert.assertEquals((Object)this.getTopologyScala$1(), (Object)this.getTopologyJava$1());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaAggregate() {
        Assert.assertEquals((Object)this.getTopologyScala$2(), (Object)this.getTopologyJava$2());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaJoin() {
        Assert.assertEquals((Object)this.getTopologyScala$3(), (Object)this.getTopologyJava$3());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaTransform() {
        Assert.assertEquals((Object)this.getTopologyScala$4(), (Object)this.getTopologyJava$4());
    }

    @Test
    public void shouldBuildIdenticalTopologyInJavaNScalaProperties() {
        Properties props = new Properties();
        props.put("topology.optimization", "all");
        Properties propsNoOptimization = new Properties();
        propsNoOptimization.put("topology.optimization", "none");
        String AGGREGATION_TOPIC = "aggregationTopic";
        String REDUCE_TOPIC = "reduceTopic";
        String JOINED_TOPIC = "joinedTopic";
        Assert.assertNotEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString(), (Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString());
        Assert.assertEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString(), (Object)this.getTopologyJava$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(propsNoOptimization).describe().toString());
        Assert.assertEquals((Object)this.getTopologyScala$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString(), (Object)this.getTopologyJava$5(AGGREGATION_TOPIC, REDUCE_TOPIC, JOINED_TOPIC).build(props).describe().toString());
    }

    private final TopologyDescription getTopologyScala$1() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KStream _ = textLines.flatMapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopologyTest $outer;

            public final WrappedArray<String> apply(String v) {
                return Predef$.MODULE$.wrapRefArray((Object[])this.$outer.org$apache$kafka$streams$scala$TopologyTest$$pattern().split(v.toLowerCase()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$1() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream _ = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(this){
            private final /* synthetic */ TopologyTest $outer;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$kafka$streams$scala$TopologyTest$$pattern().split(s.toLowerCase())).toIterable()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyScala$2() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KTable _ = textLines.flatMapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopologyTest $outer;

            public final WrappedArray<String> apply(String v) {
                return Predef$.MODULE$.wrapRefArray((Object[])this.$outer.org$apache$kafka$streams$scala$TopologyTest$$pattern().split(v.toLowerCase()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).groupBy((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1, String v) {
                return v;
            }
        }, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$2() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream splits = textLines.flatMapValues((ValueMapper)new ValueMapper<String, Iterable<String>>(this){
            private final /* synthetic */ TopologyTest $outer;

            public Iterable<String> apply(String s) {
                return (Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$kafka$streams$scala$TopologyTest$$pattern().split(s.toLowerCase())).toIterable()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        KGroupedStream grouped = splits.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(this){

            public String apply(String k, String v) {
                return v;
            }
        });
        grouped.count();
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyScala$3() {
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream userClicksStream = builder.stream(this.userClicksTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        KTable userRegionsTable = builder.table(this.userRegionsTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        userClicksStream.leftJoin(userRegionsTable, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(long clicks, String region) {
                return new Tuple2((Object)(region == null ? "UNKNOWN" : region), (Object)BoxesRunTime.boxToLong((long)clicks));
            }
        }, ImplicitConversions$.MODULE$.joinedFromKeyValueOtherSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long(), Serdes$.MODULE$.String())).map((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String x$2, Tuple2<String, Object> regionWithClicks) {
                return regionWithClicks;
            }
        }).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$3, long x$4) {
                return this.apply$mcJJJ$sp(x$3, x$4);
            }

            public long apply$mcJJJ$sp(long x$3, long x$4) {
                return x$3 + x$4;
            }
        }, ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return builder.build().describe();
    }

    private final TopologyDescription getTopologyJava$3() {
        org.apache.kafka.streams.StreamsBuilder builder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream userClicksStream = builder.stream(this.userClicksTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong()));
        org.apache.kafka.streams.kstream.KTable userRegionsTable = builder.table(this.userRegionsTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream userClicksJoinRegion = userClicksStream.leftJoin(userRegionsTable, (ValueJoiner)new ValueJoiner<Long, String, Tuple2<String, Long>>(this){

            public Tuple2<String, Long> apply(Long clicks, String region) {
                return new Tuple2((Object)(region == null ? "UNKNOWN" : region), (Object)clicks);
            }
        }, Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream clicksByRegion = userClicksJoinRegion.map((KeyValueMapper)new KeyValueMapper<String, Tuple2<String, Long>, KeyValue<String, Long>>(this){

            public KeyValue<String, Long> apply(String k, Tuple2<String, Long> regionWithClicks) {
                return new KeyValue(regionWithClicks._1(), regionWithClicks._2());
            }
        });
        clicksByRegion.groupByKey(Grouped$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.JavaLong())).reduce((Reducer)new Reducer<Long>(this){

            public Long apply(Long v1, Long v2) {
                return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(v1) + Predef$.MODULE$.Long2long(v2));
            }
        });
        return builder.build().describe();
    }

    private final TopologyDescription getTopologyScala$4() {
        StreamsBuilder streamBuilder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream textLines = streamBuilder.stream(this.inputTopic(), ImplicitConversions$.MODULE$.consumedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KTable _ = textLines.transform((TransformerSupplier)new TransformerSupplier<String, String, KeyValue<String, String>>(this){

            public Transformer<String, String, KeyValue<String, String>> get() {
                return new Transformer<String, String, KeyValue<String, String>>(this){

                    public void init(ProcessorContext context) {
                    }

                    public KeyValue<String, String> transform(String key, String value) {
                        return new KeyValue((Object)key, (Object)value.toLowerCase());
                    }

                    public void close() {
                    }
                };
            }
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).groupBy((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$5, String v) {
                return v;
            }
        }, ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).count(ImplicitConversions$.MODULE$.materializedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.Long()));
        return streamBuilder.build().describe();
    }

    private final TopologyDescription getTopologyJava$4() {
        org.apache.kafka.streams.StreamsBuilder streamBuilder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream textLines = streamBuilder.stream(this.inputTopic());
        org.apache.kafka.streams.kstream.KStream lowered = textLines.transform((TransformerSupplier)new TransformerSupplier<String, String, KeyValue<String, String>>(this){

            public Transformer<String, String, KeyValue<String, String>> get() {
                return new Transformer<String, String, KeyValue<String, String>>(this){

                    public void init(ProcessorContext context) {
                    }

                    public KeyValue<String, String> transform(String key, String value) {
                        return new KeyValue((Object)key, (Object)value.toLowerCase());
                    }

                    public void close() {
                    }
                };
            }
        }, new String[0]);
        KGroupedStream grouped = lowered.groupBy((KeyValueMapper)new KeyValueMapper<String, String, String>(this){

            public String apply(String k, String v) {
                return v;
            }
        });
        grouped.count();
        return streamBuilder.build().describe();
    }

    private final StreamsBuilder getTopologyScala$5(String AGGREGATION_TOPIC$1, String REDUCE_TOPIC$1, String JOINED_TOPIC$1) {
        Serializable aggregator = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$6, String v, int agg) {
                return agg + v.length();
            }
        };
        Serializable reducer = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String v1, String v2) {
                return new StringBuilder().append((Object)v1).append((Object)":").append((Object)v2).toString();
            }
        };
        ArrayList processorValueCollector = new ArrayList();
        StreamsBuilder builder = new StreamsBuilder(StreamsBuilder$.MODULE$.$lessinit$greater$default$1());
        KStream sourceStream = builder.stream(this.inputTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        KStream mappedStream = sourceStream.map((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String k, String v) {
                return new Tuple2((Object)k.toUpperCase(Locale.getDefault()), (Object)v);
            }
        });
        mappedStream.filter((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String k, String x$7) {
                String string = k;
                String string2 = "B";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String v) {
                return v.toUpperCase(Locale.getDefault());
            }
        }).process((Function0)new Serializable(this, processorValueCollector){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopologyTest $outer;
            private final List processorValueCollector$1;

            public final SimpleProcessor apply() {
                return new SimpleProcessor(this.$outer, this.processorValueCollector$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processorValueCollector$1 = processorValueCollector$1;
            }
        }, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        KStream stream2 = mappedStream.groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).aggregate((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }, (Function3)aggregator, Materialized$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer())).toStream();
        stream2.to(AGGREGATION_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer()));
        KStream stream3 = mappedStream.filter((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8, String x$9) {
                return true;
            }
        }).peek((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String k, String v) {
                System.out.println(new StringBuilder().append((Object)k).append((Object)":").append((Object)v).toString());
            }
        }).groupByKey(ImplicitConversions$.MODULE$.groupedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).reduce((Function2)reducer, Materialized$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).toStream();
        stream3.to(REDUCE_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String k, String x$10) {
                String string = k;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream2, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String v1, int v2) {
                return new StringBuilder().append((Object)v1).append((Object)":").append((Object)((Object)BoxesRunTime.boxToInteger((int)v2)).toString()).toString();
            }
        }, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String(), Serdes$.MODULE$.Integer())).to(JOINED_TOPIC$1, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String k, String x$11) {
                String string = k;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream3, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String v1, String v2) {
                return new StringBuilder().append((Object)v1).append((Object)":").append((Object)v2.toString()).toString();
            }
        }, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String(), Serdes$.MODULE$.String())).to(JOINED_TOPIC$1, ImplicitConversions$.MODULE$.producedFromSerde(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        return builder;
    }

    private final org.apache.kafka.streams.StreamsBuilder getTopologyJava$5(String AGGREGATION_TOPIC$1, String REDUCE_TOPIC$1, String JOINED_TOPIC$1) {
        KeyValueMapper<String, String, KeyValue<String, String>> keyValueMapper = new KeyValueMapper<String, String, KeyValue<String, String>>(this){

            public KeyValue<String, String> apply(String key, String value) {
                return KeyValue.pair((Object)key.toUpperCase(Locale.getDefault()), (Object)value);
            }
        };
        Initializer<Integer> initializer = new Initializer<Integer>(this){

            public Integer apply() {
                return Predef$.MODULE$.int2Integer(0);
            }
        };
        Aggregator<String, String, Integer> aggregator = new Aggregator<String, String, Integer>(this){

            public Integer apply(String key, String value, Integer aggregate) {
                return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(aggregate) + value.length());
            }
        };
        Reducer<String> reducer = new Reducer<String>(this){

            public String apply(String v1, String v2) {
                return new StringBuilder().append((Object)v1).append((Object)":").append((Object)v2).toString();
            }
        };
        ValueMapper<String, String> valueMapper = new ValueMapper<String, String>(this){

            public String apply(String v) {
                return v.toUpperCase(Locale.getDefault());
            }
        };
        ArrayList processorValueCollector = new ArrayList();
        ProcessorSupplier<String, String> processorSupplier = new ProcessorSupplier<String, String>(this, processorValueCollector){
            private final /* synthetic */ TopologyTest $outer;
            private final ArrayList processorValueCollector$2;

            public SimpleProcessor get() {
                return new SimpleProcessor(this.$outer, this.processorValueCollector$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processorValueCollector$2 = processorValueCollector$2;
            }
        };
        ValueJoiner<String, Integer, String> valueJoiner2 = new ValueJoiner<String, Integer, String>(this){

            public String apply(String value1, Integer value2) {
                return new StringBuilder().append((Object)value1).append((Object)":").append((Object)value2.toString()).toString();
            }
        };
        ValueJoiner<String, String, String> valueJoiner3 = new ValueJoiner<String, String, String>(this){

            public String apply(String value1, String value2) {
                return new StringBuilder().append((Object)value1).append((Object)":").append((Object)value2.toString()).toString();
            }
        };
        org.apache.kafka.streams.StreamsBuilder builder = new org.apache.kafka.streams.StreamsBuilder();
        org.apache.kafka.streams.kstream.KStream sourceStream = builder.stream(this.inputTopic(), Consumed$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        org.apache.kafka.streams.kstream.KStream mappedStream = sourceStream.map((KeyValueMapper)keyValueMapper);
        mappedStream.filter((Predicate)new Predicate<String, String>(this){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "B";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).mapValues((ValueMapper)valueMapper).process((ProcessorSupplier)processorSupplier, new String[0]);
        org.apache.kafka.streams.kstream.KStream stream2 = mappedStream.groupByKey().aggregate((Initializer)initializer, (Aggregator)aggregator, Materialized.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes.Integer())).toStream();
        stream2.to(AGGREGATION_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes.Integer()));
        org.apache.kafka.streams.kstream.KStream stream3 = mappedStream.filter((Predicate)new Predicate<String, String>(this){

            public boolean test(String k, String v) {
                return true;
            }
        }).peek((ForeachAction)new ForeachAction<String, String>(this){

            public void apply(String k, String v) {
                System.out.println(new StringBuilder().append((Object)k).append((Object)":").append((Object)v).toString());
            }
        }).groupByKey().reduce((Reducer)reducer, Materialized.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String())).toStream();
        stream3.to(REDUCE_TOPIC$1, Produced$.MODULE$.with(Serdes$.MODULE$.String(), Serdes$.MODULE$.String()));
        mappedStream.filter((Predicate)new Predicate<String, String>(this){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream2, (ValueJoiner)valueJoiner2, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String(), (Serde)Serdes.Integer())).to(JOINED_TOPIC$1);
        mappedStream.filter((Predicate)new Predicate<String, String>(this){

            public boolean test(String key, String value) {
                String string = key;
                String string2 = "A";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).join(stream3, (ValueJoiner)valueJoiner3, JoinWindows.of((Duration)Duration.ofMillis(5000L)), Joined.with((Serde)Serdes$.MODULE$.String(), (Serde)Serdes$.MODULE$.String(), (Serde)Serdes.String())).to(JOINED_TOPIC$1);
        return builder;
    }

    public TopologyTest() {
        this.inputTopic = "input-topic";
        this.userClicksTopic = "user-clicks-topic";
        this.userRegionsTopic = "user-regions-topic";
    }

    public class SimpleProcessor
    extends AbstractProcessor<String, String> {
        private final List<String> valueList;
        public final /* synthetic */ TopologyTest $outer;

        public List<String> valueList() {
            return this.valueList;
        }

        public void process(String key, String value) {
            this.valueList().add(value);
        }

        public /* synthetic */ TopologyTest org$apache$kafka$streams$scala$TopologyTest$SimpleProcessor$$$outer() {
            return this.$outer;
        }

        public SimpleProcessor(TopologyTest $outer, List<String> valueList) {
            this.valueList = valueList;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

