/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.examples.wordcount.WordCountTransformerDemo;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.StoreBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WordCountTransformerTest {
    @Test
    public void test() {
        final MockProcessorContext context = new MockProcessorContext();
        WordCountTransformerDemo.MyProcessorSupplier supplier = new WordCountTransformerDemo.MyProcessorSupplier();
        for (StoreBuilder storeBuilder : supplier.stores()) {
            StateStore store = storeBuilder.withLoggingDisabled().build();
            store.init(context.getStateStoreContext(), store);
            context.getStateStoreContext().register(store, null);
        }
        Processor processor = supplier.get();
        processor.init((ProcessorContext)new MockProcessorContext<String, String>(){

            public <S extends StateStore> S getStateStore(String name) {
                return (S)context.getStateStore(name);
            }

            public <K extends String, V extends String> void forward(Record<K, V> record) {
                context.forward(record);
            }

            public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) {
                return context.schedule(interval, type, callback);
            }
        });
        Record record = new Record((Object)"key", (Object)"alpha beta\tgamma\n\talpha", 0L);
        processor.process(record);
        Assertions.assertTrue((boolean)context.forwarded().isEmpty());
        ((MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0)).getPunctuator().punctuate(0L);
        List capturedForwards = context.forwarded();
        List<MockProcessorContext.CapturedForward> expected = Arrays.asList(new MockProcessorContext.CapturedForward(new Record((Object)"alpha", (Object)"2", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"beta", (Object)"1", 0L)), new MockProcessorContext.CapturedForward(new Record((Object)"gamma", (Object)"1", 0L)));
        MatcherAssert.assertThat((Object)capturedForwards, (Matcher)Matchers.is(expected));
    }
}

